"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unkey.py.types import BaseModel


class V2ApisListKeysRequestBodyTypedDict(TypedDict):
    api_id: str
    r"""The API namespace whose keys you want to list.
    Returns all keys in this API, subject to pagination and filters.

    """
    limit: NotRequired[int]
    r"""Maximum number of keys to return per request.
    Balance between response size and number of pagination calls needed.

    """
    cursor: NotRequired[str]
    r"""Pagination cursor from previous response to fetch next page.
    Use when `hasMore: true` in previous response.

    """
    external_id: NotRequired[str]
    r"""Filter keys by external ID to find keys for a specific user or entity.
    Must exactly match the externalId set during key creation.

    """
    decrypt: NotRequired[bool]
    r"""When true, attempts to include the plaintext key value in the response. SECURITY WARNING:
    - This requires special permissions on the calling root key
    - Only works for keys created with 'recoverable: true'
    - Exposes sensitive key material in the response
    - Should only be used in secure administrative contexts
    - Never enable this in user-facing applications
    """
    revalidate_keys_cache: NotRequired[bool]
    r"""EXPERIMENTAL: Skip the cache and fetch the keys directly from the database. This ensures you see the most recent state, including keys created moments ago. Use this when:
    - You've just created a key and need to display it immediately
    - You need absolute certainty about the current key state
    - You're debugging cache consistency issues

    This parameter comes with a performance cost and should be used sparingly.
    """


class V2ApisListKeysRequestBody(BaseModel):
    api_id: Annotated[str, pydantic.Field(alias="apiId")]
    r"""The API namespace whose keys you want to list.
    Returns all keys in this API, subject to pagination and filters.

    """

    limit: Optional[int] = 100
    r"""Maximum number of keys to return per request.
    Balance between response size and number of pagination calls needed.

    """

    cursor: Optional[str] = None
    r"""Pagination cursor from previous response to fetch next page.
    Use when `hasMore: true` in previous response.

    """

    external_id: Annotated[Optional[str], pydantic.Field(alias="externalId")] = None
    r"""Filter keys by external ID to find keys for a specific user or entity.
    Must exactly match the externalId set during key creation.

    """

    decrypt: Optional[bool] = False
    r"""When true, attempts to include the plaintext key value in the response. SECURITY WARNING:
    - This requires special permissions on the calling root key
    - Only works for keys created with 'recoverable: true'
    - Exposes sensitive key material in the response
    - Should only be used in secure administrative contexts
    - Never enable this in user-facing applications
    """

    revalidate_keys_cache: Annotated[
        Optional[bool], pydantic.Field(alias="revalidateKeysCache")
    ] = False
    r"""EXPERIMENTAL: Skip the cache and fetch the keys directly from the database. This ensures you see the most recent state, including keys created moments ago. Use this when:
    - You've just created a key and need to display it immediately
    - You need absolute certainty about the current key state
    - You're debugging cache consistency issues

    This parameter comes with a performance cost and should be used sparingly.
    """
