"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .ratelimitrequest import RatelimitRequest, RatelimitRequestTypedDict
import pydantic
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unkey.py.types import BaseModel


class V2IdentitiesUpdateIdentityRequestBodyTypedDict(TypedDict):
    external_id: str
    r"""Specifies which identity to update using your system's identifier from identity creation.
    Use this when you track identities by your own user IDs, organization IDs, or tenant identifiers.
    Accepts letters, numbers, underscores, dots, and hyphens for flexible identifier formats.

    """
    meta: NotRequired[Dict[str, Any]]
    r"""Replaces all existing metadata with this new metadata object.
    Omitting this field preserves existing metadata, while providing an empty object clears all metadata.
    Avoid storing sensitive data here as it's returned in verification responses.
    Large metadata objects increase verification latency and should stay under 10KB total size.

    """
    ratelimits: NotRequired[List[RatelimitRequestTypedDict]]
    r"""Replaces all existing identity rate limits with this complete list of rate limits.
    Omitting this field preserves existing rate limits, while providing an empty array removes all rate limits.
    These limits are shared across all keys belonging to this identity, preventing abuse through multiple keys.
    Rate limit changes take effect immediately but may take up to 30 seconds to propagate across all regions.

    """


class V2IdentitiesUpdateIdentityRequestBody(BaseModel):
    external_id: Annotated[str, pydantic.Field(alias="externalId")]
    r"""Specifies which identity to update using your system's identifier from identity creation.
    Use this when you track identities by your own user IDs, organization IDs, or tenant identifiers.
    Accepts letters, numbers, underscores, dots, and hyphens for flexible identifier formats.

    """

    meta: Optional[Dict[str, Any]] = None
    r"""Replaces all existing metadata with this new metadata object.
    Omitting this field preserves existing metadata, while providing an empty object clears all metadata.
    Avoid storing sensitive data here as it's returned in verification responses.
    Large metadata objects increase verification latency and should stay under 10KB total size.

    """

    ratelimits: Optional[List[RatelimitRequest]] = None
    r"""Replaces all existing identity rate limits with this complete list of rate limits.
    Omitting this field preserves existing rate limits, while providing an empty array removes all rate limits.
    These limits are shared across all keys belonging to this identity, preventing abuse through multiple keys.
    Rate limit changes take effect immediately but may take up to 30 seconds to propagate across all regions.

    """
