"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import pydantic
from typing import List
from typing_extensions import Annotated, TypedDict
from unkey.py.types import BaseModel


class V2KeysAddRolesRequestBodyTypedDict(TypedDict):
    key_id: str
    r"""Specifies which key receives the additional roles using the database identifier returned from `createKey`.
    Do not confuse this with the actual API key string that users include in requests.
    Added roles supplement existing roles and permissions without replacing them.
    Role assignments take effect immediately but may take up to 30 seconds to propagate across all regions.

    """
    roles: List[str]
    r"""Assigns additional roles to the key through direct assignment to existing workspace roles.
    Operations are idempotent - adding existing roles has no effect and causes no errors.

    All roles must already exist in the workspace - roles cannot be created automatically.
    Invalid roles cause the entire operation to fail atomically, ensuring consistent state.

    """


class V2KeysAddRolesRequestBody(BaseModel):
    key_id: Annotated[str, pydantic.Field(alias="keyId")]
    r"""Specifies which key receives the additional roles using the database identifier returned from `createKey`.
    Do not confuse this with the actual API key string that users include in requests.
    Added roles supplement existing roles and permissions without replacing them.
    Role assignments take effect immediately but may take up to 30 seconds to propagate across all regions.

    """

    roles: List[str]
    r"""Assigns additional roles to the key through direct assignment to existing workspace roles.
    Operations are idempotent - adding existing roles has no effect and causes no errors.

    All roles must already exist in the workspace - roles cannot be created automatically.
    Invalid roles cause the entire operation to fail atomically, ensuring consistent state.

    """
