"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .keycreditsdata import KeyCreditsData, KeyCreditsDataTypedDict
from .ratelimitrequest import RatelimitRequest, RatelimitRequestTypedDict
import pydantic
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unkey.py.types import BaseModel


class V2KeysCreateKeyRequestBodyTypedDict(TypedDict):
    api_id: str
    r"""The API namespace this key belongs to.
    Keys from different APIs cannot access each other.

    """
    prefix: NotRequired[str]
    r"""Adds a visual identifier to the beginning of the generated key for easier recognition in logs and dashboards.
    The prefix becomes part of the actual key string (e.g., `prod_xxxxxxxxx`).
    Avoid using sensitive information in prefixes as they may appear in logs and error messages.

    """
    name: NotRequired[str]
    r"""Sets a human-readable identifier for internal organization and dashboard display.
    Never exposed to end users, only visible in management interfaces and API responses.
    Avoid generic names like \"API Key\" when managing multiple keys for the same user or service.

    """
    byte_length: NotRequired[int]
    r"""Controls the cryptographic strength of the generated key in bytes.
    Higher values increase security but result in longer keys that may be more annoying to handle.
    The default 16 bytes provides 2^128 possible combinations, sufficient for most applications.
    Consider 32 bytes for highly sensitive APIs, but avoid values above 64 bytes unless specifically required.

    """
    external_id: NotRequired[str]
    r"""Links this key to a user or entity in your system using your own identifier.
    Returned during verification to identify the key owner without additional database lookups.
    Essential for user-specific analytics, billing, and multi-tenant key management.
    Use your primary user ID, organization ID, or tenant ID for best results.
    Accepts letters, numbers, underscores, dots, and hyphens for flexible identifier formats.

    """
    meta: NotRequired[Dict[str, Any]]
    r"""Stores arbitrary JSON metadata returned during key verification for contextual information.
    Eliminates additional database lookups during verification, improving performance for stateless services.
    Avoid storing sensitive data here as it's returned in verification responses.
    Large metadata objects increase verification latency and should stay under 10KB total size.

    """
    roles: NotRequired[List[str]]
    r"""Assigns existing roles to this key for permission management through role-based access control.
    Roles must already exist in your workspace before assignment.
    During verification, all permissions from assigned roles are checked against requested permissions.
    Roles provide a convenient way to group permissions and apply consistent access patterns across multiple keys.

    """
    permissions: NotRequired[List[str]]
    r"""Grants specific permissions directly to this key without requiring role membership.
    Wildcard permissions like `documents.*` grant access to all sub-permissions including `documents.read` and `documents.write`.
    Direct permissions supplement any permissions inherited from assigned roles.

    """
    expires: NotRequired[int]
    r"""Sets when this key automatically expires as a Unix timestamp in milliseconds.
    Verification fails with code=EXPIRED immediately after this time passes.
    Omitting this field creates a permanent key that never expires.

    Avoid setting timestamps in the past as they immediately invalidate the key.
    Keys expire based on server time, not client time, which prevents timezone-related issues.
    Essential for trial periods, temporary access, and security compliance requiring key rotation.

    """
    credits: NotRequired[KeyCreditsDataTypedDict]
    r"""Credit configuration and remaining balance for this key."""
    ratelimits: NotRequired[List[RatelimitRequestTypedDict]]
    r"""Defines time-based rate limits that protect against abuse by controlling request frequency.
    Unlike credits which track total usage, rate limits reset automatically after each window expires.
    Multiple rate limits can control different operation types with separate thresholds and windows.
    Essential for preventing API abuse while maintaining good performance for legitimate usage.

    """
    enabled: NotRequired[bool]
    r"""Controls whether the key is active immediately upon creation.
    When set to `false`, the key exists but all verification attempts fail with `code=DISABLED`.
    Useful for pre-creating keys that will be activated later or for keys requiring manual approval.
    Most keys should be created with `enabled=true` for immediate use.

    """
    recoverable: NotRequired[bool]
    r"""Controls whether the plaintext key is stored in an encrypted vault for later retrieval.
    When true, allows recovering the actual key value using keys.getKey with decrypt=true.
    When false, the key value cannot be retrieved after creation for maximum security.
    Only enable for development keys or when key recovery is absolutely necessary.

    """


class V2KeysCreateKeyRequestBody(BaseModel):
    api_id: Annotated[str, pydantic.Field(alias="apiId")]
    r"""The API namespace this key belongs to.
    Keys from different APIs cannot access each other.

    """

    prefix: Optional[str] = None
    r"""Adds a visual identifier to the beginning of the generated key for easier recognition in logs and dashboards.
    The prefix becomes part of the actual key string (e.g., `prod_xxxxxxxxx`).
    Avoid using sensitive information in prefixes as they may appear in logs and error messages.

    """

    name: Optional[str] = None
    r"""Sets a human-readable identifier for internal organization and dashboard display.
    Never exposed to end users, only visible in management interfaces and API responses.
    Avoid generic names like \"API Key\" when managing multiple keys for the same user or service.

    """

    byte_length: Annotated[Optional[int], pydantic.Field(alias="byteLength")] = 16
    r"""Controls the cryptographic strength of the generated key in bytes.
    Higher values increase security but result in longer keys that may be more annoying to handle.
    The default 16 bytes provides 2^128 possible combinations, sufficient for most applications.
    Consider 32 bytes for highly sensitive APIs, but avoid values above 64 bytes unless specifically required.

    """

    external_id: Annotated[Optional[str], pydantic.Field(alias="externalId")] = None
    r"""Links this key to a user or entity in your system using your own identifier.
    Returned during verification to identify the key owner without additional database lookups.
    Essential for user-specific analytics, billing, and multi-tenant key management.
    Use your primary user ID, organization ID, or tenant ID for best results.
    Accepts letters, numbers, underscores, dots, and hyphens for flexible identifier formats.

    """

    meta: Optional[Dict[str, Any]] = None
    r"""Stores arbitrary JSON metadata returned during key verification for contextual information.
    Eliminates additional database lookups during verification, improving performance for stateless services.
    Avoid storing sensitive data here as it's returned in verification responses.
    Large metadata objects increase verification latency and should stay under 10KB total size.

    """

    roles: Optional[List[str]] = None
    r"""Assigns existing roles to this key for permission management through role-based access control.
    Roles must already exist in your workspace before assignment.
    During verification, all permissions from assigned roles are checked against requested permissions.
    Roles provide a convenient way to group permissions and apply consistent access patterns across multiple keys.

    """

    permissions: Optional[List[str]] = None
    r"""Grants specific permissions directly to this key without requiring role membership.
    Wildcard permissions like `documents.*` grant access to all sub-permissions including `documents.read` and `documents.write`.
    Direct permissions supplement any permissions inherited from assigned roles.

    """

    expires: Optional[int] = None
    r"""Sets when this key automatically expires as a Unix timestamp in milliseconds.
    Verification fails with code=EXPIRED immediately after this time passes.
    Omitting this field creates a permanent key that never expires.

    Avoid setting timestamps in the past as they immediately invalidate the key.
    Keys expire based on server time, not client time, which prevents timezone-related issues.
    Essential for trial periods, temporary access, and security compliance requiring key rotation.

    """

    credits: Optional[KeyCreditsData] = None
    r"""Credit configuration and remaining balance for this key."""

    ratelimits: Optional[List[RatelimitRequest]] = None
    r"""Defines time-based rate limits that protect against abuse by controlling request frequency.
    Unlike credits which track total usage, rate limits reset automatically after each window expires.
    Multiple rate limits can control different operation types with separate thresholds and windows.
    Essential for preventing API abuse while maintaining good performance for legitimate usage.

    """

    enabled: Optional[bool] = True
    r"""Controls whether the key is active immediately upon creation.
    When set to `false`, the key exists but all verification attempts fail with `code=DISABLED`.
    Useful for pre-creating keys that will be activated later or for keys requiring manual approval.
    Most keys should be created with `enabled=true` for immediate use.

    """

    recoverable: Optional[bool] = False
    r"""Controls whether the plaintext key is stored in an encrypted vault for later retrieval.
    When true, allows recovering the actual key value using keys.getKey with decrypt=true.
    When false, the key value cannot be retrieved after creation for maximum security.
    Only enable for development keys or when key recovery is absolutely necessary.

    """
