"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unkey.py.types import BaseModel


class V2KeysGetKeyRequestBodyTypedDict(TypedDict):
    key_id: str
    r"""Specifies which key to retrieve using the database identifier returned from `keys.createKey`.
    Do not confuse this with the actual API key string that users include in requests.
    Key data includes metadata, permissions, usage statistics, and configuration but never the plaintext key value unless `decrypt=true`.
    Find this ID in creation responses, key listings, dashboard, or verification responses.

    """
    decrypt: NotRequired[bool]
    r"""Controls whether to include the plaintext key value in the response for recovery purposes.
    Only works for keys created with `recoverable=true` and requires the `decrypt_key` permission.
    Returned keys must be handled securely, never logged, cached, or stored insecurely.

    Use only for legitimate recovery scenarios like user password resets or emergency access.
    Most applications should keep this false to maintain security best practices and avoid accidental key exposure.
    Decryption requests are audited and may trigger security alerts in enterprise environments.

    """


class V2KeysGetKeyRequestBody(BaseModel):
    key_id: Annotated[str, pydantic.Field(alias="keyId")]
    r"""Specifies which key to retrieve using the database identifier returned from `keys.createKey`.
    Do not confuse this with the actual API key string that users include in requests.
    Key data includes metadata, permissions, usage statistics, and configuration but never the plaintext key value unless `decrypt=true`.
    Find this ID in creation responses, key listings, dashboard, or verification responses.

    """

    decrypt: Optional[bool] = False
    r"""Controls whether to include the plaintext key value in the response for recovery purposes.
    Only works for keys created with `recoverable=true` and requires the `decrypt_key` permission.
    Returned keys must be handled securely, never logged, cached, or stored insecurely.

    Use only for legitimate recovery scenarios like user password resets or emergency access.
    Most applications should keep this false to maintain security best practices and avoid accidental key exposure.
    Decryption requests are audited and may trigger security alerts in enterprise environments.

    """
