"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import pydantic
from typing import List
from typing_extensions import Annotated, TypedDict
from unkey.py.types import BaseModel


class V2KeysRemoveRolesRequestBodyTypedDict(TypedDict):
    key_id: str
    r"""Specifies which key loses the roles using the database identifier returned from createKey.
    Do not confuse this with the actual API key string that users include in requests.
    Removing roles only affects direct assignments, not permissions inherited from other sources.
    Role changes take effect immediately but may take up to 30 seconds to propagate across all regions.

    """
    roles: List[str]
    r"""Removes direct role assignments from the key without affecting other role sources or permissions.
    Operations are idempotent - removing non-assigned roles has no effect and causes no errors.

    After removal, the key loses access to permissions that were only granted through these roles.
    Invalid role references cause the entire operation to fail atomically, ensuring consistent state.

    """


class V2KeysRemoveRolesRequestBody(BaseModel):
    key_id: Annotated[str, pydantic.Field(alias="keyId")]
    r"""Specifies which key loses the roles using the database identifier returned from createKey.
    Do not confuse this with the actual API key string that users include in requests.
    Removing roles only affects direct assignments, not permissions inherited from other sources.
    Role changes take effect immediately but may take up to 30 seconds to propagate across all regions.

    """

    roles: List[str]
    r"""Removes direct role assignments from the key without affecting other role sources or permissions.
    Operations are idempotent - removing non-assigned roles has no effect and causes no errors.

    After removal, the key loses access to permissions that were only granted through these roles.
    Invalid role references cause the entire operation to fail atomically, ensuring consistent state.

    """
