"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .keysverifykeycredits import KeysVerifyKeyCredits, KeysVerifyKeyCreditsTypedDict
from .keysverifykeyratelimit import (
    KeysVerifyKeyRatelimit,
    KeysVerifyKeyRatelimitTypedDict,
)
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict
from unkey.py.types import BaseModel


class V2KeysVerifyKeyRequestBodyTypedDict(TypedDict):
    key: str
    r"""The API key to verify, exactly as provided by your user.
    Include any prefix - even small changes will cause verification to fail.

    """
    tags: NotRequired[List[str]]
    r"""Attaches metadata tags for analytics and monitoring without affecting verification outcomes.
    Enables segmentation of API usage in dashboards by endpoint, client version, region, or custom dimensions.
    Use 'key=value' format for compatibility with most analytics tools and clear categorization.
    Avoid including sensitive data in tags as they may appear in logs and analytics reports.

    """
    permissions: NotRequired[str]
    r"""Checks if the key has the specified permission(s) using a query syntax.
    Supports single permissions, logical operators (AND, OR), and parentheses for grouping.
    Examples:
    - Single permission: \"documents.read\" 
    - Multiple permissions: \"documents.read AND documents.write\" 
    - Complex queries: \"(documents.read OR documents.write) AND users.view\" 
    Verification fails if the key lacks the required permissions through direct assignment or role inheritance.

    """
    credits: NotRequired[KeysVerifyKeyCreditsTypedDict]
    r"""Controls credit consumption for usage-based billing and quota enforcement.
    Omitting this field uses the default cost of 1 credit per verification.
    Credits provide globally consistent usage tracking, essential for paid APIs with strict quotas.

    """
    ratelimits: NotRequired[List[KeysVerifyKeyRatelimitTypedDict]]
    r"""Enforces time-based rate limiting during verification to prevent abuse and ensure fair usage.
    Omitting this field skips rate limit checks entirely, relying only on configured key rate limits.
    Multiple rate limits can be checked simultaneously, each with different costs and temporary overrides.
    Rate limit checks are optimized for performance but may allow brief bursts during high concurrency.

    """


class V2KeysVerifyKeyRequestBody(BaseModel):
    key: str
    r"""The API key to verify, exactly as provided by your user.
    Include any prefix - even small changes will cause verification to fail.

    """

    tags: Optional[List[str]] = None
    r"""Attaches metadata tags for analytics and monitoring without affecting verification outcomes.
    Enables segmentation of API usage in dashboards by endpoint, client version, region, or custom dimensions.
    Use 'key=value' format for compatibility with most analytics tools and clear categorization.
    Avoid including sensitive data in tags as they may appear in logs and analytics reports.

    """

    permissions: Optional[str] = None
    r"""Checks if the key has the specified permission(s) using a query syntax.
    Supports single permissions, logical operators (AND, OR), and parentheses for grouping.
    Examples:
    - Single permission: \"documents.read\" 
    - Multiple permissions: \"documents.read AND documents.write\" 
    - Complex queries: \"(documents.read OR documents.write) AND users.view\" 
    Verification fails if the key lacks the required permissions through direct assignment or role inheritance.

    """

    credits: Optional[KeysVerifyKeyCredits] = None
    r"""Controls credit consumption for usage-based billing and quota enforcement.
    Omitting this field uses the default cost of 1 credit per verification.
    Credits provide globally consistent usage tracking, essential for paid APIs with strict quotas.

    """

    ratelimits: Optional[List[KeysVerifyKeyRatelimit]] = None
    r"""Enforces time-based rate limiting during verification to prevent abuse and ensure fair usage.
    Omitting this field skips rate limit checks entirely, relying only on configured key rate limits.
    Multiple rate limits can be checked simultaneously, each with different costs and temporary overrides.
    Rate limit checks are optimized for performance but may allow brief bursts during high concurrency.

    """
