"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .identity import Identity, IdentityTypedDict
from .verifykeyratelimitdata import (
    VerifyKeyRatelimitData,
    VerifyKeyRatelimitDataTypedDict,
)
from enum import Enum
import pydantic
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unkey.py.types import BaseModel


class Code(str, Enum):
    r"""A machine-readable code indicating the verification status
    or failure reason. Values: `VALID` (key is valid and passed all checks), `NOT_FOUND` (key doesn't
    exist or belongs to wrong API), `FORBIDDEN` (key lacks required permissions), `INSUFFICIENT_PERMISSIONS`
    (key lacks specific required permissions for this request), `INSUFFICIENT_CREDITS`
    (key has no remaining credits), `USAGE_EXCEEDED` (key exceeded usage limits), `RATE_LIMITED` (key exceeded rate limits), `DISABLED` (key was explicitly disabled),
    `EXPIRED` (key has passed its expiration date).

    """

    VALID = "VALID"
    NOT_FOUND = "NOT_FOUND"
    FORBIDDEN = "FORBIDDEN"
    INSUFFICIENT_PERMISSIONS = "INSUFFICIENT_PERMISSIONS"
    INSUFFICIENT_CREDITS = "INSUFFICIENT_CREDITS"
    USAGE_EXCEEDED = "USAGE_EXCEEDED"
    RATE_LIMITED = "RATE_LIMITED"
    DISABLED = "DISABLED"
    EXPIRED = "EXPIRED"


class V2KeysVerifyKeyResponseDataTypedDict(TypedDict):
    valid: bool
    r"""The primary verification result. If true, the key is valid
    and can be used. If false, check the 'code' field to understand why verification
    failed. Your application should always check this field first before proceeding.

    """
    code: Code
    r"""A machine-readable code indicating the verification status
    or failure reason. Values: `VALID` (key is valid and passed all checks), `NOT_FOUND` (key doesn't
    exist or belongs to wrong API), `FORBIDDEN` (key lacks required permissions), `INSUFFICIENT_PERMISSIONS`
    (key lacks specific required permissions for this request), `INSUFFICIENT_CREDITS`
    (key has no remaining credits), `USAGE_EXCEEDED` (key exceeded usage limits), `RATE_LIMITED` (key exceeded rate limits), `DISABLED` (key was explicitly disabled),
    `EXPIRED` (key has passed its expiration date).

    """
    key_id: NotRequired[str]
    r"""The unique identifier of the verified key in Unkey's system.
    Use this ID for operations like updating or revoking the key. This field
    is returned for both valid and invalid keys (except when `code=NOT_FOUND`).

    """
    name: NotRequired[str]
    r"""The human-readable name assigned to this key during creation.
    This is useful for displaying in logs or admin interfaces to identify
    the key's purpose.

    """
    meta: NotRequired[Dict[str, Any]]
    r"""Custom metadata associated with the key. This can include any
    JSON-serializable data you stored with the key during creation or updates,
    such as plan information, feature flags, or user details. Use this to
    avoid additional database lookups for contextual information needed during
    API calls.

    """
    expires: NotRequired[int]
    r"""Unix timestamp (in milliseconds) when the key will expire.
    If null or not present, the key has no expiration. You can use this to
    warn users about upcoming expirations or to understand the validity period.

    """
    credits: NotRequired[int]
    r"""The number of requests/credits remaining for this key. If null
    or not present, the key has unlimited usage. This value decreases with
    each verification (based on the 'cost' parameter) unless explicit credit
    refills are configured.

    """
    enabled: NotRequired[bool]
    r"""Indicates if the key is currently enabled. Disabled keys will
    always fail verification with `code=DISABLED`. This is useful for implementing
    temporary suspensions without deleting the key.

    """
    permissions: NotRequired[List[str]]
    r"""A list of all permission names assigned to this key, either
    directly or through roles. These permissions determine what actions the
    key can perform. Only returned when permissions were checked during verification
    or when the key fails with `code=FORBIDDEN`.

    """
    roles: NotRequired[List[str]]
    r"""A list of all role names assigned to this key. Roles are collections
    of permissions that grant access to specific functionality. Only returned
    when permissions were checked during verification.

    """
    identity: NotRequired[IdentityTypedDict]
    ratelimits: NotRequired[List[VerifyKeyRatelimitDataTypedDict]]


class V2KeysVerifyKeyResponseData(BaseModel):
    valid: bool
    r"""The primary verification result. If true, the key is valid
    and can be used. If false, check the 'code' field to understand why verification
    failed. Your application should always check this field first before proceeding.

    """

    code: Code
    r"""A machine-readable code indicating the verification status
    or failure reason. Values: `VALID` (key is valid and passed all checks), `NOT_FOUND` (key doesn't
    exist or belongs to wrong API), `FORBIDDEN` (key lacks required permissions), `INSUFFICIENT_PERMISSIONS`
    (key lacks specific required permissions for this request), `INSUFFICIENT_CREDITS`
    (key has no remaining credits), `USAGE_EXCEEDED` (key exceeded usage limits), `RATE_LIMITED` (key exceeded rate limits), `DISABLED` (key was explicitly disabled),
    `EXPIRED` (key has passed its expiration date).

    """

    key_id: Annotated[Optional[str], pydantic.Field(alias="keyId")] = None
    r"""The unique identifier of the verified key in Unkey's system.
    Use this ID for operations like updating or revoking the key. This field
    is returned for both valid and invalid keys (except when `code=NOT_FOUND`).

    """

    name: Optional[str] = None
    r"""The human-readable name assigned to this key during creation.
    This is useful for displaying in logs or admin interfaces to identify
    the key's purpose.

    """

    meta: Optional[Dict[str, Any]] = None
    r"""Custom metadata associated with the key. This can include any
    JSON-serializable data you stored with the key during creation or updates,
    such as plan information, feature flags, or user details. Use this to
    avoid additional database lookups for contextual information needed during
    API calls.

    """

    expires: Optional[int] = None
    r"""Unix timestamp (in milliseconds) when the key will expire.
    If null or not present, the key has no expiration. You can use this to
    warn users about upcoming expirations or to understand the validity period.

    """

    credits: Optional[int] = None
    r"""The number of requests/credits remaining for this key. If null
    or not present, the key has unlimited usage. This value decreases with
    each verification (based on the 'cost' parameter) unless explicit credit
    refills are configured.

    """

    enabled: Optional[bool] = None
    r"""Indicates if the key is currently enabled. Disabled keys will
    always fail verification with `code=DISABLED`. This is useful for implementing
    temporary suspensions without deleting the key.

    """

    permissions: Optional[List[str]] = None
    r"""A list of all permission names assigned to this key, either
    directly or through roles. These permissions determine what actions the
    key can perform. Only returned when permissions were checked during verification
    or when the key fails with `code=FORBIDDEN`.

    """

    roles: Optional[List[str]] = None
    r"""A list of all role names assigned to this key. Roles are collections
    of permissions that grant access to specific functionality. Only returned
    when permissions were checked during verification.

    """

    identity: Optional[Identity] = None

    ratelimits: Optional[List[VerifyKeyRatelimitData]] = None
