"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from typing_extensions import TypedDict
from unkey.py.types import BaseModel


class V2RatelimitSetOverrideRequestBodyTypedDict(TypedDict):
    r"""Sets a new or overwrites an existing rate limit override. Overrides allow you to apply special rate limit rules to specific identifiers, providing custom limits that differ from the default.

    Overrides are useful for:
    - Granting higher limits to premium users or trusted partners
    - Implementing stricter limits for suspicious or abusive users
    - Creating tiered access levels with different quotas
    - Implementing temporary rate limit adjustments
    - Prioritizing important clients with higher limits
    """

    namespace: str
    r"""The ID or name of the rate limit namespace."""
    duration: int
    r"""The duration in milliseconds for the rate limit window. This defines how long the rate limit counter accumulates before resetting to zero.

    Considerations:
    - This can differ from the default duration for the namespace
    - Longer durations create stricter limits that take longer to reset
    - Shorter durations allow more frequent bursts of activity
    - Common values: 60000 (1 minute), 3600000 (1 hour), 86400000 (1 day)
    """
    identifier: str
    r"""Identifier of the entity receiving this custom rate limit. This can be:

    - A specific user ID for individual custom limits
    - An IP address for location-based rules
    - An email domain for organization-wide policies
    - Any other string that identifies the target entity

    Wildcards (*) can be used to create pattern-matching rules that apply to multiple identifiers. For example:
    - 'premium_*' would match all identifiers starting with 'premium_'
    - '*_admin' would match all identifiers ending with '_admin'
    - '*suspicious*' would match any identifier containing 'suspicious'

    More detailed information on wildcard pattern rules is available at https://www.unkey.com/docs/ratelimiting/overrides#wildcard-rules
    """
    limit: int
    r"""The maximum number of requests allowed for this override. This defines the custom quota for the specified identifier(s).

    Special values:
    - Higher than default: For premium or trusted entities
    - Lower than default: For suspicious or abusive entities
    - 0: To completely block access (useful for ban implementation)

    This limit entirely replaces the default limit for matching identifiers.
    """


class V2RatelimitSetOverrideRequestBody(BaseModel):
    r"""Sets a new or overwrites an existing rate limit override. Overrides allow you to apply special rate limit rules to specific identifiers, providing custom limits that differ from the default.

    Overrides are useful for:
    - Granting higher limits to premium users or trusted partners
    - Implementing stricter limits for suspicious or abusive users
    - Creating tiered access levels with different quotas
    - Implementing temporary rate limit adjustments
    - Prioritizing important clients with higher limits
    """

    namespace: str
    r"""The ID or name of the rate limit namespace."""

    duration: int
    r"""The duration in milliseconds for the rate limit window. This defines how long the rate limit counter accumulates before resetting to zero.

    Considerations:
    - This can differ from the default duration for the namespace
    - Longer durations create stricter limits that take longer to reset
    - Shorter durations allow more frequent bursts of activity
    - Common values: 60000 (1 minute), 3600000 (1 hour), 86400000 (1 day)
    """

    identifier: str
    r"""Identifier of the entity receiving this custom rate limit. This can be:

    - A specific user ID for individual custom limits
    - An IP address for location-based rules
    - An email domain for organization-wide policies
    - Any other string that identifies the target entity

    Wildcards (*) can be used to create pattern-matching rules that apply to multiple identifiers. For example:
    - 'premium_*' would match all identifiers starting with 'premium_'
    - '*_admin' would match all identifiers ending with '_admin'
    - '*suspicious*' would match any identifier containing 'suspicious'

    More detailed information on wildcard pattern rules is available at https://www.unkey.com/docs/ratelimiting/overrides#wildcard-rules
    """

    limit: int
    r"""The maximum number of requests allowed for this override. This defines the custom quota for the specified identifier(s).

    Special values:
    - Higher than default: For premium or trusted entities
    - Lower than default: For suspicious or abusive entities
    - 0: To completely block access (useful for ban implementation)

    This limit entirely replaces the default limit for matching identifiers.
    """
