"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from typing import Optional
from typing_extensions import NotRequired, TypedDict
from unkey.py.types import BaseModel


class ValidationErrorTypedDict(TypedDict):
    r"""Individual validation error details. Each validation error provides precise information about what failed, where it failed, and how to fix it, enabling efficient error resolution."""

    location: str
    r"""JSON path indicating exactly where in the request the error occurred. This helps pinpoint the problematic field or parameter. Examples include:
    - 'body.name' (field in request body)
    - 'body.items[3].tags' (nested array element)
    - 'path.apiId' (path parameter)
    - 'query.limit' (query parameter)
    Use this location to identify exactly which part of your request needs correction.
    """
    message: str
    r"""Detailed error message explaining what validation rule was violated. This provides specific information about why the field or parameter was rejected, such as format errors, invalid values, or constraint violations."""
    fix: NotRequired[str]
    r"""A human-readable suggestion describing how to fix the error. This provides practical guidance on what changes would satisfy the validation requirements. Not all validation errors include fix suggestions, but when present, they offer specific remediation advice."""


class ValidationError(BaseModel):
    r"""Individual validation error details. Each validation error provides precise information about what failed, where it failed, and how to fix it, enabling efficient error resolution."""

    location: str
    r"""JSON path indicating exactly where in the request the error occurred. This helps pinpoint the problematic field or parameter. Examples include:
    - 'body.name' (field in request body)
    - 'body.items[3].tags' (nested array element)
    - 'path.apiId' (path parameter)
    - 'query.limit' (query parameter)
    Use this location to identify exactly which part of your request needs correction.
    """

    message: str
    r"""Detailed error message explaining what validation rule was violated. This provides specific information about why the field or parameter was rejected, such as format errors, invalid values, or constraint violations."""

    fix: Optional[str] = None
    r"""A human-readable suggestion describing how to fix the error. This provides practical guidance on what changes would satisfy the validation requirements. Not all validation errors include fix suggestions, but when present, they offer specific remediation advice."""
