"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import pydantic
from typing_extensions import Annotated, TypedDict
from unkey.py.types import BaseModel


class VerifyKeyRatelimitDataTypedDict(TypedDict):
    exceeded: bool
    r"""Whether the rate limit was exceeded."""
    id: str
    r"""Unique identifier for this rate limit configuration."""
    name: str
    r"""Human-readable name for this rate limit."""
    limit: int
    r"""Maximum requests allowed within the time window."""
    duration: int
    r"""Rate limit window duration in milliseconds."""
    reset: int
    r"""Rate limit reset duration in milliseconds."""
    remaining: int
    r"""Rate limit remaining requests within the time window."""
    auto_apply: bool
    r"""Whether this rate limit should be automatically applied when verifying keys.
    When true, we will automatically apply this limit during verification without it being explicitly listed.

    """


class VerifyKeyRatelimitData(BaseModel):
    exceeded: bool
    r"""Whether the rate limit was exceeded."""

    id: str
    r"""Unique identifier for this rate limit configuration."""

    name: str
    r"""Human-readable name for this rate limit."""

    limit: int
    r"""Maximum requests allowed within the time window."""

    duration: int
    r"""Rate limit window duration in milliseconds."""

    reset: int
    r"""Rate limit reset duration in milliseconds."""

    remaining: int
    r"""Rate limit remaining requests within the time window."""

    auto_apply: Annotated[bool, pydantic.Field(alias="autoApply")]
    r"""Whether this rate limit should be automatically applied when verifying keys.
    When true, we will automatically apply this limit during verification without it being explicitly listed.

    """
