# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.response import Response
from .raw_client import AsyncRawJupyterClient, RawJupyterClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class JupyterClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawJupyterClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawJupyterClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawJupyterClient
        """
        return self._raw_client

    def execute_jupyter_code(
        self,
        *,
        code: str,
        timeout: typing.Optional[int] = OMIT,
        kernel_name: typing.Optional[str] = OMIT,
        session_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Response:
        """
        Execute Python code using Jupyter kernel with session persistence

        This endpoint allows you to execute Python code and get results back.
        You can optionally specify a kernel_name (defaults to 'python3').
        Use session_id to maintain variable state across multiple requests.
        Sessions automatically expire after 30 minutes of inactivity.

        Parameters
        ----------
        code : str
            Python code to execute

        timeout : typing.Optional[int]
            Execution timeout in seconds

        kernel_name : typing.Optional[str]
            Kernel name to use (e.g., 'python3', 'python3.11'). Defaults to 'python3'

        session_id : typing.Optional[str]
            Session ID to maintain kernel state across requests

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Response
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.jupyter.execute_jupyter_code(
            code="code",
        )
        """
        _response = self._raw_client.execute_jupyter_code(
            code=code, timeout=timeout, kernel_name=kernel_name, session_id=session_id, request_options=request_options
        )
        return _response.data

    def info(self, *, request_options: typing.Optional[RequestOptions] = None) -> Response:
        """
        Get information about available Jupyter kernels

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Response
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.jupyter.info()
        """
        _response = self._raw_client.info(request_options=request_options)
        return _response.data

    def list_sessions(self, *, request_options: typing.Optional[RequestOptions] = None) -> Response:
        """
        List all active Jupyter sessions

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Response
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.jupyter.list_sessions()
        """
        _response = self._raw_client.list_sessions(request_options=request_options)
        return _response.data

    def cleanup_all_sessions(self, *, request_options: typing.Optional[RequestOptions] = None) -> Response:
        """
        Cleanup all active sessions

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Response
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.jupyter.cleanup_all_sessions()
        """
        _response = self._raw_client.cleanup_all_sessions(request_options=request_options)
        return _response.data

    def cleanup_session(self, session_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Response:
        """
        Manually cleanup a specific session

        Parameters
        ----------
        session_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Response
            Successful Response

        Examples
        --------
        from agent_sandbox import Sandbox

        client = Sandbox(
            base_url="https://yourhost.com/path/to/api",
        )
        client.jupyter.cleanup_session(
            session_id="session_id",
        )
        """
        _response = self._raw_client.cleanup_session(session_id, request_options=request_options)
        return _response.data


class AsyncJupyterClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawJupyterClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawJupyterClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawJupyterClient
        """
        return self._raw_client

    async def execute_jupyter_code(
        self,
        *,
        code: str,
        timeout: typing.Optional[int] = OMIT,
        kernel_name: typing.Optional[str] = OMIT,
        session_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Response:
        """
        Execute Python code using Jupyter kernel with session persistence

        This endpoint allows you to execute Python code and get results back.
        You can optionally specify a kernel_name (defaults to 'python3').
        Use session_id to maintain variable state across multiple requests.
        Sessions automatically expire after 30 minutes of inactivity.

        Parameters
        ----------
        code : str
            Python code to execute

        timeout : typing.Optional[int]
            Execution timeout in seconds

        kernel_name : typing.Optional[str]
            Kernel name to use (e.g., 'python3', 'python3.11'). Defaults to 'python3'

        session_id : typing.Optional[str]
            Session ID to maintain kernel state across requests

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Response
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.jupyter.execute_jupyter_code(
                code="code",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.execute_jupyter_code(
            code=code, timeout=timeout, kernel_name=kernel_name, session_id=session_id, request_options=request_options
        )
        return _response.data

    async def info(self, *, request_options: typing.Optional[RequestOptions] = None) -> Response:
        """
        Get information about available Jupyter kernels

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Response
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.jupyter.info()


        asyncio.run(main())
        """
        _response = await self._raw_client.info(request_options=request_options)
        return _response.data

    async def list_sessions(self, *, request_options: typing.Optional[RequestOptions] = None) -> Response:
        """
        List all active Jupyter sessions

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Response
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.jupyter.list_sessions()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_sessions(request_options=request_options)
        return _response.data

    async def cleanup_all_sessions(self, *, request_options: typing.Optional[RequestOptions] = None) -> Response:
        """
        Cleanup all active sessions

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Response
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.jupyter.cleanup_all_sessions()


        asyncio.run(main())
        """
        _response = await self._raw_client.cleanup_all_sessions(request_options=request_options)
        return _response.data

    async def cleanup_session(
        self, session_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Response:
        """
        Manually cleanup a specific session

        Parameters
        ----------
        session_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Response
            Successful Response

        Examples
        --------
        import asyncio

        from agent_sandbox import AsyncSandbox

        client = AsyncSandbox(
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.jupyter.cleanup_session(
                session_id="session_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.cleanup_session(session_id, request_options=request_options)
        return _response.data
