import sys
from cartography.graph.job import GraphJob

if sys.version_info >= (3, 7):
    from importlib.resources import open_binary, read_text
else:
    from importlib_resources import open_binary, read_text


def run_analysis_job(filename, session, common_job_parameters):
    GraphJob.run_from_json(
        session,
        read_text(
            'cartography.data.jobs.analysis',
            filename
        ),
        common_job_parameters
    )


def run_cleanup_job(filename, session, common_job_parameters):
    GraphJob.run_from_json(
        session,
        read_text(
            'cartography.data.jobs.cleanup',
            filename
        ),
        common_job_parameters
    )


def load_resource_binary(package, resource_name):
    return open_binary(package, resource_name)
