# Auto-generated by generate_doc.py — DO NOT EDIT MANUALLY.
# This module is used only for Sphinx autodoc.

# --- Core API extracted from ChannelAttribution.pyx ---
"""

**Markov Model for Online Multi-Channel Attribution**
Advertisers use a variety of online marketing channels to reach consumers and they want to know the degree each channel contributes to their marketing success. This is called online multichannel attribution problem. In many cases, advertisers approach this problem through some simple heuristics methods that do not take into account any customer interactions and often tend to underestimate the importance of small channels in marketing contribution. This package provides a function that approaches the attribution problem in a probabilistic way. It uses a k-order Markov representation to identify structural correlations in the customer journey data. This would allow advertisers to give a more reliable assessment of the marketing contribution of each channel. The approach basically follows the one presented in Eva Anderl, Ingo Becker, Florian v. Wangenheim,
Jan H. Schumann (2014). Differently from them, we solved the estimation process using stochastic simulations. In this way it is also possible to take into account conversion values and their variability in the computation of the channel importance. The package also contains a function that estimates three heuristic models (first-touch, last-touch and linear-touch approach) for the same problem.


"""
    
def heuristic_models(Data,var_path,var_conv,var_value=None, sep=">", flg_pro=True):

    """
            
    Estimate three heuristic models (first-touch, last-touch and linear) from customer journey data.
    
    Parameters
    ----------
    Data : DataFrame
        customer journeys.
    var_path: string
        column of Data containing paths.
    var_conv : string
        column of Data containing total conversions for each path.
    var_value : string, optional, default None
        column of Data containing revenue for each path.
    sep : string, default ">"
        separator between the channels.
    flg_pro : bool, default True
        if True, ChannelAttribution Pro banner is printed.
    
    Returns
    -------
    DataFrame        
        (column) channel_name : channel names
        (column) first_touch_conversions : conversions attributed to each channel using first touch attribution.
        (column) first_touch_value : revenues attributed to each channel using first touch attribution.
        (column) last_touch_conversions : conversions attributed to each channel using last touch attribution.
        (column) last_touch_value : revenues attributed to each channel using last touch attribution.
        (column) linear_touch_conversions : conversions attributed to each channel using linear attribution.
        (column) linear_touch_value : revenues attributed to each channel using linear attribution.
    
    Examples
    --------
    
    Load Data

    >>> import pandas as pd    
    >>> from ChannelAttribution import *
    >>> Data = pd.read_csv('https://channelattribution.io/csv/Data.csv',sep=";")
        
    Estimate heuristic models on total conversions
    
    >>> heuristic_models(Data,"path","total_conversions")
    
    Estimate heuristic models on total conversions and total revenues
    
    >>> heuristic_models(Data,"path","total_conversions",\\
    >>> var_value="total_conversion_value")
     
    """

    if ("DataFrame" not in str(type(Data))):
        raise NameError("Data must be a DataFrame")
    
    if type(var_path)==str:
        if var_path not in Data.columns:
            raise NameError("var_path must be a column of Data")
    else:
        raise NameError("var_path must be a string")

    if (type(var_conv)==str):
        if (var_conv not in Data.columns):
            raise NameError("var_conv must be a column of Data")
        
    else:
        raise NameError("var_conv must be a string")
   
    if (var_value!=None):
        if (var_value not in Data.columns):
            raise NameError("var_value must be a column of Data")
            
    if (len(sep) > 1):
        raise NameError("sep must have length 1")
        
    if (var_value==None):
        vv = pd.Series(None,dtype='float64')
    else:
        vv=Data[var_value]


    res0=__heuristic_models_1(Data[var_path].str.encode('utf-8'),Data[var_conv],vv,sep.encode("utf-8"))
    
    if len(vv)==0:
    
        res=pd.DataFrame({'channel_name':pd.Series(res0[0]).str.decode('utf-8'),'first_touch':res0[1][0],'last_touch':res0[1][1],'linear_touch':res0[1][2]})
    
    else:
    
        res=pd.DataFrame({'channel_name':pd.Series(res0[0]).str.decode('utf-8'),'first_touch_conversions':res0[1][0], 'first_touch_value':res0[1][3], 'last_touch_conversions':res0[1][1], 'last_touch_value':res0[1][4], 'linear_touch_conversions':res0[1][2], 'linear_touch_value':res0[1][5]})
    
    if flg_pro==True:
        print(__message_pro)

    return(res)

    
def choose_order(Data,var_path,var_conv,var_null,max_order=10,sep=">",ncore=1,roc_npt=100,plot=True, flg_pro=True):

    """
    
    Find the minimum Markov Model order that gives a good representation of customers’ behaviour for data considered. It requires paths that do not lead to conversion as input. Minimum order is found maximizing a penalized area under ROC curve.
    
    Parameters
    ----------
    Data : DataFrame
        customer journeys.
    var_path: string
        column of Data containing paths.
    var_conv : string
        column of Data containing total conversions for each path.
    var_null : string
        column of Data containing total paths that do not lead to conversion.
    max_order : int, default 10
        maximum Markov Model order to be considered.        
    sep : string, default ">"
        separator between the channels.    
    ncore : int, default 1
        number of threads to be used in computation.        
    roc_npt: int, default 100
        number of points to be used for the approximation of roc curve.    
    plot: bool, default True
        if True, a plot with penalized auc with respect to order will be displayed.
    flg_pro : bool, default True
        if True, ChannelAttribution Pro banner is printed.
    
    Returns
    -------
    list        
        roc : list DataFrame one for each order considered
            (column) tpr: true positive rate
            (column) fpr: false positive rate
        auc : DataFrame with the following columns
            (column) order: markov model order  
            (column) auc: area under the curve
            (column) pauc: penalized auc
        suggested order : int
            estimated best order 
            
    Examples
    --------
    Estimate best makov model order for your data
    
    Load Data
        
    >>> import pandas as pd    
    >>> from ChannelAttribution import *
    >>> Data = pd.read_csv('https://channelattribution.io/csv/Data.csv',sep=";")
    
    >>> choose_order(Data, var_path="path", var_conv="total_conversions", var_null="total_null")


    """
    
    if ("DataFrame" not in str(type(Data))):
        raise NameError("Data must be a DataFrame")
    
    if type(var_path)==str:
        if var_path not in Data.columns:
            raise NameError("var_path must be a column of Data")
    else:
        raise NameError("var_path must be a string")

    if (type(var_conv)==str):
        if (var_conv not in Data.columns):
            raise NameError("var_conv must be a column of Data")
        
    else:
        raise NameError("var_conv must be a string")
   
        
    if (var_null!=None):
        if (var_null not in Data.columns):
            raise NameError("var_null must be a column of Data")
      
    if (max_order < 1):
        raise NameError("max_order must be >= 1")
    
    if (ncore!=None):
        if (ncore < 1):
            raise NameError("ncore must be >= 1")
            
    if (roc_npt!=None):
        if (roc_npt < 10):
            raise NameError("roc_npt must be >= 10")
        
    
    if (plot not in [0, 1]):
        raise NameError("plot must be False or True")
    
    res0=__choose_order_1(vy=Data[var_path].str.encode('utf-8'),vc=Data[var_conv],vn=Data[var_null], max_order=max_order, sep=sep.encode('utf-8'), ncore=ncore, roc_npt=roc_npt)    

    order=pd.Series(res0[-3])
    auc=pd.Series(res0[-2])
    pauc=pd.Series(res0[-1])
 
    max_order_0=order[order!=0].iloc[-1]
    
    best_order=res0[-1].index(max(res0[-1]))
   
    best_order=best_order+1

    if best_order==max_order_0:
        print("Suggested order not found. Try increasing max_order.")
    else:
        print("Suggested order: " + str(int(best_order)))

    auc=auc[order!=0]
    pauc=pauc[order!=0]
    order=order[order!=0]
        
    if plot=="True":
        plt.title("PENALIZED AUC")
        plt.xlabel("order")
        plt.ylabel("penalized auc")
        plt.plot(order, pauc) 
    
    auc=auc[order<=(best_order+1)]
    pauc=pauc[order<=(best_order+1)]
    order=order[order<=(best_order+1)]
    
    res_auc=pd.DataFrame({'order':order,'auc':auc,'pauc':pauc})
    
    res_roc=dict()
    for k in range(best_order+1):
        res_roc['order='+str(k+1)]=pd.DataFrame({'fpr':res0[2*k],'tpr':res0[2*k+1]})
    
    if flg_pro==True:
        print(__message_pro)
    
    return(res_auc,res_roc,best_order)
            
    
        
def markov_model(Data,var_path,var_conv,var_value=None,var_null=None,order=1,nsim_start=1e5,max_step=None,out_more=False,sep=">",ncore=1, nfold=10, seed=0, conv_par=0.05,rate_step_sim=1.5,verbose=True, flg_pro=True):

    '''
    
    Estimate a k-order Markov model from customer journey data. Differently from markov_model, this function iterates estimation until a desidered convergence is reached and enables multiprocessing.
    
    Parameters
    ----------
    Data : DataFrame
        customer journeys.
    var_path: string
        column of Data containing paths.
    var_conv : string
        column of Data containing total conversions for each path.
    var_value : string, optional, default None
        column of Data containing revenue for each path.
    var_null : string
        column of Data containing total paths that do not lead to conversion.
    order : int, default 1
        Markov model order.        
    nsim_start : int, default 1e5
        minimum number of simulations to be used in computation.        
    max_step : int, default None
        maximum number of steps for a single simulated path. if NULL, it is the maximum number of steps found into Data.        
    out_more : bool, default False
        if True, transition probabilities between channels and removal effects will be returned.                
    sep : string, default ">"
        separator between the channels.    
    ncore : int, default 1
        number of threads to be used in computation.        
    nfold : int, default 10
        how many repetitions to be used to verify if convergence has been reached at each iteration.    
    seed : int, default 0
        random seed. Giving this parameter the same value over different runs guarantees that results will not vary.    
    conv_par : double, default 0.05
        convergence parameter for the algorithm. The estimation process ends when the percentage of variation of the results over different repetions is less than convergence parameter.    
    rate_step_sim : double, default 0
        number of simulations used at each iteration is equal to the number of simulations used at previous iteration multiplied by rate_step_sim.    
    verbose : bool, default True
        if True, additional information about process convergence will be shown.    
    flg_pro : bool, default True
        if True, ChannelAttribution Pro banner is printed.
            
    Returns
    -------
    list of DataFrames
        result: Dataframe
            (column) channel_name : channel names
            (column) total_conversions : conversions attributed to each channel
            (column) total_conversion_value : revenues attributed to each channel
        transition_matrix : DataFrame
            (column) channel_from: channel from
            (column) channel_to : channel to
            (column) transition_probability : transition probability from channel_from to channel_to
        removal_effects:
            (column) channel_name : channel names 
            (column) removal_effects_conversion : removal effects for each channel calculated using total conversions
            (column) removal_effects_conversion_value : removal effects for each channel calculated using revenues
                
                        
    Examples
    --------
    
    Load Data
    
    >>> import pandas as pd    
    >>> from ChannelAttribution import *
    >>> Data = pd.read_csv('https://channelattribution.io/csv/Data.csv',sep=";")
    
    Estimate a Makov model using total conversions 
    
    >>> markov_model(Data, "path", "total_conversions")

    Estimate a Makov model using total conversions and revenues 
    
    >>> markov_model(Data, "path", "total_conversions", var_value="total_conversion_value")
    
    Estimate a Makov model using total conversions, revenues and paths that do not lead to conversions 

    >>> markov_model(Data, "path", "total_conversions", var_value="total_conversion_value", var_null="total_null")
    
    Estimate a Makov model returning transition matrix and removal effects 
    
    >>> markov_model(Data, "path", "total_conversions", var_value="total_conversion_value", var_null="total_null", out_more=True)

    Estimate a Markov model using 4 threads
    
    >>> markov_model(Data, "path", "total_conversions", var_value="total_conversion_value", ncore=4)
        
    '''

    if ("DataFrame" not in str(type(Data))):
        raise NameError("Data must be a DataFrame")
    
    if type(var_path)==str:
        if var_path not in Data.columns:
            raise NameError("var_path must be a column of Data")
    else:
        raise NameError("var_path must be a string")

    if (type(var_conv)==str):
        if (var_conv not in Data.columns):
            raise NameError("var_conv must be a column of Data")
        
    else:
        raise NameError("var_conv must be a string")
   
    if (var_value!=None):
        if (var_value not in Data.columns):
            raise NameError("var_value must be a column of Data")
        
    if (var_null!=None):
        if (var_null not in Data.columns):
            raise NameError("var_null must be a column of Data")
      
    if (order < 1):
        raise NameError("order must be >= 1")
    
    if (nsim_start!=None):
        if (nsim_start < 1):
            raise NameError("nsim must be >= 1")
        
    if (max_step!=None):
        if (max_step < 1):
            raise NameError("max_step must be >= 1")
        
    
    if (out_more not in [0, 1]):
        raise NameError("out_more must be False or True")
    
        
    if (len(sep) > 1):
        raise NameError("sep must have length 1")

    
    if (ncore < 1):
        raise NameError("ncore must be >= 1")
    
    if (nfold < 1):
        raise NameError("nfold must be >= 1")
    
    if (seed!=None):
        if (seed < 0):
            raise NameError("seed must be >= 0")

    if ((conv_par < 0) | (conv_par > 1)):
        raise NameError("conv_par must be into [0,1]")


    if (rate_step_sim < 0):
        raise NameError("rate_step_sim must be > 0")
        
    if (verbose not in [0, 1]): 
        raise NameError("verbose must be False or True")
        
        
    if sum(Data[var_conv]>0)==0:
        raise NameError("Data must have at least one converting path.")

    if (var_null==None):
        Data=Data[Data[var_conv]>0]    
    
    if (var_value==None):
        vv = pd.Series(None,dtype='float64')
    else:
        vv=Data[var_value]
    

    if (var_null==None):
        vn = pd.Series(None,dtype='float64')
    else:
        vn=Data[var_null]
        
    if (max_step==None):
        max_step = 0
    
    res0=__markov_model_1(vy=Data[var_path].str.encode('utf-8'),vc=Data[var_conv],vv=vv,vn=vn,order=order,nsim_start=nsim_start,max_step=max_step,out_more=out_more,sep=sep.encode("utf-8"),ncore=ncore, nfold=nfold, seed=seed, conv_par=conv_par, rate_step_sim=rate_step_sim, verbose=int(verbose))
        
    if (out_more==0) and (len(vv)==0):
    
        res=pd.DataFrame({'channel_name':pd.Series(res0[0][0]).str.decode('utf-8'),'total_conversions':res0[1][0]})
    
    elif (out_more==0) and (len(vv)>0):

        res=pd.DataFrame({'channel_name':pd.Series(res0[0][0]).str.decode('utf-8'),'total_conversions':res0[1][0],'total_conversion_value':res0[1][1]})

    elif (out_more==1) and (len(vv)==0):
        
        res=dict()
        
        res['result']=pd.DataFrame({'channel_name':pd.Series(res0[0][2]).str.decode('utf-8'),'total_conversions':res0[1][0]})
        res['transition_matrix']=pd.DataFrame({'channel_from':pd.Series(res0[0][0]).str.decode('utf-8'),'channel_to':pd.Series(res0[0][1]).str.decode('utf-8'),'transition_probability':res0[1][2]})
    
        res['removal_effects']=pd.DataFrame({'channel_name':pd.Series(res0[0][2]).str.decode('utf-8'),'removal_effect':res0[1][1]})
    
    else:
    
        res=dict()
        
        res['result']=pd.DataFrame({'channel_name':pd.Series(res0[0][2]).str.decode('utf-8'),'total_conversions':res0[1][0],'total_conversion_value':res0[1][3]})
        res['transition_matrix']=pd.DataFrame({'channel_from':pd.Series(res0[0][0]).str.decode('utf-8'),'channel_to':pd.Series(res0[0][1]).str.decode('utf-8'),'transition_probability':res0[1][2]})
    
        res['removal_effects']=pd.DataFrame({'channel_name':pd.Series(res0[0][2]).str.decode('utf-8'),'removal_effects_conversion':res0[1][1],'removal_effects_conversion_value':res0[1][4]})        
    
    if flg_pro==True:
        print(__message_pro)
    
    return(res)
    

def transition_matrix(Data,var_path,var_conv,var_null,order=1,sep=">",flg_equal=True, flg_pro=True):

    '''

    Estimate a k-order transition matrix from customer journey data.
    
    Parameters
    ----------
    Data : DataFrame
        customer journeys.
    var_path: string
        column of Data containing paths.
    var_conv : string
        column of Data containing total conversions for each path.
    var_null : string
        column of Data containing total paths that do not lead to conversion.
    order : int, default 1
        Markov model order.        
    sep : string, default ">"
        separator between the channels.    
    flg_equal: bool, default True
        if True, transitions from a channel to itself will be considered.    
    flg_pro : bool, default True
        if True, ChannelAttribution Pro banner is printed.
                    
    Returns
    -------
    list of DataFrames
        channels: Dataframe
            (column) id_channel : channel ids
            (column) channel_name : channel names
        transition_matrix : DataFrame
            (column) channel_from: id channel from
            (column) channel_to : id channel to
            (column) transition_probability : transition probability from channel_from to channel_to
                    
    Examples
    --------
    
    Load Data
    
    >>> import pandas as pd    
    >>> from ChannelAttribution import *
    >>> Data = pd.read_csv('https://channelattribution.io/csv/Data.csv',sep=";")

    Estimate a second-order transition matrix using total conversions and paths that do not lead to conversion 
    
    >>> transition_matrix(Data, "path", "total_conversions", var_null="total_null", order=2)
                    
    '''
     
    if ("DataFrame" not in str(type(Data))):
        raise NameError("Data must be a DataFrame")
    
    if type(var_path)==str:
        if var_path not in Data.columns:
            raise NameError("var_path must be a column of Data")
    else:
        raise NameError("var_path must be a string")

    if (type(var_conv)==str):
        if (var_conv not in Data.columns):
            raise NameError("var_conv must be a column of Data")
    else:
        raise NameError("var_conv must be a string")

    if (type(var_null)==str):
        if (var_null not in Data.columns):
            raise NameError("var_null must be a column of Data")        
    else:
        raise NameError("var_conv must be a string")
   
      
    if (order < 1):
        raise NameError("order must be >= 1")
    
        
    if (len(sep) > 1):
        raise NameError("sep must have length 1")

            
    if (flg_equal not in [0, 1]): 
        raise NameError("flg_equal must be False or True")
                    
    res0=__transition_matrix_1(vy=Data[var_path].str.encode('utf-8'),vc=Data[var_conv],vn=Data[var_null],order=order,sep=sep.encode("utf-8"), flg_equal=int(flg_equal))
    
    res=dict()
    res['channels']=pd.DataFrame({'id_channel':range(1,len(res0[0][2])+1), 'channel_name':pd.Series(res0[0][2]).str.decode('utf-8')})
    res['transition_matrix']=pd.DataFrame({'channel_from':pd.Series(res0[0][0]).str.decode('utf-8'),'channel_to':pd.Series(res0[0][1]).str.decode('utf-8'),'transition_probability':res0[1]})
    
    if flg_pro==True:
        print(__message_pro)

    return(res)
    
    
    
def auto_markov_model(Data, var_path, var_conv, var_null, var_value=None, max_order=10, roc_npt=100, plot=False, nsim_start=1e5, max_step=None, out_more=False, sep=">", ncore=1, nfold=10, seed=0, conv_par=0.05, rate_step_sim=1.5, verbose=True, flg_pro=True):

    '''
    
    Parameters
    ----------
    Data : DataFrame
        customer journeys.
    var_path: string
        column of Data containing paths.
    var_conv : string
        column of Data containing total conversions for each path.
    var_null : string
        column of Data containing total paths that do not lead to conversion.
    var_value : string, optional, default None
        column of Data containing revenue for each path
    max_order : int, default 10
        maximum Markov Model order to be considered.        
    roc_npt: int, default 100
        number of points to be used for the approximation of roc curve.    
    plot: bool, default True
        if True, a plot with penalized auc with respect to order will be displayed.
    nsim_start : int, default 1e5
        minimum number of simulations to be used in computation.        
    max_step : int, default None
        maximum number of steps for a single simulated path. if NULL, it is the maximum number of steps found into Data.        
    out_more : bool, default False
        if True, transition probabilities between channels and removal effects will be returned.                
    sep : string, default ">"
        separator between the channels.    
    ncore : int, default 1
        number of threads to be used in computation.        
    nfold : int, default 10
        how many repetitions to be used to verify if convergence has been reached at each iteration.    
    seed : int, default 0
        random seed. Giving this parameter the same value over different runs guarantees that results will not vary.    
    conv_par : double, default 0.05
        convergence parameter for the algorithm. The estimation process ends when the percentage of variation of the results over different repetions is less than convergence parameter.    
    rate_step_sim : double, default 0
        number of simulations used at each iteration is equal to the number of simulations used at previous iteration multiplied by rate_step_sim.    
    verbose : bool, default True
        if True, additional information about process convergence will be shown.    
    flg_pro : bool, default True
        if True, ChannelAttribution Pro banner is printed.
            
    Returns
    -------
    list of DataFrames
        result: Dataframe
            (column) channel_name : channel names
            (column) total_conversions : conversions attributed to each channel
            (column) total_conversion_value : revenues attributed to each channel
        transition_matrix : DataFrame
            (column) channel_from: channel from
            (column) channel_to : channel to
            (column) transition_probability : transition probability from channel_from to channel_to
        removal_effects:
            (column) channel_name : channel names 
            (column) removal_effects_conversion : removal effects for each channel calculated using total conversions
            (column) removal_effects_conversion_value : removal effects for each channel calculated using revenues
                
                        
    Examples
    --------
    
    Load Data
    
    >>> import pandas as pd    
    >>> from ChannelAttribution import *
    >>> Data = pd.read_csv('https://channelattribution.io/csv/Data.csv',sep=";")
    
    Estimate an automatic Makov model 
    
    >>> auto_markov_model(Data, "path", "total_conversions", "total_null")
        
    '''

    if ("DataFrame" not in str(type(Data))):
        raise NameError("Data must be a DataFrame")
    
    if type(var_path)==str:
        if var_path not in Data.columns:
            raise NameError("var_path must be a column of Data")
    else:
        raise NameError("var_path must be a string")

    if (type(var_conv)==str):
        if (var_conv not in Data.columns):
            raise NameError("var_conv must be a column of Data")
        
    else:
        raise NameError("var_conv must be a string")
   
   
    if (type(var_null)==str):
        if (var_null not in Data.columns):
            raise NameError("var_null must be a column of Data")
        
    else:
        raise NameError("var_null must be a string")
   
   
    if (var_value!=None):
        if (var_value not in Data.columns):
            raise NameError("var_value must be a column of Data")
              
    if (max_order < 1):
        raise NameError("max_order must be >= 1")
        
    if (roc_npt < 10):
        raise NameError("roc_npt must be >= 10")
        
    if (plot not in [0, 1]):
        raise NameError("plot must be False or True")
    
    if (nsim_start!=None):
        if (nsim_start < 1):
            raise NameError("nsim must be >= 1")
        
    if (max_step!=None):
        if (max_step < 1):
            raise NameError("max_step must be >= 1")
        
    
    if (out_more not in [0, 1]):
        raise NameError("out_more must be False or True")
    
        
    if (len(sep) > 1):
        raise NameError("sep must have length 1")

    
    if (ncore < 1):
        raise NameError("ncore must be >= 1")
    
    if (nfold < 1):
        raise NameError("nfold must be >= 1")
    
    if (seed!=None):
        if (seed < 0):
            raise NameError("seed must be >= 0")

    if ((conv_par < 0) | (conv_par > 1)):
        raise NameError("conv_par must be into [0,1]")


    if (rate_step_sim < 0):
        raise NameError("rate_step_sim must be > 0")
        
    if (verbose not in [0, 1]): 
        raise NameError("verbose must be False or True")
    
    if (var_value==None):
        vv = pd.Series(None,dtype='float64')
    else:
        vv=Data[var_value]
            
    [res_auc,res_roc,best_order] = choose_order(Data, var_path, var_conv, var_null, max_order = max_order, sep = sep, ncore = ncore, roc_npt = roc_npt, plot = plot, flg_pro=False)
    
    res = markov_model(Data, var_path, var_conv, var_value = var_value, var_null = var_null, order = best_order, nsim_start = nsim_start, max_step = max_step, out_more = out_more, sep = sep, ncore = ncore, nfold = nfold, seed = seed, conv_par = conv_par, rate_step_sim = rate_step_sim, verbose = verbose, flg_pro=False)
    
    if flg_pro==True:
        print(__message_pro)
    
    return(res)

# --- install_pro extracted from install_pro.py ---
# --- Extracted install_pro (for documentation) ---
def install_pro():

    """
    Interactive installer for ChannelAttribution Pro (Python wheel).

    This helper:
    - Prompts you for a token; if you type an email instead, it requests a token
      for that address and exits (so you can rerun with the token).
    - Detects your OS/arch/Python, asks the build service for the correct wheel via HTTPS POST,
      resolves the final wheel URL, and installs it with ``python -m pip``.
    - Sends exactly one final outcome notification to ``build_check_email.php`` (SUCCESS/ERROR)
      with a short, client-trimmed info blob.

    Notes
    -----
    User interaction:
    - On start, it asks: "Enter your ChannelAttributionPro token. If you don't have one,
      enter your work/university email to request it:"
    - If you enter a valid email, the function triggers a token email and returns immediately.
    - If you enter a non-empty token, the installation flow proceeds.
    - If you enter nothing, the function prints a message and returns.

    Environment detection:
    - OS name: manylinux (Linux), macOS (macOS), Windows (Windows)
    - OS version: Linux "2014" (ManyLinux2014), macOS "13" (amd64) or "15" (arm64), Windows "11"
    - Architecture: amd64 (x86_64) or arm64 (aarch64)
    - Python: running interpreter’s major.minor (e.g., 3.11)

    Network behavior:
    - Builder request: HTTPS POST to ``https://app.channelattribution.io/genpkg/genpkg.php``
      with ``{os, os_vers, arch, lang=python, lang_vers, replace=0, uctr=0, token}``.
    - Response handling:
      - 200 or 409 with JSON containing ``"pkg"``: direct wheel URL or a directory URL.
      - If a directory is returned, the latest file is selected (prefers ``*.whl``).
      - 401 or JSON error mentioning "invalid token": prints "Token non valid or expired..." and returns.
    - Installation: runs ``python -m pip install --prefer-binary`` on the resolved wheel URL.
    - Final notification (always exactly once): POSTs to
      ``https://app.channelattribution.io/genpkg/build_check_email.php`` with fields
      ``{token, action="SUCCESS"|"ERROR", info="<=8KiB compact JSON-like"}``.

    Packages and proxies:
    - Auto-installs ``requests`` (and ``distro`` on Linux) into the current interpreter.
      If not in a virtualenv, sets ``PIP_BREAK_SYSTEM_PACKAGES=1`` to respect Debian/Ubuntu PEP 668.
    - Honors standard system/proxy environment variables.

    Output and errors:
    - Prints progress and a short system report if something goes wrong (OS, distro, Python, compiler).
      Support message includes ``info@channelattribution.io``.
    - On success it prints:

      ::

          *** Package installed. Restart the session and try to import it with: import ChannelAttributionPro

    - Returns ``None``. Most error conditions are handled by printing and returning.
    - May raise ``ValueError`` only if an email-like input is given but fails basic syntax validation.

    Security notes:
    - Sends your token to the builder and in the final notification.
    - The ``info`` field is trimmed client-side (~8 KiB) and HTML-escaped server-side before emailing.
    - No personal data is sent beyond the token and generic environment traits.

    Examples
    --------
    >>> from ChannelAttribution import install_pro
    >>> install_pro()  # follow the prompt: paste token, or enter email to request one
    """

    import sys, os, platform, json, subprocess, shutil, re
    from html.parser import HTMLParser
    from urllib.request import Request, urlopen
    from urllib.error import URLError, HTTPError
    from urllib.parse import urlencode, urljoin
    import importlib.util, sysconfig
    from getpass import getpass

    # ---------- helpers: stdlib detection + ensure_package ----------
    STDLIB_DIR = sysconfig.get_paths().get("stdlib", "")

    def is_stdlib(mod_name: str) -> bool:
        spec = importlib.util.find_spec(mod_name)
        if spec is None or spec.origin is None:
            return False
        return spec.origin == "built-in" or spec.origin.startswith(STDLIB_DIR)

    def ensure_package(import_name: str, pip_name: str | None = None, version: str | None = None):
        if is_stdlib(import_name):
            return
        try:
            importlib.util.find_spec(import_name) or __import__(import_name)
            return
        except Exception:
            pass
        pkg = pip_name or import_name
        if version:
            pkg = f"{pkg}{version}"
        env = dict(os.environ)
        in_venv = (sys.prefix != sys.base_prefix)
        if not in_venv:
            env.setdefault("PIP_BREAK_SYSTEM_PACKAGES", "1")
        subprocess.check_call([sys.executable, "-m", "pip", "install",
                               "--disable-pip-version-check", pkg], env=env)

    def _read_secret(prompt: str = "Enter value: ") -> str:
        """Visible prompt (works with/without TTY)."""
        try:
            # Standard interactive prompt (visible)
            return input(prompt).strip()
        except EOFError:
            # Non-interactive / piped input fallback
            print(prompt, end="", flush=True)
            return sys.stdin.readline().rstrip("\n")

    _email_re = re.compile(r"^[^@\s]+@[^@\s]+\.[^@\s]+$")

    def _is_valid_email(s: str) -> bool:
        return isinstance(s, str) and bool(_email_re.match(s.strip()))

    # Only third-party:
    ensure_package("requests")
    # 'distro' is useful only on Linux
    if sys.platform.startswith("linux"):
        ensure_package("distro")

    import requests
    from requests.exceptions import RequestException, Timeout, SSLError
    distro = None
    if sys.platform.startswith("linux"):
        try:
            import distro as _d  # type: ignore
            distro = _d
        except Exception:
            distro = None

    # ---------- notifier (called exactly once at the end) ----------
    def notify_package_request(
        token: str,
        action: str,
        info: str,
        endpoint: str = "https://app.channelattribution.io/genpkg/build_check_email.php",
        timeout: int = 10,
        verify_ssl: bool = True,
    ) -> str:
        if not token:
            return "missing_token_param"
        data = {"token": token, "action": action, "info": info}
        try:
            r = requests.post(
                endpoint,
                data=data,
                timeout=timeout,
                verify=verify_ssl,
                allow_redirects=True,
                headers={
                    "User-Agent": "capro-build-check/1.1",
                    "Content-Type": "application/x-www-form-urlencoded",
                },
            )
            return (r.text or "").strip()
        except (Timeout, SSLError) as e:
            return f"network_or_ssl_error: {e}"
        except RequestException as e:
            return f"request_error: {e}"

    # ---------- small HTTP helper for builder (POST-only now) ----------
    UA = ("Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 "
          "(KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36")
    HEADERS = {
        "User-Agent": UA,
        "Accept": "application/json,text/html;q=0.8,*/*;q=0.5",
        "Accept-Language": "en-US,en;q=0.7",
        "Accept-Encoding": "identity",
        "Connection": "close",
        "Content-Type": "application/x-www-form-urlencoded",
    }

    def http_post_form(url: str, form: dict, timeout: int = 300):
        data = urlencode(form).encode("utf-8")
        req = Request(url, data=data, headers=HEADERS, method="POST")
        try:
            with urlopen(req, timeout=timeout) as resp:
                return resp.status, resp.read(), resp.headers
        except HTTPError as e:
            try:
                body = e.read()
            except Exception:
                body = b""
            return e.code, body, getattr(e, "headers", {})
        except URLError as e:
            return 0, str(e).encode("utf-8", "replace"), {}

    # ---------- HTML listing helper ----------
    class LinkCollector(HTMLParser):
        def __init__(self):
            super().__init__()
            self.links = []
        def handle_starttag(self, tag, attrs):
            if tag.lower() == "a":
                href = dict(attrs).get("href")
                if href:
                    self.links.append(href)

    def list_dir_files(dir_url):
        # Directory listings are fetched with GET (static files)
        try:
            with urlopen(Request(dir_url, headers={"User-Agent": UA}), timeout=60) as resp:
                status = resp.status
                body = resp.read()
        except HTTPError as e:
            status = e.code
            body = e.read()
        except URLError as e:
            print(f"Listing {dir_url} network error: {e}")
            return None
        if status != 200:
            print(f"Listing {dir_url} failed with HTTP {status}")
            return None
        html = body.decode("utf-8", errors="replace")
        p = LinkCollector()
        p.feed(html)
        return [h for h in p.links if h and h not in ("/", "../") and not h.endswith("/")]

    def resolve_pkg_url(pkg_value):
        if not isinstance(pkg_value, str) or not pkg_value:
            print("Invalid 'pkg' value in response.")
            return None
        if pkg_value.lower().endswith(".whl"):
            return pkg_value
        pkg_dir = pkg_value.rstrip("/") + "/"
        files = list_dir_files(pkg_dir)
        if files is None:
            return None
        wheels = [f for f in files if f.endswith(".whl")]
        chosen = (sorted(wheels) or sorted(files) or [None])[-1]
        if not chosen:
            print(f"No files found at {pkg_dir}")
            return None
        return urljoin(pkg_dir, chosen)

    def pip_install(url, extra_args=None):
        if not url:
            print("No package URL to install.")
            return False
        cmd = [sys.executable, "-m", "pip", "install",
               "--no-cache-dir", "--disable-pip-version-check", "--prefer-binary", url]
        if extra_args:
            cmd.extend(extra_args)
        print("Installing with:", " ".join(cmd))
        proc = subprocess.run(cmd, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, text=True)
        print(proc.stdout)
        if proc.returncode != 0:
            print(f"pip failed with exit code {proc.returncode}")
            return False
        return True

    # Prompt: token or email
    msg = ("Enter your ChannelAttributionPro token. "
           "If you don't have one, enter your work/university email to request it: ")
    token = _read_secret(msg).strip()

    # If it looks like an email, trigger the token request and exit
    if "@" in token:
        email = token
        if not _is_valid_email(email):
            raise ValueError("Please enter a valid email address or a token.")
        print("Sending a token...")
        _ = __request_token_channelattributionpro(email=email)
        print("*** We email the token to eligible work or university addresses - check your inbox and Spam/Junk; if you don't receive it, try a different work/university email, and if it still doesn't arrive, contact info@channelattribution.io.")
        return  # exit early; user will rerun with token

    if not token:
        print("A non-empty token or email is required.")
        return

    # ---------- detect environment ----------
    if sys.platform.startswith("linux"):
        os_name = "manylinux"
    elif sys.platform == "darwin":
        os_name = "macos"
    elif sys.platform in ("win32", "cygwin", "msys"):
        os_name = "windows"
    else:
        os_name = "manylinux"

    machine = platform.machine().lower()
    if machine in ("x86_64", "amd64"):
        arch = "amd64"
    elif machine in ("arm64", "aarch64"):
        arch = "arm64"
    else:
        arch = "amd64"

    lang = "python"
    lang_vers = f"{sys.version_info.major}.{sys.version_info.minor}"

    if os_name == "macos":
        os_vers = "13" if arch == "amd64" else "15"
    elif os_name == "windows":
        os_vers = "11"
    else:
        os_vers = "2014"

    params = {
        "os": os_name,
        "os_vers": os_vers,
        "arch": arch,
        "lang": lang,
        "lang_vers": lang_vers,
        "replace": "0",
        "uctr": "0",
        "token": token,
    }

    BASE_URL = "https://app.channelattribution.io/genpkg/genpkg.php"

    # ---------- one-shot try/finally to guarantee single notification ----------
    action = "ERROR"   # will flip to SUCCESS on good path
    info_blob = ""     # what we'll send to build_check_email.php

    def get_system_info_dict():
        sysname = platform.system()
        release = platform.release()
        archi = platform.machine() or platform.processor() or "unknown"
        py_impl = platform.python_implementation()
        py_ver = platform.python_version()
        distro_str = None
        if sysname == "Linux":
            try:
                if distro:
                    name = distro.name(pretty=True) or (distro.id() or "")
                    vers = distro.version(best=True) or ""
                    distro_str = " ".join(x for x in (name, vers) if x).strip() or None
            except Exception:
                pass
            if not distro_str:
                try:
                    data = {}
                    with open("/etc/os-release", "r", encoding="utf-8", errors="ignore") as f:
                        for line in f:
                            line = line.strip()
                            if not line or "=" not in line or line.startswith("#"):
                                continue
                            k, v = line.split("=", 1)
                            data[k] = v.strip().strip('"').strip("'")
                    distro_str = data.get("PRETTY_NAME") or " ".join(
                        x for x in (data.get("NAME"), data.get("VERSION")) if x
                    )
                except Exception:
                    pass
        elif sysname == "Darwin":
            try:
                p = subprocess.run(["sw_vers", "-productVersion"], capture_output=True, text=True)
                if p.returncode == 0:
                    distro_str = f"macOS {p.stdout.strip()}"
            except Exception:
                pass
        elif sysname == "Windows":
            distro_str = f"Windows {platform.release()} (build {platform.version()})"

        def _which_compiler():
            for exe in ("gcc", "cc", "clang"):
                if shutil.which(exe):
                    return exe
            return None

        def _compiler_version(exe):
            if not exe:
                return None
            try:
                p = subprocess.run([exe, "-dumpfullversion"], capture_output=True, text=True)
                if p.returncode == 0 and p.stdout.strip():
                    return f"{exe} {p.stdout.strip()}"
            except Exception:
                pass
            try:
                p = subprocess.run([exe, "--version"], capture_output=True, text=True)
                if p.returncode == 0 and p.stdout:
                    first = p.stdout.splitlines()[0].strip()
                    m = re.search(r"(gcc|clang)[^0-9]*([0-9]+(?:\.[0-9]+){0,3})", first, re.I)
                    return f"{m.group(1).lower()} {m.group(2)}" if m else first
            except Exception:
                pass
            return None

        comp = _which_compiler()
        comp_ver = _compiler_version(comp) if comp else None

        return {
            "os": sysname,
            "os_release": release,
            "architecture": archi,
            "distro": distro_str,
            "python_implementation": py_impl,
            "python_version": py_ver,
            "compiler": comp_ver or "not found",
        }

    # pretty-printed version for user output
    def get_system_info():
        return json.dumps(get_system_info_dict(), indent=2)

    try:
        print("Building the package. Estimated time: 0-30 minutes. Please wait...")

        # POST to builder (matches hardened PHP)
        status, body, headers = http_post_form(BASE_URL, params, timeout=300)
        text = body.decode("utf-8", errors="replace") if isinstance(body, (bytes, bytearray)) else str(body)

        if status == 401:
            print("Token non valid or expired. Write to info@channelattribution.io.")
            action = "ERROR"
            info_blob = json.dumps({"reason": "invalid_token", "builder_status": status,
                                    "system": get_system_info_dict()}, indent=2)
            return

        data = None
        try:
            data = json.loads(text)
        except Exception:
            data = None

        # defensive token check in-body
        if isinstance(data, dict):
            err = (data.get("error") or "").lower()
            stat = (data.get("status") or "").lower()
            if "invalid token" in err or (stat in ("fail", "error") and "token" in err):
                print("Token non valid or expired. Write to info@channelattribution.io.")
                action = "ERROR"
                info_blob = json.dumps({"reason": "invalid_token_in_body", "builder_status": status,
                                        "body": (text[:500] if text else ""),
                                        "system": get_system_info_dict()}, indent=2)
                return

        # Resolve wheel URL
        pkg_file_url = None
        ok_path = True
        if status in (200, 409) and isinstance(data, dict) and "pkg" in data:
            pkg_file_url = resolve_pkg_url(data["pkg"])
            if not pkg_file_url:
                ok_path = False
        else:
            ok_path = False
            # Friendly support message
            print("Installation failed. Send the following information:\n")
            print(get_system_info())
            print("\nto info@channelattribution.io.")
            action = "ERROR"
            info_blob = json.dumps({"result": "builder_unexpected_response",
                                    "builder_status": status,
                                    "body": (text[:500] if text else ""),
                                    "system": get_system_info_dict()}, indent=2)

        if ok_path and pkg_file_url:
            ok = pip_install(pkg_file_url)
            if ok:
                print("*** Package installed. Restart the session and try to import it with: import ChannelAttributionPro")
                action = "SUCCESS"
                info_blob = json.dumps({"result": "installed", "wheel": pkg_file_url,
                                        "system": get_system_info_dict()}, indent=2)
                return
            else:
                print("Installation failed. Send the following information:\n")
                print(get_system_info())
                print("\nto info@channelattribution.io.")
                action = "ERROR"
                info_blob = json.dumps({"result": "pip_failed", "wheel": pkg_file_url,
                                        "system": get_system_info_dict()}, indent=2)
                return
        elif not ok_path:
            # already printed support message above and set info_blob/action
            return

    finally:
        # ONE final notification (success or error). Keep it short on the wire.
        try:
            info_to_send = (info_blob or "")
            if len(info_to_send) > 8192:
                info_to_send = info_to_send[:8192] + "...(truncated)"
            _ = notify_package_request(token, action, info_to_send)
        except Exception:
            pass
