# GCP Platform Documentation

This directory contains comprehensive documentation for the GCP (Google Cloud Platform) integration.

## Available Guides

- [Installation Guide](installation.md) - How to install and set up GCP integration
- [Configuration Guide](configuration.md) - How to configure GCP credentials and settings
- [Usage Guide](usage.md) - How to use GCP commands and features
- [Troubleshooting Guide](troubleshooting.md) - Common issues and solutions

## Services Supported

- Compute Engine (Virtual machines)
- Cloud Storage
- VPC (Virtual Private Cloud)
- Cloud SQL
- GKE (Google Kubernetes Engine)
- Cloud Functions
- Cloud Run
- Load Balancers
- Firewall Rules
- Billing

## Quick Start

1. Follow the [Installation Guide](installation.md) to set up GCP integration
2. Configure your credentials using the [Configuration Guide](configuration.md)
3. Start using GCP commands as described in the [Usage Guide](usage.md)

For issues, check the [Troubleshooting Guide](troubleshooting.md) or refer to the main project documentation.

## Legacy Documentation

- [GCP Configuration Guide](GCP_CONFIGURATION_GUIDE.md) - Detailed GCP configuration instructions
- [GCP Security Best Practices](GCP_SECURITY_BEST_PRACTICES.md) - Security guidelines for GCP integration
- [Environment Examples](env-examples/) - Sample environment configurations
- [Scripts](scripts/) - Utility scripts for GCP management