import { IUser } from "aws-cdk-lib/aws-iam";
import { ISecret } from "aws-cdk-lib/aws-secretsmanager";
import { Construct } from "constructs";
export declare class CredentialsProvider extends Construct {
    /**
     * Retrieve CredentialsProvider as stack singleton resource.
     *
     * https://github.com/aws/aws-cdk/issues/5023
     */
    static getOrCreate(scope: Construct): CredentialsProvider;
    readonly serviceToken: string;
    private userArns;
    private secretArns;
    constructor(scope: Construct, id: string);
    grant(user: IUser, secret: ISecret): void;
}
