/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import org.mpxj.Availability;
import org.mpxj.LocalDateTimeRange;
import org.mpxj.common.LocalDateTimeHelper;

public final class AvailabilityTable
extends ArrayList<Availability> {
    public static final LocalDateTime END_DATE_NA = LocalDateTime.of(2049, 12, 31, 23, 58);

    public Availability getEntryByDate(LocalDateTime date) {
        Availability entry;
        LocalDateTimeRange range;
        int comparisonResult;
        Availability result = null;
        Iterator iterator = this.iterator();
        while (iterator.hasNext() && (comparisonResult = (range = (entry = (Availability)iterator.next()).getRange()).compareTo(date)) >= 0) {
            if (comparisonResult != 0) continue;
            result = entry;
            break;
        }
        return result;
    }

    public boolean hasDefaultDateRange() {
        if (this.isEmpty()) {
            return true;
        }
        if (this.size() != 1) {
            return false;
        }
        LocalDateTimeRange range = ((Availability)this.get(0)).getRange();
        return !(range.getStart() != null && !range.getStart().equals(LocalDateTimeHelper.START_DATE_NA) || range.getEnd() != null && !range.getEnd().isAfter(END_DATE_NA));
    }

    public LocalDateTime availableFrom(LocalDateTime date) {
        if (this.hasDefaultDateRange()) {
            return null;
        }
        this.sort(Comparator.naturalOrder());
        LocalDateTimeRange previousRange = null;
        for (Availability availability : this) {
            LocalDateTimeRange currentRange = availability.getRange();
            LocalDateTime rangeStart = currentRange.getStart();
            if (rangeStart == null) {
                rangeStart = LocalDateTimeHelper.START_DATE_NA;
            }
            if (date.isBefore(rangeStart)) {
                return previousRange == null ? null : previousRange.getEnd().plusMinutes(1L);
            }
            LocalDateTime rangeEnd = currentRange.getEnd();
            if (rangeEnd == null || rangeEnd.isAfter(END_DATE_NA) || date.isBefore(rangeEnd) || date.isEqual(rangeEnd)) {
                return LocalDateTimeHelper.START_DATE_NA.isEqual(rangeStart) ? null : rangeStart;
            }
            previousRange = currentRange;
        }
        return previousRange == null ? null : previousRange.getEnd().plusMinutes(1L);
    }

    public LocalDateTime availableTo(LocalDateTime date) {
        if (this.hasDefaultDateRange()) {
            return null;
        }
        this.sort(Comparator.naturalOrder());
        for (Availability availability : this) {
            LocalDateTimeRange currentRange = availability.getRange();
            LocalDateTime rangeEnd = currentRange.getEnd();
            if (rangeEnd == null) {
                rangeEnd = LocalDateTimeHelper.END_DATE_NA;
            }
            if (date.isAfter(rangeEnd)) continue;
            LocalDateTime rangeStart = currentRange.getStart();
            if (rangeStart == null) {
                rangeStart = LocalDateTimeHelper.START_DATE_NA;
            }
            if (date.isBefore(rangeStart)) {
                return rangeStart.minusMinutes(1L);
            }
            return rangeEnd.isAfter(END_DATE_NA) ? null : rangeEnd;
        }
        return null;
    }
}

