/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.util.EnumSet;
import java.util.Locale;
import org.mpxj.DataType;
import org.mpxj.FieldType;
import org.mpxj.FieldTypeClass;
import org.mpxj.LocaleData;

public enum ConstraintField implements FieldType
{
    UNIQUE_ID(DataType.INTEGER),
    TASK1(DataType.INTEGER),
    TASK2(DataType.INTEGER);

    public static final int MAX_VALUE;
    private static final ConstraintField[] TYPE_VALUES;
    private int m_value;
    private final DataType m_dataType;

    private ConstraintField(DataType dataType) {
        this.m_dataType = dataType;
    }

    @Override
    public FieldTypeClass getFieldTypeClass() {
        return FieldTypeClass.CONSTRAINT;
    }

    @Override
    public String getName() {
        return this.getName(Locale.ENGLISH);
    }

    @Override
    public String getName(Locale locale) {
        String[] titles = LocaleData.getStringArray(locale, "CONSTRAINT_COLUMNS");
        String result = null;
        if (this.m_value >= 0 && this.m_value < titles.length) {
            result = titles[this.m_value];
        }
        return result;
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    @Override
    public DataType getDataType() {
        return this.m_dataType;
    }

    @Override
    public FieldType getUnitsType() {
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public static ConstraintField getInstance(int type) {
        ConstraintField result = null;
        if (type >= 0 && type < MAX_VALUE) {
            result = TYPE_VALUES[type];
        }
        return result;
    }

    static {
        MAX_VALUE = EnumSet.allOf(ConstraintField.class).size();
        TYPE_VALUES = new ConstraintField[MAX_VALUE];
        int value = 0;
        for (ConstraintField e : EnumSet.allOf(ConstraintField.class)) {
            e.m_value = value++;
            ConstraintField.TYPE_VALUES[e.getValue()] = e;
        }
    }
}

