/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.time.LocalDateTime;
import java.util.ArrayList;
import org.mpxj.CostRateTableEntry;
import org.mpxj.Rate;

public class CostRateTable
extends ArrayList<CostRateTableEntry> {
    public static final int MAX_TABLES = 5;

    public CostRateTableEntry getEntryByDate(LocalDateTime date) {
        CostRateTableEntry result = null;
        for (CostRateTableEntry entry : this) {
            if (!date.isBefore(entry.getEndDate())) continue;
            result = entry;
            break;
        }
        return result;
    }

    public int getIndexByDate(LocalDateTime date) {
        int result = -1;
        int index = 0;
        for (CostRateTableEntry entry : this) {
            if (date.isBefore(entry.getEndDate())) {
                result = index;
                break;
            }
            ++index;
        }
        return result;
    }

    public boolean tableIsPopulated() {
        return !this.isEmpty() && (this.size() != 1 || !this.allEntriesAreDefault());
    }

    private boolean allEntriesAreDefault() {
        for (CostRateTableEntry entry : this) {
            for (int rateIndex = 0; rateIndex < 5; ++rateIndex) {
                Rate rate = entry.getRate(rateIndex);
                if (rate == null || rate.getAmount() == 0.0) continue;
                return false;
            }
        }
        return true;
    }
}

