/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mpxj.Rate;
import org.mpxj.ShiftPeriod;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.common.NumberHelper;

public final class CostRateTableEntry
implements Comparable<CostRateTableEntry> {
    private final LocalDateTime m_startDate;
    private final LocalDateTime m_endDate;
    private final Number m_costPerUse;
    private final Rate[] m_rates = new Rate[5];
    private final ShiftPeriod m_shiftPeriod;
    public static final CostRateTableEntry DEFAULT_ENTRY = new CostRateTableEntry();
    public static final int MAX_RATES = 5;

    private CostRateTableEntry() {
        this(LocalDateTimeHelper.START_DATE_NA, LocalDateTimeHelper.END_DATE_NA, (Number)NumberHelper.DOUBLE_ZERO, new Rate[0]);
    }

    public CostRateTableEntry(LocalDateTime startDate, LocalDateTime endDate, Number costPerUse, Rate ... rates) {
        this(startDate, endDate, costPerUse, (ShiftPeriod)null, rates);
    }

    public CostRateTableEntry(LocalDateTime startDate, LocalDateTime endDate, Number costPerUse, ShiftPeriod shiftPeriod, Rate ... rates) {
        this.m_startDate = startDate;
        this.m_endDate = endDate;
        this.m_costPerUse = costPerUse;
        this.m_shiftPeriod = shiftPeriod;
        Arrays.fill(this.m_rates, Rate.ZERO);
        System.arraycopy(rates, 0, this.m_rates, 0, rates.length);
    }

    public LocalDateTime getStartDate() {
        return this.m_startDate;
    }

    public LocalDateTime getEndDate() {
        return this.m_endDate;
    }

    public Rate getRate(int index) {
        return this.m_rates[index];
    }

    public Rate getStandardRate() {
        return this.getRate(0);
    }

    public Rate getOvertimeRate() {
        return this.getRate(1);
    }

    public Number getCostPerUse() {
        return this.m_costPerUse;
    }

    public ShiftPeriod getShiftPeriod() {
        return this.m_shiftPeriod;
    }

    @Override
    public int compareTo(CostRateTableEntry o) {
        return LocalDateTimeHelper.compare(this.m_endDate, o.m_endDate);
    }

    public String toString() {
        String rates = Stream.of(this.m_rates).map(String::valueOf).collect(Collectors.joining(", "));
        return "[CostRateTableEntry startDate=" + this.m_startDate + " endDate=" + this.m_endDate + " costPerUse=" + this.m_costPerUse + " rates=" + rates + "]";
    }
}

