/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import org.mpxj.ProjectEntityWithUniqueID;
import org.mpxj.UniqueIdObjectSequenceProvider;

public final class Currency
implements ProjectEntityWithUniqueID {
    private final Integer m_uniqueID;
    private final String m_currencyID;
    private final String m_name;
    private final String m_symbol;
    private final Double m_exchangeRate;
    private final String m_decimalSymbol;
    private final Integer m_numberOfDecimalPlaces;
    private final String m_digitGroupingSymbol;
    private final String m_positiveCurrencyFormat;
    private final String m_negativeCurrencyFormat;

    private Currency(Builder builder) {
        this.m_uniqueID = builder.m_sequenceProvider == null ? builder.m_uniqueID : builder.m_sequenceProvider.getUniqueIdObjectSequence(Currency.class).syncOrGetNext(builder.m_uniqueID);
        this.m_currencyID = builder.m_currencyID;
        this.m_name = builder.m_name;
        this.m_symbol = builder.m_symbol;
        this.m_exchangeRate = builder.m_exchangeRate;
        this.m_decimalSymbol = builder.m_decimalSymbol;
        this.m_numberOfDecimalPlaces = builder.m_numberOfDecimalPlaces;
        this.m_digitGroupingSymbol = builder.m_digitGroupingSymbol;
        this.m_positiveCurrencyFormat = builder.m_positiveCurrencyFormat;
        this.m_negativeCurrencyFormat = builder.m_negativeCurrencyFormat;
    }

    @Override
    public Integer getUniqueID() {
        return this.m_uniqueID;
    }

    public String getCurrencyID() {
        return this.m_currencyID;
    }

    public String getName() {
        return this.m_name;
    }

    public String getSymbol() {
        return this.m_symbol;
    }

    public Double getExchangeRate() {
        return this.m_exchangeRate;
    }

    public String getDecimalSymbol() {
        return this.m_decimalSymbol;
    }

    public Integer getNumberOfDecimalPlaces() {
        return this.m_numberOfDecimalPlaces;
    }

    public String getDigitGroupingSymbol() {
        return this.m_digitGroupingSymbol;
    }

    public String getPositiveCurrencyFormat() {
        return this.m_positiveCurrencyFormat;
    }

    public String getNegativeCurrencyFormat() {
        return this.m_negativeCurrencyFormat;
    }

    public static class Builder {
        private final UniqueIdObjectSequenceProvider m_sequenceProvider;
        private Integer m_uniqueID;
        private String m_currencyID;
        private String m_name;
        private String m_symbol;
        private Double m_exchangeRate;
        private String m_decimalSymbol;
        private Integer m_numberOfDecimalPlaces;
        private String m_digitGroupingSymbol;
        private String m_positiveCurrencyFormat;
        private String m_negativeCurrencyFormat;

        public Builder(UniqueIdObjectSequenceProvider sequenceProvider) {
            this.m_sequenceProvider = sequenceProvider;
        }

        public Builder from(Currency value) {
            this.m_uniqueID = value.m_uniqueID;
            this.m_currencyID = value.m_currencyID;
            this.m_name = value.m_name;
            this.m_symbol = value.m_symbol;
            this.m_exchangeRate = value.m_exchangeRate;
            this.m_decimalSymbol = value.m_decimalSymbol;
            this.m_numberOfDecimalPlaces = value.m_numberOfDecimalPlaces;
            this.m_digitGroupingSymbol = value.m_digitGroupingSymbol;
            this.m_positiveCurrencyFormat = value.m_positiveCurrencyFormat;
            this.m_negativeCurrencyFormat = value.m_negativeCurrencyFormat;
            return this;
        }

        public Builder uniqueID(Integer value) {
            this.m_uniqueID = value;
            return this;
        }

        public Builder currencyID(String value) {
            this.m_currencyID = value;
            return this;
        }

        public Builder name(String value) {
            this.m_name = value;
            return this;
        }

        public Builder symbol(String value) {
            this.m_symbol = value;
            return this;
        }

        public Builder exchangeRate(Double value) {
            this.m_exchangeRate = value;
            return this;
        }

        public Builder decimalSymbol(String value) {
            this.m_decimalSymbol = value;
            return this;
        }

        public Builder numberOfDecimalPlaces(Integer value) {
            this.m_numberOfDecimalPlaces = value;
            return this;
        }

        public Builder digitGroupingSymbol(String value) {
            this.m_digitGroupingSymbol = value;
            return this;
        }

        public Builder positiveCurrencyFormat(String value) {
            this.m_positiveCurrencyFormat = value;
            return this;
        }

        public Builder negativeCurrencyFormat(String value) {
            this.m_negativeCurrencyFormat = value;
            return this;
        }

        public Currency build() {
            return new Currency(this);
        }
    }
}

