/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.mpxj.CustomField;
import org.mpxj.FieldType;
import org.mpxj.FieldTypeClass;
import org.mpxj.common.Pair;
import org.mpxj.mpp.CustomFieldValueItem;

public class CustomFieldContainer
implements Iterable<CustomField> {
    private final Map<FieldType, CustomField> m_configMap = new HashMap<FieldType, CustomField>();
    private final Map<Integer, CustomFieldValueItem> m_valueMap = new HashMap<Integer, CustomFieldValueItem>();
    private final Map<UUID, CustomFieldValueItem> m_guidMap = new HashMap<UUID, CustomFieldValueItem>();
    private final Map<Pair<FieldTypeClass, String>, FieldType> m_aliasMap = new HashMap<Pair<FieldTypeClass, String>, FieldType>();

    public CustomField get(FieldType field) {
        return this.m_configMap.get(field);
    }

    public CustomField getOrCreate(FieldType field) {
        return this.m_configMap.computeIfAbsent(field, k -> new CustomField(field, this));
    }

    public CustomField add(FieldType field) {
        CustomField result = new CustomField(field, this);
        this.m_configMap.put(field, result);
        return result;
    }

    public void remove(FieldType field) {
        this.m_configMap.remove(field);
    }

    public FieldType getFieldTypeByAlias(FieldTypeClass typeClass, String alias) {
        return this.m_aliasMap.get(new Pair<FieldTypeClass, String>(typeClass, alias));
    }

    public List<CustomField> getCustomFieldsByFieldTypeClass(FieldTypeClass typeClass) {
        return this.stream().filter(f -> f.getFieldType().getFieldTypeClass() == typeClass).collect(Collectors.toList());
    }

    public int size() {
        return this.m_configMap.size();
    }

    @Override
    public Iterator<CustomField> iterator() {
        return this.m_configMap.values().iterator();
    }

    public CustomFieldValueItem getCustomFieldValueItemByUniqueID(int uniqueID) {
        return this.m_valueMap.get(uniqueID);
    }

    public CustomFieldValueItem getCustomFieldValueItemByGuid(UUID guid) {
        return this.m_guidMap.get(guid);
    }

    public void registerValue(CustomFieldValueItem item) {
        this.m_valueMap.put(item.getUniqueID(), item);
        if (item.getGUID() != null) {
            this.m_guidMap.put(item.getGUID(), item);
        }
    }

    public void deregisterValue(CustomFieldValueItem item) {
        this.m_valueMap.remove(item.getUniqueID());
        if (item.getGUID() != null) {
            this.m_guidMap.remove(item.getGUID());
        }
    }

    void registerAlias(FieldType type, String alias) {
        this.m_aliasMap.put(new Pair<FieldTypeClass, String>(type.getFieldTypeClass(), alias), type);
    }

    public Stream<CustomField> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }
}

