/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.util.ArrayList;
import java.util.List;
import org.mpxj.ProjectCalendar;
import org.mpxj.Relation;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignment;
import org.mpxj.Task;
import org.mpxj.listener.ProjectListener;

public class EventManager {
    private List<ProjectListener> m_projectListeners;

    public void fireTaskReadEvent(Task task) {
        if (this.m_projectListeners != null) {
            for (ProjectListener listener : this.m_projectListeners) {
                listener.taskRead(task);
            }
        }
    }

    public void fireTaskWrittenEvent(Task task) {
        if (this.m_projectListeners != null) {
            for (ProjectListener listener : this.m_projectListeners) {
                listener.taskWritten(task);
            }
        }
    }

    public void fireResourceReadEvent(Resource resource) {
        if (this.m_projectListeners != null) {
            for (ProjectListener listener : this.m_projectListeners) {
                listener.resourceRead(resource);
            }
        }
    }

    public void fireResourceWrittenEvent(Resource resource) {
        if (this.m_projectListeners != null) {
            for (ProjectListener listener : this.m_projectListeners) {
                listener.resourceWritten(resource);
            }
        }
    }

    public void fireCalendarReadEvent(ProjectCalendar calendar) {
        if (this.m_projectListeners != null) {
            for (ProjectListener listener : this.m_projectListeners) {
                listener.calendarRead(calendar);
            }
        }
    }

    public void fireAssignmentReadEvent(ResourceAssignment resourceAssignment) {
        if (this.m_projectListeners != null) {
            for (ProjectListener listener : this.m_projectListeners) {
                listener.assignmentRead(resourceAssignment);
            }
        }
    }

    public void fireAssignmentWrittenEvent(ResourceAssignment resourceAssignment) {
        if (this.m_projectListeners != null) {
            for (ProjectListener listener : this.m_projectListeners) {
                listener.assignmentWritten(resourceAssignment);
            }
        }
    }

    public void fireRelationReadEvent(Relation relation) {
        if (this.m_projectListeners != null) {
            for (ProjectListener listener : this.m_projectListeners) {
                listener.relationRead(relation);
            }
        }
    }

    public void fireRelationWrittenEvent(Relation relation) {
        if (this.m_projectListeners != null) {
            for (ProjectListener listener : this.m_projectListeners) {
                listener.relationWritten(relation);
            }
        }
    }

    public void fireCalendarWrittenEvent(ProjectCalendar calendar) {
        if (this.m_projectListeners != null) {
            for (ProjectListener listener : this.m_projectListeners) {
                listener.calendarWritten(calendar);
            }
        }
    }

    public void addProjectListener(ProjectListener listener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new ArrayList<ProjectListener>();
        }
        this.m_projectListeners.add(listener);
    }

    public void addProjectListeners(List<ProjectListener> listeners) {
        if (listeners != null) {
            for (ProjectListener listener : listeners) {
                this.addProjectListener(listener);
            }
        }
    }

    public void removeProjectListener(ProjectListener listener) {
        if (this.m_projectListeners != null) {
            this.m_projectListeners.remove(listener);
        }
    }
}

