/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import org.mpxj.AccrueType;
import org.mpxj.CostAccount;
import org.mpxj.ExpenseCategory;
import org.mpxj.Task;

public final class ExpenseItem {
    private final Task m_task;
    private final Integer m_uniqueID;
    private final String m_name;
    private final CostAccount m_account;
    private final ExpenseCategory m_category;
    private final String m_description;
    private final String m_documentNumber;
    private final String m_vendor;
    private final Double m_atCompletionCost;
    private final Double m_atCompletionUnits;
    private final Double m_actualCost;
    private final Double m_actualUnits;
    private final Double m_pricePerUnit;
    private final Double m_remainingCost;
    private final Double m_remainingUnits;
    private final Double m_plannedCost;
    private final Double m_plannedUnits;
    private final AccrueType m_accrueType;
    private final boolean m_autoComputeActuals;
    private final String m_unitOfMeasure;

    private ExpenseItem(Builder builder) {
        this.m_task = builder.m_task;
        this.m_uniqueID = this.m_task.getParentFile().getUniqueIdObjectSequence(ExpenseItem.class).syncOrGetNext(builder.m_uniqueID);
        this.m_name = builder.m_name;
        this.m_account = builder.m_account;
        this.m_category = builder.m_category;
        this.m_description = builder.m_description;
        this.m_documentNumber = builder.m_documentNumber;
        this.m_vendor = builder.m_vendor;
        this.m_atCompletionCost = builder.m_atCompletionCost;
        this.m_atCompletionUnits = builder.m_atCompletionUnits;
        this.m_actualCost = builder.m_actualCost;
        this.m_actualUnits = builder.m_actualUnits;
        this.m_pricePerUnit = builder.m_pricePerUnit;
        this.m_remainingCost = builder.m_remainingCost;
        this.m_remainingUnits = builder.m_remainingUnits;
        this.m_plannedCost = builder.m_plannedCost;
        this.m_plannedUnits = builder.m_plannedUnits;
        this.m_accrueType = builder.m_accrueType;
        this.m_autoComputeActuals = builder.m_autoComputeActuals;
        this.m_unitOfMeasure = builder.m_unitOfMeasure;
    }

    public Integer getUniqueID() {
        return this.m_uniqueID;
    }

    public String getName() {
        return this.m_name;
    }

    public Integer getAccountUniqueID() {
        return this.m_account == null ? null : this.m_account.getUniqueID();
    }

    public CostAccount getAccount() {
        return this.m_account;
    }

    public Integer getCategoryUniqueID() {
        return this.m_category == null ? null : this.m_category.getUniqueID();
    }

    public ExpenseCategory getCategory() {
        return this.m_category;
    }

    public Task getTask() {
        return this.m_task;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getDocumentNumber() {
        return this.m_documentNumber;
    }

    public String getVendor() {
        return this.m_vendor;
    }

    public Double getAtCompletionCost() {
        return this.m_atCompletionCost;
    }

    public Double getAtCompletionUnits() {
        return this.m_atCompletionUnits;
    }

    public Double getActualCost() {
        return this.m_actualCost;
    }

    public Double getActualUnits() {
        return this.m_actualUnits;
    }

    public Double getPricePerUnit() {
        return this.m_pricePerUnit;
    }

    public Double getRemainingCost() {
        return this.m_remainingCost;
    }

    public Double getRemainingUnits() {
        return this.m_remainingUnits;
    }

    public Double getPlannedCost() {
        return this.m_plannedCost;
    }

    public Double getPlannedUnits() {
        return this.m_plannedUnits;
    }

    public AccrueType getAccrueType() {
        return this.m_accrueType;
    }

    public boolean getAutoComputeActuals() {
        return this.m_autoComputeActuals;
    }

    public String getUnitOfMeasure() {
        return this.m_unitOfMeasure;
    }

    public String toString() {
        return "[ExpenseItem uniqueID=" + this.m_uniqueID + " name=" + this.m_name + "]";
    }

    public static class Builder {
        private final Task m_task;
        private Integer m_uniqueID;
        private String m_name;
        private CostAccount m_account;
        private ExpenseCategory m_category;
        private String m_description;
        private String m_documentNumber;
        private String m_vendor;
        private Double m_atCompletionCost;
        private Double m_atCompletionUnits;
        private Double m_actualCost;
        private Double m_actualUnits;
        private Double m_pricePerUnit;
        private Double m_remainingCost;
        private Double m_remainingUnits;
        private Double m_plannedCost;
        private Double m_plannedUnits;
        private AccrueType m_accrueType;
        private boolean m_autoComputeActuals;
        private String m_unitOfMeasure;

        public Builder(Task task) {
            this.m_task = task;
        }

        public Builder from(ExpenseItem value) {
            this.m_uniqueID = value.m_uniqueID;
            this.m_name = value.m_name;
            this.m_account = value.m_account;
            this.m_category = value.m_category;
            this.m_description = value.m_description;
            this.m_documentNumber = value.m_documentNumber;
            this.m_vendor = value.m_vendor;
            this.m_atCompletionCost = value.m_atCompletionCost;
            this.m_atCompletionUnits = value.m_atCompletionUnits;
            this.m_actualCost = value.m_actualCost;
            this.m_actualUnits = value.m_actualUnits;
            this.m_pricePerUnit = value.m_pricePerUnit;
            this.m_remainingCost = value.m_remainingCost;
            this.m_remainingUnits = value.m_remainingUnits;
            this.m_plannedCost = value.m_plannedCost;
            this.m_plannedUnits = value.m_plannedUnits;
            this.m_accrueType = value.m_accrueType;
            this.m_autoComputeActuals = value.m_autoComputeActuals;
            this.m_unitOfMeasure = value.m_unitOfMeasure;
            return this;
        }

        public Builder uniqueID(Integer value) {
            this.m_uniqueID = value;
            return this;
        }

        public Builder name(String value) {
            this.m_name = value;
            return this;
        }

        public Builder account(CostAccount value) {
            this.m_account = value;
            return this;
        }

        public Builder category(ExpenseCategory value) {
            this.m_category = value;
            return this;
        }

        public Builder description(String value) {
            this.m_description = value;
            return this;
        }

        public Builder documentNumber(String value) {
            this.m_documentNumber = value;
            return this;
        }

        public Builder vendor(String value) {
            this.m_vendor = value;
            return this;
        }

        public Builder atCompletionCost(Double value) {
            this.m_atCompletionCost = value;
            return this;
        }

        public Builder atCompletionUnits(Double value) {
            this.m_atCompletionUnits = value;
            return this;
        }

        public Builder actualCost(Double value) {
            this.m_actualCost = value;
            return this;
        }

        public Builder actualUnits(Double value) {
            this.m_actualUnits = value;
            return this;
        }

        public Builder pricePerUnit(Double value) {
            this.m_pricePerUnit = value;
            return this;
        }

        public Builder remainingCost(Double value) {
            this.m_remainingCost = value;
            return this;
        }

        public Builder remainingUnits(Double value) {
            this.m_remainingUnits = value;
            return this;
        }

        public Builder plannedCost(Double value) {
            this.m_plannedCost = value;
            return this;
        }

        public Builder plannedUnits(Double value) {
            this.m_plannedUnits = value;
            return this;
        }

        public Builder accrueType(AccrueType value) {
            this.m_accrueType = value;
            return this;
        }

        public Builder autoComputeActuals(boolean value) {
            this.m_autoComputeActuals = value;
            return this;
        }

        public Builder unitOfMeasure(String value) {
            this.m_unitOfMeasure = value;
            return this;
        }

        public ExpenseItem build() {
            return new ExpenseItem(this);
        }
    }
}

