/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.mpxj.MPXJException;
import org.mpxj.ProjectFile;
import org.mpxj.reader.UniversalProjectReader;

class ExternalProjectContainer {
    private final ProjectFile m_file;
    private final Map<String, File> m_fileMap = new HashMap<String, File>();
    private final Map<File, ProjectFile> m_projectMap = new HashMap<File, ProjectFile>();

    public ExternalProjectContainer(ProjectFile file) {
        this.m_file = file;
    }

    public void add(String fileName, ProjectFile projectFile) {
        File file = new File(fileName);
        this.m_fileMap.put(fileName, file);
        this.m_projectMap.put(file, projectFile);
    }

    public ProjectFile read(String fileName) {
        File file;
        if (fileName == null || fileName.isEmpty()) {
            return null;
        }
        if (this.m_fileMap.containsKey(fileName)) {
            file = this.m_fileMap.get(fileName);
        } else {
            file = this.findFile(fileName);
            this.m_fileMap.put(fileName, file);
        }
        if (file == null) {
            return null;
        }
        if (this.m_projectMap.containsKey(file)) {
            return this.m_projectMap.get(file);
        }
        ProjectFile project = this.readFile(file);
        this.m_projectMap.put(file, project);
        return project;
    }

    private File findFile(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            int index = fileName.lastIndexOf("\\");
            if (index == -1) {
                return null;
            }
            String name = fileName.substring(index + 1);
            File subprojectWorkingDirectory = this.m_file.getProjectConfig().getSubprojectWorkingDirectory();
            File file2 = file = subprojectWorkingDirectory == null ? new File(name) : new File(subprojectWorkingDirectory, name);
            if (!file.exists()) {
                return null;
            }
        }
        return file;
    }

    private ProjectFile readFile(File file) {
        ProjectFile project;
        try {
            project = new UniversalProjectReader().read(file);
            if (project != null) {
                project.getProjectConfig().setSubprojectWorkingDirectory(this.m_file.getProjectConfig().getSubprojectWorkingDirectory());
            }
        }
        catch (MPXJException ex) {
            project = null;
        }
        return project;
    }
}

