/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.time.LocalDate;
import org.mpxj.common.LocalDateHelper;

public final class LocalDateRange
implements Comparable<LocalDateRange> {
    private final LocalDate m_start;
    private final LocalDate m_end;

    public LocalDateRange(LocalDate startDate, LocalDate endDate) {
        this.m_start = startDate;
        this.m_end = endDate;
    }

    public LocalDate getStart() {
        return this.m_start;
    }

    public LocalDate getEnd() {
        return this.m_end;
    }

    @Override
    public int compareTo(LocalDate date) {
        return LocalDateHelper.compare(this.m_start, this.m_end, date);
    }

    @Override
    public int compareTo(LocalDateRange o) {
        int result = LocalDateHelper.compare(this.m_start, o.m_start);
        if (result == 0) {
            result = LocalDateHelper.compare(this.m_end, o.m_end);
        }
        return result;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof LocalDateRange) {
            LocalDateRange rhs = (LocalDateRange)o;
            result = this.compareTo(rhs) == 0;
        }
        return result;
    }

    public int hashCode() {
        long start = this.m_start == null ? 0L : this.m_start.toEpochDay();
        long end = this.m_end == null ? 0L : this.m_end.toEpochDay();
        return (int)start ^ (int)(start >> 32) ^ ((int)end ^ (int)(end >> 32));
    }

    public String toString() {
        return "[LocalDateRange start=" + this.m_start + " end=" + this.m_end + "]";
    }
}

