/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.mpxj.common.LocalDateTimeHelper;

public final class LocalDateTimeRange
implements Comparable<LocalDateTimeRange> {
    private final LocalDateTime m_start;
    private final LocalDateTime m_end;

    public LocalDateTimeRange(LocalDateTime startDate, LocalDateTime endDate) {
        this.m_start = startDate;
        this.m_end = endDate;
    }

    public LocalDateTime getStart() {
        return this.m_start;
    }

    public LocalDateTime getEnd() {
        return this.m_end;
    }

    @Override
    public int compareTo(LocalDateTime date) {
        return LocalDateTimeHelper.compare(this.m_start, this.m_end, date);
    }

    @Override
    public int compareTo(LocalDateTimeRange o) {
        int result = LocalDateTimeHelper.compare(this.m_start, o.m_start);
        if (result == 0) {
            result = LocalDateTimeHelper.compare(this.m_end, o.m_end);
        }
        return result;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof LocalDateTimeRange) {
            LocalDateTimeRange rhs = (LocalDateTimeRange)o;
            result = this.compareTo(rhs) == 0;
        }
        return result;
    }

    public int hashCode() {
        long start = this.m_start == null ? 0L : this.m_start.toEpochSecond(ZoneOffset.UTC);
        long end = this.m_end == null ? 0L : this.m_end.toEpochSecond(ZoneOffset.UTC);
        return (int)start ^ (int)(start >> 32) ^ ((int)end ^ (int)(end >> 32));
    }

    public String toString() {
        return "[LocalDateTimeRange start=" + this.m_start + " end=" + this.m_end + "]";
    }
}

