/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.time.LocalTime;
import org.mpxj.common.LocalTimeHelper;

public final class LocalTimeRange
implements Comparable<LocalTimeRange> {
    public static final LocalTimeRange EMPTY_RANGE = new LocalTimeRange(null, null);
    private final LocalTime m_start;
    private final LocalTime m_end;
    private final long m_durationAsMilliseconds;

    public LocalTimeRange(LocalTime start, LocalTime end) {
        this.m_start = start;
        this.m_end = end;
        this.m_durationAsMilliseconds = LocalTimeHelper.getMillisecondsInRange(start, end);
    }

    public LocalTime getStart() {
        return this.m_start;
    }

    public LocalTime getEnd() {
        return this.m_end;
    }

    public long getDurationAsMilliseconds() {
        return this.m_durationAsMilliseconds;
    }

    @Override
    public int compareTo(LocalTimeRange o) {
        int result = LocalTimeHelper.compare(this.m_start, o.m_start);
        if (result == 0) {
            result = Long.compare(this.m_durationAsMilliseconds, o.m_durationAsMilliseconds);
        }
        return result;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof LocalTimeRange) {
            LocalTimeRange rhs = (LocalTimeRange)o;
            result = this.compareTo(rhs) == 0;
        }
        return result;
    }

    public int hashCode() {
        long start = this.m_start == null ? 0L : this.m_start.toNanoOfDay();
        long end = this.m_end == null ? 0L : this.m_end.toNanoOfDay();
        return (int)start ^ (int)(start >> 32) ^ ((int)end ^ (int)(end >> 32));
    }

    public String toString() {
        return "[LocalTimeRange start=" + this.m_start + " end=" + this.m_end + "]";
    }
}

