/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.List;
import org.mpxj.DayType;
import org.mpxj.LocalTimeRange;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarHours;
import org.mpxj.ResourceAssignment;

class ManuallyScheduledTaskCalendar
extends ProjectCalendar {
    private final ProjectCalendar m_calendar;
    private final ResourceAssignment m_assignment;
    private final LocalDate m_assignmentStartDate;
    private final LocalDate m_assignmentEndDate;
    private static final List<DayOfWeek> WEEK_DAYS = Arrays.asList(DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY, DayOfWeek.MONDAY);

    public ManuallyScheduledTaskCalendar(ProjectCalendar calendar, ResourceAssignment assignment) {
        super(calendar.getParentFile(), true);
        LocalDateTime assignmentFinish;
        this.m_calendar = calendar;
        this.m_assignment = assignment;
        LocalDateTime assignmentStart = assignment.getStart();
        if (assignmentStart == null && (assignmentStart = assignment.getTask().getStart()) == null) {
            assignmentStart = assignment.getParentFile().getProjectProperties().getStartDate();
        }
        if ((assignmentFinish = assignment.getFinish()) == null && (assignmentFinish = assignment.getTask().getFinish()) == null) {
            assignmentFinish = assignment.getParentFile().getProjectProperties().getFinishDate();
        }
        this.m_assignmentStartDate = assignmentStart.toLocalDate();
        this.m_assignmentEndDate = assignmentFinish.toLocalDate();
    }

    @Override
    protected ProjectCalendarHours getRanges(LocalDate date) {
        ProjectCalendarHours newRanges;
        LocalTime lastRangeEnd;
        ProjectCalendarHours newRanges2;
        LocalTime firstRangeStart;
        DayOfWeek firstWorkingDay;
        ProjectCalendarHours effectiveRanges = this.m_calendar.getRanges(date);
        if (effectiveRanges.isEmpty() && (date.equals(this.m_assignmentStartDate) || date.equals(this.m_assignmentEndDate)) && (firstWorkingDay = (DayOfWeek)WEEK_DAYS.stream().filter(d -> this.m_calendar.getDayType((DayOfWeek)d) == DayType.WORKING).findFirst().orElse(null)) != null) {
            effectiveRanges = this.m_calendar.getHours(firstWorkingDay);
        }
        if (effectiveRanges.isEmpty()) {
            return effectiveRanges;
        }
        if (date.equals(this.m_assignmentStartDate)) {
            LocalTime assignmentStartTime = this.m_assignment.getStart().toLocalTime();
            if (assignmentStartTime.isBefore(firstRangeStart = effectiveRanges.get(0).getStart())) {
                newRanges2 = new ProjectCalendarHours();
                newRanges2.addAll(effectiveRanges);
                LocalTime firstRangeEnd = effectiveRanges.get(0).getEnd();
                newRanges2.set(0, new LocalTimeRange(assignmentStartTime, firstRangeEnd));
                effectiveRanges = newRanges2;
            } else {
                lastRangeEnd = effectiveRanges.get(effectiveRanges.size() - 1).getEnd();
                if (assignmentStartTime.isAfter(lastRangeEnd)) {
                    newRanges = new ProjectCalendarHours();
                    newRanges.add(new LocalTimeRange(assignmentStartTime, LocalTime.MIDNIGHT));
                    effectiveRanges = newRanges;
                }
            }
        }
        if (date.equals(this.m_assignmentEndDate)) {
            LocalTime assignmentEndTime = this.m_assignment.getFinish().toLocalTime();
            if (assignmentEndTime.isBefore(firstRangeStart = effectiveRanges.get(0).getStart())) {
                newRanges2 = new ProjectCalendarHours();
                newRanges2.add(new LocalTimeRange(LocalTime.MIDNIGHT, assignmentEndTime));
                effectiveRanges = newRanges2;
            } else {
                lastRangeEnd = effectiveRanges.get(effectiveRanges.size() - 1).getEnd();
                if (assignmentEndTime.isAfter(lastRangeEnd)) {
                    newRanges = new ProjectCalendarHours();
                    newRanges.addAll(effectiveRanges);
                    LocalTime lastRangeStart = effectiveRanges.get(effectiveRanges.size() - 1).getStart();
                    newRanges.set(effectiveRanges.size() - 1, new LocalTimeRange(lastRangeStart, assignmentEndTime));
                    effectiveRanges = newRanges;
                }
            }
        }
        return effectiveRanges;
    }
}

