/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Year;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.mpxj.CalendarType;
import org.mpxj.DayType;
import org.mpxj.Duration;
import org.mpxj.LocalDateTimeRange;
import org.mpxj.LocalTimeRange;
import org.mpxj.ProjectCalendarDays;
import org.mpxj.ProjectCalendarException;
import org.mpxj.ProjectCalendarHours;
import org.mpxj.ProjectCalendarWeek;
import org.mpxj.ProjectEntityWithMutableUniqueID;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectProperties;
import org.mpxj.RecurrenceType;
import org.mpxj.RecurringData;
import org.mpxj.Resource;
import org.mpxj.Task;
import org.mpxj.TemporaryCalendar;
import org.mpxj.TimeUnit;
import org.mpxj.TimeUnitDefaultsContainer;
import org.mpxj.common.LocalDateHelper;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.common.LocalTimeHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.common.ProjectCalendarHelper;

public class ProjectCalendar
extends ProjectCalendarDays
implements ProjectEntityWithMutableUniqueID,
TimeUnitDefaultsContainer {
    private ProjectCalendar m_parent;
    private final ProjectFile m_projectFile;
    private Integer m_uniqueID;
    private UUID m_guid;
    private final List<ProjectCalendarException> m_exceptions = new ArrayList<ProjectCalendarException>();
    private final List<ProjectCalendarException> m_expandedExceptions = new ArrayList<ProjectCalendarException>();
    private boolean m_exceptionsSorted;
    private boolean m_weeksSorted;
    private final Map<LocalDateTimeRange, Long> m_workingDateCache = new WeakHashMap<LocalDateTimeRange, Long>();
    private final Map<LocalDate, LocalTime> m_startTimeCache = new WeakHashMap<LocalDate, LocalTime>();
    private LocalDateTime m_getDateLastStartDate;
    private long m_getDateLastRemainingMilliseconds;
    private LocalDateTime m_getDateLastResult;
    private final ArrayList<ProjectCalendarWeek> m_workWeeks = new ArrayList();
    private Integer m_calendarMinutesPerDay;
    private Integer m_calendarMinutesPerWeek;
    private Integer m_calendarMinutesPerMonth;
    private Integer m_calendarMinutesPerYear;
    private CalendarType m_type = CalendarType.GLOBAL;
    private boolean m_personal;
    private final boolean m_temporaryCalendar;
    public static final String DEFAULT_BASE_CALENDAR_NAME = "Standard";
    private static final int MAX_NONWORKING_DAYS = 1000;
    private static final RecurrenceType[] ORDERED_RECURRENCE_TYPES = new RecurrenceType[]{RecurrenceType.WEEKLY, RecurrenceType.MONTHLY, RecurrenceType.YEARLY, RecurrenceType.DAILY};
    private static final ProjectCalendarHours EMPTY_DATE_RANGES = new ProjectCalendarHours(){};

    public ProjectCalendar(ProjectFile file) {
        this(file, false);
    }

    protected ProjectCalendar(ProjectFile file, boolean temporaryCalendar) {
        this.m_projectFile = file;
        this.m_temporaryCalendar = temporaryCalendar;
        if (!temporaryCalendar && file.getProjectConfig().getAutoCalendarUniqueID()) {
            this.setUniqueID(file.getUniqueIdObjectSequence(ProjectCalendar.class).getNext());
        }
    }

    @Override
    public Integer getMinutesPerDay() {
        Integer result = this.m_calendarMinutesPerDay;
        if (result == null) {
            result = this.m_parent == null ? this.getParentFile().getProjectProperties().getMinutesPerDay() : this.m_parent.getMinutesPerDay();
        }
        return result;
    }

    @Override
    public Integer getMinutesPerWeek() {
        Integer result = this.m_calendarMinutesPerWeek;
        if (result == null) {
            result = this.m_parent == null ? this.getParentFile().getProjectProperties().getMinutesPerWeek() : this.m_parent.getMinutesPerWeek();
        }
        return result;
    }

    @Override
    public Integer getMinutesPerMonth() {
        Integer result = this.m_calendarMinutesPerMonth;
        if (result == null) {
            result = this.m_parent == null ? this.getParentFile().getProjectProperties().getMinutesPerMonth() : this.m_parent.getMinutesPerMonth();
        }
        return result;
    }

    @Override
    public Integer getMinutesPerYear() {
        Integer result = this.m_calendarMinutesPerYear;
        if (result == null) {
            result = this.m_parent == null ? this.getParentFile().getProjectProperties().getMinutesPerYear() : this.m_parent.getMinutesPerYear();
        }
        return result;
    }

    @Override
    public Integer getDaysPerMonth() {
        return this.getParentFile().getProjectProperties().getDaysPerMonth();
    }

    public void setCalendarMinutesPerDay(Integer minutes) {
        this.m_calendarMinutesPerDay = minutes;
    }

    public Integer getCalendarMinutesPerDay() {
        return this.m_calendarMinutesPerDay;
    }

    public void setCalendarMinutesPerWeek(Integer minutes) {
        this.m_calendarMinutesPerWeek = minutes;
    }

    public Integer getCalendarMinutesPerWeek() {
        return this.m_calendarMinutesPerWeek;
    }

    public void setCalendarMinutesPerMonth(Integer minutes) {
        this.m_calendarMinutesPerMonth = minutes;
    }

    public Integer getCalendarMinutesPerMonth() {
        return this.m_calendarMinutesPerMonth;
    }

    public void setCalendarMinutesPerYear(Integer minutes) {
        this.m_calendarMinutesPerYear = minutes;
    }

    public Integer getCalendarMinutesPerYear() {
        return this.m_calendarMinutesPerYear;
    }

    public ProjectCalendarWeek addWorkWeek() {
        ProjectCalendarWeek week = new ProjectCalendarWeek();
        this.m_workWeeks.add(week);
        this.m_weeksSorted = false;
        this.clearWorkingDateCache();
        return week;
    }

    public void removeWorkWeek(ProjectCalendarWeek week) {
        this.m_workWeeks.remove(week);
        this.clearWorkingDateCache();
    }

    public void clearWorkWeeks() {
        this.m_workWeeks.clear();
        this.m_weeksSorted = false;
        this.clearWorkingDateCache();
    }

    public List<ProjectCalendarWeek> getWorkWeeks() {
        return Collections.unmodifiableList(this.m_workWeeks);
    }

    public ProjectCalendarException addCalendarException(LocalDate date) {
        return this.addCalendarException(date, date, null);
    }

    public ProjectCalendarException addCalendarException(LocalDate fromDate, LocalDate toDate) {
        return this.addCalendarException(fromDate, toDate, null);
    }

    public ProjectCalendarException addCalendarException(RecurringData recurringData) {
        return this.addCalendarException(null, null, recurringData);
    }

    private ProjectCalendarException addCalendarException(LocalDate fromDate, LocalDate toDate, RecurringData recurringData) {
        ProjectCalendarException bce = new ProjectCalendarException(fromDate, toDate, recurringData);
        this.m_exceptions.add(bce);
        this.m_expandedExceptions.clear();
        this.m_exceptionsSorted = false;
        this.clearWorkingDateCache();
        return bce;
    }

    public void removeCalendarException(ProjectCalendarException exception) {
        this.m_exceptions.remove(exception);
        this.m_expandedExceptions.clear();
        this.clearWorkingDateCache();
    }

    public void clearCalendarExceptions() {
        this.m_exceptions.clear();
        this.m_expandedExceptions.clear();
        this.m_exceptionsSorted = false;
        this.clearWorkingDateCache();
    }

    public List<ProjectCalendarException> getCalendarExceptions() {
        this.sortExceptions();
        return Collections.unmodifiableList(this.m_exceptions);
    }

    public List<ProjectCalendarException> getExpandedCalendarExceptions() {
        this.populateExpandedExceptions();
        return Collections.unmodifiableList(this.m_expandedExceptions);
    }

    public List<ProjectCalendarException> getExpandedCalendarExceptionsWithWorkWeeks() {
        if (this.m_workWeeks.isEmpty()) {
            return this.getExpandedCalendarExceptions();
        }
        TemporaryCalendar temporaryCalendar = new TemporaryCalendar(this.getParentFile());
        ProjectCalendarHelper.mergeExceptions((ProjectCalendar)temporaryCalendar, this.getCalendarExceptions());
        LocalDate earliestStartDate = LocalDateHelper.getLocalDate(this.m_projectFile.getEarliestStartDate());
        LocalDate latestFinishDate = LocalDateHelper.getLocalDate(this.m_projectFile.getLatestFinishDate());
        for (ProjectCalendarWeek week : this.getWorkWeeks()) {
            ProjectCalendarHelper.mergeExceptions((ProjectCalendar)temporaryCalendar, week.convertToRecurringExceptions(earliestStartDate, latestFinishDate));
        }
        return temporaryCalendar.getExpandedCalendarExceptions();
    }

    @Override
    public ProjectCalendarHours addCalendarHours(DayOfWeek day) {
        this.clearWorkingDateCache();
        return super.addCalendarHours(day);
    }

    @Override
    public void removeCalendarHours(DayOfWeek day) {
        this.clearWorkingDateCache();
        super.removeCalendarHours(day);
    }

    public void setParent(ProjectCalendar calendar) {
        if (calendar != this) {
            this.m_parent = calendar;
            Arrays.stream(DayOfWeek.values()).filter(d -> this.getCalendarDayType((DayOfWeek)d) == null).forEach(d -> this.setCalendarDayType((DayOfWeek)d, DayType.DEFAULT));
            this.clearWorkingDateCache();
        }
    }

    public ProjectCalendar getParent() {
        return this.m_parent;
    }

    public Integer getParentUniqueID() {
        return this.m_parent == null ? null : this.m_parent.getUniqueID();
    }

    public Duration getDuration(LocalDateTime startDate, LocalDateTime endDate) {
        if (startDate == null || endDate == null) {
            return null;
        }
        int days = this.getDaysInRange(startDate, endDate);
        int duration = 0;
        while (days > 0) {
            if (this.isWorkingDate(LocalDateHelper.getLocalDate(startDate))) {
                ++duration;
            }
            --days;
            startDate = startDate.plusDays(1L);
        }
        return Duration.getInstance(duration, TimeUnit.DAYS);
    }

    public LocalTime getStartTime(LocalDate date) {
        if (date == null) {
            return null;
        }
        LocalTime result = this.m_startTimeCache.get(date);
        if (result != null) {
            return result;
        }
        ProjectCalendarHours ranges = this.getRanges(date);
        if (ranges == null || ranges.isEmpty()) {
            return null;
        }
        result = ranges.get(0).getStart();
        this.m_startTimeCache.put(date, result);
        return result;
    }

    public LocalTime getFinishTime(LocalDate date) {
        if (date == null) {
            return null;
        }
        ProjectCalendarHours ranges = this.getRanges(date);
        if (ranges == null || ranges.isEmpty()) {
            return null;
        }
        return ranges.get(ranges.size() - 1).getEnd();
    }

    public LocalDateTime getDate(LocalDateTime date, Duration duration) {
        if (duration.getUnits().isElapsed()) {
            ProjectProperties properties = this.getParentFile().getProjectProperties();
            double elapsedMinutes = duration.convertUnits(TimeUnit.ELAPSED_MINUTES, properties).getDuration();
            return date.plusMinutes((long)elapsedMinutes);
        }
        return duration.getDuration() < 0.0 ? this.getDateFromNegativeDuration(date, duration) : this.getDateFromPositiveDuration(date, duration);
    }

    private LocalDateTime getDateFromPositiveDuration(LocalDateTime startDate, Duration duration) {
        ProjectProperties properties = this.getParentFile().getProjectProperties();
        long remainingMilliseconds = Math.round(NumberHelper.round(duration.convertUnits(TimeUnit.MINUTES, properties).getDuration(), 2.0) * 60000.0);
        if (remainingMilliseconds == 0L) {
            return startDate;
        }
        LocalDateTime getDateLastStartDate = this.m_getDateLastStartDate;
        long getDateLastRemainingMilliseconds = this.m_getDateLastRemainingMilliseconds;
        this.m_getDateLastStartDate = startDate;
        this.m_getDateLastRemainingMilliseconds = remainingMilliseconds;
        if (this.m_getDateLastResult != null && LocalDateTimeHelper.compare(startDate, getDateLastStartDate) == 0 && remainingMilliseconds >= getDateLastRemainingMilliseconds) {
            startDate = this.m_getDateLastResult;
            if ((remainingMilliseconds -= getDateLastRemainingMilliseconds) == 0L) {
                return startDate;
            }
        }
        LocalDateTime currentDayStart = startDate;
        LocalDateTime currentDayEnd = LocalDateTimeHelper.getDayStartDate(currentDayStart).plusDays(1L);
        block0: while (remainingMilliseconds > 0L) {
            long currentDateWorkingMilliseconds = Math.round(this.getWork(currentDayStart, currentDayEnd, TimeUnit.MINUTES).getDuration() * 60000.0);
            if (remainingMilliseconds == currentDateWorkingMilliseconds) {
                currentDayEnd = LocalTimeHelper.setEndTime(currentDayStart, this.getFinishTime(currentDayStart.toLocalDate()));
                break;
            }
            if (remainingMilliseconds > currentDateWorkingMilliseconds) {
                remainingMilliseconds -= currentDateWorkingMilliseconds;
                LocalDateTime currentDay = currentDayStart;
                int nonWorkingDayCount = 0;
                do {
                    currentDay = currentDay.plusDays(1L);
                    if (++nonWorkingDayCount <= 1000) continue;
                    currentDay = currentDayStart.plusDays(1L);
                    remainingMilliseconds = 0L;
                    break;
                } while (!this.isWorkingDate(LocalDateHelper.getLocalDate(currentDay)));
                currentDayStart = LocalTimeHelper.setTime(currentDay, this.getStartTime(LocalDateHelper.getLocalDate(currentDay)));
                currentDayEnd = LocalTimeHelper.setEndTime(currentDayStart, this.getFinishTime(LocalDateHelper.getLocalDate(currentDayStart)));
                continue;
            }
            ProjectCalendarHours ranges = this.getRanges(LocalDateHelper.getLocalDate(currentDayStart));
            LocalTime currentDayStartTime = LocalTimeHelper.getLocalTime(currentDayStart);
            boolean firstRange = true;
            for (LocalTimeRange range : ranges) {
                LocalTime rangeStart = range.getStart();
                LocalTime rangeEnd = range.getEnd();
                if (rangeStart == null || rangeEnd == null || firstRange && rangeEnd != LocalTime.MIDNIGHT && rangeEnd.isBefore(currentDayStartTime)) continue;
                if (firstRange && rangeStart.isBefore(currentDayStartTime)) {
                    rangeStart = currentDayStartTime;
                }
                firstRange = false;
                long rangeMilliseconds = LocalTimeHelper.getMillisecondsInRange(rangeStart, rangeEnd);
                if (remainingMilliseconds > rangeMilliseconds) {
                    remainingMilliseconds -= rangeMilliseconds;
                    continue;
                }
                if (remainingMilliseconds != rangeMilliseconds) {
                    rangeEnd = rangeStart.plus(remainingMilliseconds, ChronoUnit.MILLIS);
                }
                currentDayEnd = LocalTimeHelper.setTime(currentDayStart, rangeEnd);
                remainingMilliseconds = 0L;
                continue block0;
            }
        }
        if (currentDayEnd.getNano() != 0) {
            currentDayEnd = LocalDateTime.of(currentDayEnd.toLocalDate(), LocalTime.of(currentDayEnd.getHour(), currentDayEnd.getMinute(), currentDayEnd.getSecond()));
        }
        this.m_getDateLastResult = currentDayEnd;
        return currentDayEnd;
    }

    private LocalDateTime getDateFromNegativeDuration(LocalDateTime endDate, Duration duration) {
        ProjectProperties properties = this.getParentFile().getProjectProperties();
        long remainingMilliseconds = -Math.round(NumberHelper.round(duration.convertUnits(TimeUnit.MINUTES, properties).getDuration(), 2.0) * 60000.0);
        if (remainingMilliseconds == 0L) {
            return endDate;
        }
        LocalDateTime currentDayEnd = endDate;
        LocalDateTime currentDayStart = currentDayEnd.toLocalTime() == LocalTime.MIDNIGHT ? LocalDateTimeHelper.getDayStartDate(currentDayEnd.minusDays(1L)) : LocalDateTimeHelper.getDayStartDate(currentDayEnd);
        block0: while (remainingMilliseconds > 0L) {
            long currentDayWorkingMilliseconds = Math.round(this.getWork(currentDayStart, currentDayEnd, TimeUnit.MINUTES).getDuration() * 60000.0);
            if (remainingMilliseconds == currentDayWorkingMilliseconds) {
                currentDayStart = LocalTimeHelper.setTime(currentDayStart, this.getStartTime(currentDayStart.toLocalDate()));
                break;
            }
            if (remainingMilliseconds > currentDayWorkingMilliseconds) {
                remainingMilliseconds -= currentDayWorkingMilliseconds;
                int nonWorkingDayCount = 0;
                LocalDateTime currentDay = currentDayStart;
                do {
                    currentDay = currentDay.minusDays(1L);
                    if (++nonWorkingDayCount <= 1000) continue;
                    currentDay = currentDayStart.minusDays(1L);
                    remainingMilliseconds = 0L;
                    break;
                } while (!this.isWorkingDate(LocalDateHelper.getLocalDate(currentDay)));
                currentDayStart = currentDay;
                currentDayEnd = LocalTimeHelper.setEndTime(currentDayStart, this.getFinishTime(LocalDateHelper.getLocalDate(currentDayStart)));
                continue;
            }
            ArrayList<LocalTimeRange> ranges = new ArrayList<LocalTimeRange>(this.getRanges(LocalDateHelper.getLocalDate(currentDayStart)));
            Collections.reverse(ranges);
            LocalTime currentDayEndTime = LocalTimeHelper.getLocalTime(currentDayEnd);
            boolean lastRange = true;
            for (LocalTimeRange range : ranges) {
                LocalTime rangeStart = range.getStart();
                LocalTime rangeEnd = range.getEnd();
                if (rangeStart == null || rangeEnd == null || currentDayEndTime != LocalTime.MIDNIGHT && currentDayEndTime.isBefore(rangeStart)) continue;
                if (lastRange && (rangeEnd == LocalTime.MIDNIGHT || rangeEnd.isAfter(currentDayEndTime))) {
                    rangeEnd = currentDayEndTime;
                }
                lastRange = false;
                long rangeMilliseconds = LocalTimeHelper.getMillisecondsInRange(rangeStart, rangeEnd);
                if (remainingMilliseconds > rangeMilliseconds) {
                    remainingMilliseconds -= rangeMilliseconds;
                    continue;
                }
                if (remainingMilliseconds != rangeMilliseconds) {
                    rangeStart = rangeEnd.minus(remainingMilliseconds, ChronoUnit.MILLIS);
                }
                currentDayStart = LocalTimeHelper.setTime(currentDayStart, rangeStart);
                remainingMilliseconds = 0L;
                continue block0;
            }
        }
        if (currentDayStart.getNano() != 0) {
            currentDayStart = LocalDateTime.of(currentDayStart.toLocalDate(), LocalTime.of(currentDayStart.getHour(), currentDayStart.getMinute(), currentDayStart.getSecond()));
        }
        return currentDayStart;
    }

    public LocalDateTime getNextWorkStart(LocalDateTime date) {
        LocalDateTime originalDate = date;
        ProjectCalendarHours ranges = this.getRanges(LocalDateHelper.getLocalDate(originalDate));
        if (ranges != null) {
            LocalTime calTime = date.toLocalTime();
            LocalTime startTime = null;
            for (LocalTimeRange range : ranges) {
                LocalTime rangeStart = range.getStart();
                LocalTime rangeEnd = range.getEnd();
                if (rangeEnd != LocalTime.MIDNIGHT && !calTime.isBefore(rangeEnd)) continue;
                if (calTime.isAfter(rangeStart)) {
                    startTime = calTime;
                    break;
                }
                startTime = rangeStart;
                break;
            }
            if (startTime == null) {
                int nonWorkingDayCount = 0;
                do {
                    date = date.plusDays(1L);
                    if (++nonWorkingDayCount <= 1000) continue;
                    date = originalDate;
                    break;
                } while (!this.isWorkingDate(LocalDateHelper.getLocalDate(date)));
                startTime = this.getStartTime(LocalDateHelper.getLocalDate(date));
            }
            date = LocalTimeHelper.setTime(date, startTime);
        }
        return date;
    }

    public LocalDateTime getPreviousWorkFinish(LocalDateTime date) {
        LocalDateTime originalDate = date;
        ProjectCalendarHours ranges = this.getRanges(LocalDateHelper.getLocalDate(originalDate));
        if (ranges != null) {
            LocalTime calTime = LocalTimeHelper.getLocalTime(date);
            LocalTime finishTime = null;
            int index = ranges.size();
            while (index-- > 0) {
                LocalTimeRange range = ranges.get(index);
                if ((range.getEnd() != LocalTime.MIDNIGHT || calTime != LocalTime.MIDNIGHT) && calTime.isBefore(range.getEnd())) continue;
                finishTime = range.getEnd();
                break;
            }
            if (finishTime == null) {
                int nonWorkingDayCount = 0;
                do {
                    date = date.minusDays(1L);
                    if (++nonWorkingDayCount <= 1000) continue;
                    date = originalDate;
                    break;
                } while (!this.isWorkingDate(LocalDateHelper.getLocalDate(date)));
                finishTime = this.getFinishTime(LocalDateHelper.getLocalDate(date));
            }
            date = LocalTimeHelper.setEndTime(date, finishTime);
        }
        return date;
    }

    public DayType getDayType(DayOfWeek day) {
        DayType result = this.getCalendarDayType(day);
        if (result == DayType.DEFAULT) {
            result = this.m_parent == null ? (day == DayOfWeek.SATURDAY || day == DayOfWeek.SUNDAY ? DayType.NON_WORKING : DayType.WORKING) : this.m_parent.getDayType(day);
        }
        return result;
    }

    public boolean isWorkingDay(DayOfWeek day) {
        return this.getDayType(day) == DayType.WORKING;
    }

    public boolean isWorkingDate(LocalDate date) {
        return !this.getRanges(date).isEmpty();
    }

    private int getDaysInRange(LocalDateTime startDate, LocalDateTime endDate) {
        int result;
        int endDateYear = endDate.getYear();
        int endDateDayOfYear = endDate.getDayOfYear();
        LocalDateTime cal = startDate;
        if (endDateYear == cal.getYear()) {
            result = endDateDayOfYear - cal.getDayOfYear() + 1;
        } else {
            result = 0;
            do {
                result += Year.of(cal.getYear()).length() - cal.getDayOfYear() + 1;
            } while ((cal = LocalDateTime.of(cal.getYear() + 1, 1, 1, 0, 0)).getYear() < endDateYear);
            result += endDateDayOfYear;
        }
        return result;
    }

    public ProjectCalendarHours getHours(DayOfWeek day) {
        ProjectCalendarHours result = this.getCalendarHours(day);
        if (result == null && this.m_parent != null) {
            result = this.m_parent.getHours(day);
        }
        return result;
    }

    public ProjectCalendarHours getHours(LocalDate date) {
        return this.getRanges(date);
    }

    public ProjectCalendarHours getHours(LocalDateTime date) {
        return this.getHours(LocalDateHelper.getLocalDate(date));
    }

    @Override
    public void setUniqueID(Integer uniqueID) {
        if (!this.m_temporaryCalendar) {
            this.getParentFile().getCalendars().updateUniqueID(this, this.m_uniqueID, uniqueID);
        }
        this.m_uniqueID = uniqueID;
    }

    @Override
    public Integer getUniqueID() {
        return this.m_uniqueID;
    }

    public UUID getGUID() {
        return this.m_guid;
    }

    public void setGUID(UUID value) {
        this.m_guid = value;
    }

    public List<Task> getTasks() {
        return Collections.unmodifiableList(this.getParentFile().getTasks().stream().filter(t -> this.m_uniqueID.equals(t.getCalendarUniqueID())).collect(Collectors.toList()));
    }

    public List<Resource> getResources() {
        return Collections.unmodifiableList(this.getParentFile().getResources().stream().filter(r -> this.m_uniqueID.equals(r.getCalendarUniqueID())).collect(Collectors.toList()));
    }

    public int getResourceCount() {
        return (int)this.getParentFile().getResources().stream().filter(r -> this.m_uniqueID.equals(r.getCalendarUniqueID())).count();
    }

    public void remove() {
        this.getParentFile().removeCalendar(this);
    }

    public ProjectCalendarException getException(LocalDate date) {
        if (date == null) {
            return null;
        }
        ProjectCalendarException exception = null;
        this.populateExpandedExceptions();
        if (!this.m_expandedExceptions.isEmpty()) {
            int low = 0;
            int high = this.m_expandedExceptions.size() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                ProjectCalendarException midVal = this.m_expandedExceptions.get(mid);
                int cmp = LocalDateHelper.compare(midVal.getFromDate(), midVal.getToDate(), date);
                if (cmp > 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp < 0) {
                    high = mid - 1;
                    continue;
                }
                exception = midVal;
                break;
            }
        }
        if (exception == null && this.m_parent != null) {
            exception = this.m_parent.getException(date);
        }
        return exception;
    }

    public ProjectCalendarWeek getWorkWeek(LocalDate date) {
        if (date == null) {
            return null;
        }
        ProjectCalendarWeek week = null;
        if (!this.m_workWeeks.isEmpty()) {
            this.sortWorkWeeks();
            int low = 0;
            int high = this.m_workWeeks.size() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                ProjectCalendarWeek midVal = this.m_workWeeks.get(mid);
                int cmp = LocalDateHelper.compare(midVal.getDateRange().getStart(), midVal.getDateRange().getEnd(), date);
                if (cmp > 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp < 0) {
                    high = mid - 1;
                    continue;
                }
                week = midVal;
                break;
            }
        }
        if (week == null && this.m_parent != null) {
            week = this.m_parent.getWorkWeek(date);
        }
        return week;
    }

    public Duration getWork(DayOfWeek day, TimeUnit format) {
        return this.convertFormat(this.getTotalTime(this.getRanges(day)), format);
    }

    public Duration getWork(LocalDate date, TimeUnit format) {
        return this.convertFormat(this.getTotalTime(this.getRanges(date)), format);
    }

    public Duration getWork(LocalDateTime startDate, LocalDateTime endDate, TimeUnit format) {
        if (startDate == null || endDate == null) {
            return null;
        }
        LocalDateTimeRange range = new LocalDateTimeRange(startDate, endDate);
        Long cachedResult = this.m_workingDateCache.get(range);
        long totalTime = 0L;
        if (cachedResult == null) {
            boolean invert = false;
            if (startDate.isAfter(endDate)) {
                invert = true;
                LocalDateTime temp = startDate;
                startDate = endDate;
                endDate = temp;
            }
            if (this.isSameDay(startDate, endDate)) {
                ProjectCalendarHours ranges = this.getRanges(LocalDateHelper.getLocalDate(startDate));
                if (!ranges.isEmpty()) {
                    totalTime = this.getTotalTime(ranges, LocalTimeHelper.getLocalTime(startDate), LocalTimeHelper.getLocalTime(endDate));
                }
            } else {
                ProjectCalendarHours ranges;
                LocalDateTime canonicalEndDate = LocalDateTimeHelper.getDayStartDate(endDate);
                LocalDateTime currentDate = startDate;
                LocalDateTime cal = startDate;
                while (!this.isWorkingDate(LocalDateHelper.getLocalDate(currentDate)) && currentDate.isBefore(canonicalEndDate)) {
                    currentDate = cal = cal.plusDays(1L);
                }
                if (currentDate.isBefore(canonicalEndDate)) {
                    LocalTime targetTime = currentDate.equals(startDate) ? LocalTimeHelper.getLocalTime(currentDate) : LocalTime.of(0, 0);
                    totalTime += this.getTotalTime(this.getRanges(LocalDateHelper.getLocalDate(currentDate)), targetTime);
                    while ((currentDate = (cal = cal.plusDays(1L))).isBefore(canonicalEndDate)) {
                        ProjectCalendarHours ranges2 = this.getRanges(LocalDateHelper.getLocalDate(currentDate));
                        if (ranges2.isEmpty()) continue;
                        totalTime += this.getTotalTime(ranges2);
                    }
                }
                if (!(ranges = this.getRanges(LocalDateHelper.getLocalDate(endDate))).isEmpty()) {
                    totalTime += this.getTotalTime(ranges, LocalTime.of(0, 0), LocalTimeHelper.getLocalTime(endDate));
                }
            }
            if (invert) {
                totalTime = -totalTime;
            }
            this.m_workingDateCache.put(range, totalTime);
        } else {
            totalTime = cachedResult;
        }
        return this.convertFormat(totalTime, format);
    }

    private boolean isSameDay(LocalDateTime d1, LocalDateTime d2) {
        if (d1 == null || d2 == null) {
            return false;
        }
        return d1.getYear() == d2.getYear() && d1.getDayOfYear() == d2.getDayOfYear();
    }

    private Duration convertFormat(long totalTime, TimeUnit format) {
        double duration = totalTime;
        switch (format) {
            case MINUTES: 
            case ELAPSED_MINUTES: {
                duration /= 60000.0;
                break;
            }
            case HOURS: 
            case ELAPSED_HOURS: {
                duration /= 3600000.0;
                break;
            }
            case DAYS: {
                double minutesPerDay = NumberHelper.getDouble(this.getMinutesPerDay());
                if (minutesPerDay != 0.0) {
                    duration /= minutesPerDay * 60.0 * 1000.0;
                    break;
                }
                duration = 0.0;
                break;
            }
            case WEEKS: {
                double minutesPerWeek = NumberHelper.getDouble(this.getMinutesPerWeek());
                if (minutesPerWeek != 0.0) {
                    duration /= minutesPerWeek * 60.0 * 1000.0;
                    break;
                }
                duration = 0.0;
                break;
            }
            case MONTHS: {
                double daysPerMonth = this.getParentFile().getProjectProperties().getDaysPerMonth().doubleValue();
                double minutesPerDay = NumberHelper.getDouble(this.getMinutesPerDay());
                if (daysPerMonth != 0.0 && minutesPerDay != 0.0) {
                    duration /= daysPerMonth * minutesPerDay * 60.0 * 1000.0;
                    break;
                }
                duration = 0.0;
                break;
            }
            case ELAPSED_DAYS: {
                duration /= 8.64E7;
                break;
            }
            case ELAPSED_WEEKS: {
                duration /= 6.048E8;
                break;
            }
            case ELAPSED_MONTHS: {
                duration /= 2.592E9;
                break;
            }
            default: {
                throw new IllegalArgumentException("TimeUnit " + format + " not supported");
            }
        }
        return Duration.getInstance(duration, format);
    }

    private long getTotalTime(ProjectCalendarHours hours, LocalTime targetTime) {
        long total = 0L;
        for (LocalTimeRange range : hours) {
            if (range.getEnd() != LocalTime.MIDNIGHT && targetTime.isAfter(range.getEnd())) continue;
            total += this.getTime(range.getStart(), range.getEnd(), targetTime, range.getEnd());
        }
        return total;
    }

    private long getTotalTime(ProjectCalendarHours hours) {
        return hours.stream().mapToLong(LocalTimeRange::getDurationAsMilliseconds).sum();
    }

    private long getTotalTime(ProjectCalendarHours hours, LocalTime start, LocalTime end) {
        if (start.equals(end)) {
            return 0L;
        }
        long total = 0L;
        for (LocalTimeRange range : hours) {
            total += this.getTime(start, end, range.getStart(), range.getEnd());
        }
        return total;
    }

    private long getTime(LocalTime start1, LocalTime end1, LocalTime start2, LocalTime end2) {
        LocalTime minEnd;
        LocalTime maxStart;
        if (start1 == null || end1 == null || start2 == null || end2 == null) {
            return 0L;
        }
        LocalTime localTime = maxStart = start1.isAfter(start2) ? start1 : start2;
        if (end1 == LocalTime.MIDNIGHT && end2 != LocalTime.MIDNIGHT) {
            minEnd = end2;
        } else if (end1 != LocalTime.MIDNIGHT && end2 == LocalTime.MIDNIGHT) {
            minEnd = end1;
        } else {
            LocalTime localTime2 = minEnd = end1.isBefore(end2) ? end1 : end2;
        }
        if (minEnd == LocalTime.MIDNIGHT || maxStart.isBefore(minEnd)) {
            return LocalTimeHelper.getMillisecondsInRange(maxStart, minEnd);
        }
        return 0L;
    }

    public List<ProjectCalendar> getDerivedCalendars() {
        return Collections.unmodifiableList(this.m_projectFile.getCalendars().stream().filter(c -> c.m_parent != null && this.m_uniqueID != null && this.m_uniqueID.equals(c.m_parent.m_uniqueID)).collect(Collectors.toList()));
    }

    public String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(os);
        pw.println("[ProjectCalendar");
        pw.println("   ID=" + this.m_uniqueID);
        pw.println("   name=" + this.getName());
        pw.println("   baseCalendarName=" + (this.m_parent == null ? "" : this.m_parent.getName()));
        for (DayOfWeek day : DayOfWeek.values()) {
            pw.println("   [Day " + day);
            pw.println("      type=" + this.getCalendarDayType(day));
            pw.println("      hours=" + this.getHours(day));
            pw.println("   ]");
        }
        if (!this.m_exceptions.isEmpty()) {
            pw.println("   [Exceptions=");
            for (ProjectCalendarException ex : this.m_exceptions) {
                pw.println("      " + ex.toString());
            }
            pw.println("   ]");
        }
        if (!this.m_workWeeks.isEmpty()) {
            pw.println("   [WorkWeeks=");
            for (ProjectCalendarWeek week : this.m_workWeeks) {
                pw.println("      " + week.toString());
            }
            pw.println("   ]");
        }
        pw.println("]");
        pw.flush();
        return os.toString();
    }

    private void clearWorkingDateCache() {
        this.m_workingDateCache.clear();
        this.m_startTimeCache.clear();
        this.m_getDateLastResult = null;
        this.getDerivedCalendars().forEach(ProjectCalendar::clearWorkingDateCache);
    }

    protected ProjectCalendarHours getRanges(LocalDate date) {
        ProjectCalendarHours ranges = this.getException(date);
        if (ranges != null) {
            return ranges;
        }
        ProjectCalendarDays week = this.getWorkWeek(date);
        if (week == null) {
            week = this;
        }
        DayOfWeek day = date.getDayOfWeek();
        switch (week.getCalendarDayType(date.getDayOfWeek())) {
            case NON_WORKING: {
                ranges = EMPTY_DATE_RANGES;
                break;
            }
            case WORKING: {
                ranges = week.getCalendarHours(day);
                break;
            }
            case DEFAULT: {
                ranges = this.m_parent == null ? EMPTY_DATE_RANGES : this.m_parent.getHours(day);
            }
        }
        return ranges;
    }

    protected ProjectCalendarHours getRanges(DayOfWeek day) {
        switch (this.getCalendarDayType(day)) {
            case NON_WORKING: {
                return EMPTY_DATE_RANGES;
            }
            case WORKING: {
                return this.getCalendarHours(day);
            }
            case DEFAULT: {
                return this.m_parent == null ? EMPTY_DATE_RANGES : this.m_parent.getHours(day);
            }
        }
        return EMPTY_DATE_RANGES;
    }

    private void sortExceptions() {
        if (!this.m_exceptionsSorted) {
            Collections.sort(this.m_exceptions);
            this.m_exceptionsSorted = true;
        }
    }

    private void populateExpandedExceptions() {
        if (this.m_exceptions.isEmpty() || !this.m_expandedExceptions.isEmpty()) {
            return;
        }
        ArrayList<ProjectCalendarException> nonRecurring = new ArrayList<ProjectCalendarException>();
        HashMap<RecurrenceType, List> recurring = new HashMap<RecurrenceType, List>();
        for (ProjectCalendarException exception : this.m_exceptions) {
            List<ProjectCalendarException> expanded = exception.getExpandedExceptions();
            if (expanded.size() == 1) {
                nonRecurring.add(expanded.get(0));
                continue;
            }
            recurring.computeIfAbsent(exception.getRecurring().getRecurrenceType(), k -> new ArrayList()).add(exception);
        }
        TreeMap<LocalDate, ProjectCalendarException> map = new TreeMap<LocalDate, ProjectCalendarException>();
        for (RecurrenceType type : ORDERED_RECURRENCE_TYPES) {
            recurring.computeIfAbsent(type, k -> Collections.emptyList()).forEach(e -> e.getExpandedExceptions().forEach(x -> map.put(x.getFromDate(), (ProjectCalendarException)x)));
        }
        for (ProjectCalendarException exception : nonRecurring) {
            map.put(exception.getFromDate(), exception);
        }
        this.m_expandedExceptions.addAll(map.values());
    }

    private void sortWorkWeeks() {
        if (!this.m_weeksSorted) {
            Collections.sort(this.m_workWeeks);
            this.m_weeksSorted = true;
        }
    }

    public final ProjectFile getParentFile() {
        return this.m_projectFile;
    }

    public boolean isDerived() {
        return this.m_parent != null;
    }

    public CalendarType getType() {
        return this.m_type;
    }

    public void setType(CalendarType type) {
        if (type != null) {
            this.m_type = type;
        }
    }

    public boolean getPersonal() {
        return this.m_personal;
    }

    public void setPersonal(boolean personal) {
        this.m_personal = personal;
    }
}

