/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.time.DayOfWeek;
import java.time.LocalTime;
import org.mpxj.DayType;
import org.mpxj.LocalTimeRange;
import org.mpxj.ProjectCalendarHours;
import org.mpxj.common.DayOfWeekHelper;

public abstract class ProjectCalendarDays {
    private String m_name;
    private final ProjectCalendarHours[] m_hours = new ProjectCalendarHours[7];
    private final DayType[] m_days = new DayType[7];
    public static final LocalTimeRange DEFAULT_WORKING_MORNING = new LocalTimeRange(LocalTime.of(8, 0), LocalTime.of(12, 0));
    public static final LocalTimeRange DEFAULT_WORKING_AFTERNOON = new LocalTimeRange(LocalTime.of(13, 0), LocalTime.of(17, 0));

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public ProjectCalendarHours[] getCalendarHours() {
        return this.m_hours;
    }

    public ProjectCalendarHours getCalendarHours(DayOfWeek day) {
        return this.m_hours[DayOfWeekHelper.getValue(day) - 1];
    }

    public void addDefaultCalendarHours() {
        for (DayOfWeek day : DayOfWeek.values()) {
            this.addDefaultCalendarHours(day);
        }
    }

    public void addDefaultCalendarDays() {
        this.setWorkingDay(DayOfWeek.SUNDAY, false);
        this.setWorkingDay(DayOfWeek.MONDAY, true);
        this.setWorkingDay(DayOfWeek.TUESDAY, true);
        this.setWorkingDay(DayOfWeek.WEDNESDAY, true);
        this.setWorkingDay(DayOfWeek.THURSDAY, true);
        this.setWorkingDay(DayOfWeek.FRIDAY, true);
        this.setWorkingDay(DayOfWeek.SATURDAY, false);
    }

    public void addDefaultCalendarHours(DayOfWeek day) {
        ProjectCalendarHours hours = this.addCalendarHours(day);
        if (day != DayOfWeek.SATURDAY && day != DayOfWeek.SUNDAY) {
            hours.add(DEFAULT_WORKING_MORNING);
            hours.add(DEFAULT_WORKING_AFTERNOON);
        }
    }

    public ProjectCalendarHours addCalendarHours(DayOfWeek day) {
        ProjectCalendarHours bch;
        this.m_hours[DayOfWeekHelper.getValue((DayOfWeek)day) - 1] = bch = new ProjectCalendarHours();
        return bch;
    }

    public void removeCalendarHours(DayOfWeek day) {
        this.m_hours[DayOfWeekHelper.getValue((DayOfWeek)day) - 1] = null;
    }

    public DayType[] getCalendarDayTypes() {
        return this.m_days;
    }

    public DayType getCalendarDayType(DayOfWeek day) {
        return this.m_days[DayOfWeekHelper.getValue(day) - 1];
    }

    public void setWorkingDay(DayOfWeek day, boolean working) {
        this.setCalendarDayType(day, working ? DayType.WORKING : DayType.NON_WORKING);
    }

    public void setCalendarDayType(DayOfWeek day, DayType type) {
        this.m_days[DayOfWeekHelper.getValue((DayOfWeek)day) - 1] = type;
        switch (type) {
            case DEFAULT: {
                this.removeCalendarHours(day);
                break;
            }
            case NON_WORKING: {
                ProjectCalendarHours hours = this.getCalendarHours(day);
                if (hours == null) {
                    this.addCalendarHours(day);
                    break;
                }
                hours.clear();
                break;
            }
        }
    }
}

