/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.mpxj.ProjectEntityContainer;
import org.mpxj.ProjectEntityWithID;
import org.mpxj.ProjectFile;
import org.mpxj.common.NumberHelper;
import org.mpxj.common.ObjectSequence;

public abstract class ProjectEntityWithIDContainer<T extends ProjectEntityWithID & Comparable<T>>
extends ProjectEntityContainer<T> {
    private final ObjectSequence m_idSequence = new ObjectSequence(1);
    protected final Map<Integer, T> m_idMap = new HashMap<Integer, T>();

    public ProjectEntityWithIDContainer(ProjectFile projectFile) {
        super(projectFile);
    }

    public void renumberIDs() {
        if (!this.isEmpty()) {
            Collections.sort(this);
            ProjectEntityWithID firstEntity = (ProjectEntityWithID)this.get(0);
            int id = NumberHelper.getInt(firstEntity.getID());
            if (id != 0) {
                id = 1;
            }
            for (ProjectEntityWithID entity : this) {
                entity.setID(id++);
            }
        }
    }

    public T getByID(Integer id) {
        return (T)((ProjectEntityWithID)this.m_idMap.get(id));
    }

    public void unmapID(Integer id) {
        this.m_idMap.remove(id);
    }

    public void mapID(Integer id, T entity) {
        this.m_idMap.put(id, entity);
    }

    public Integer getNextID() {
        return this.m_idSequence.getNext();
    }
}

