/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mpxj.ActivityCodeContainer;
import org.mpxj.ChildResourceContainer;
import org.mpxj.ChildTaskContainer;
import org.mpxj.CostAccountContainer;
import org.mpxj.CurrencyContainer;
import org.mpxj.CustomFieldContainer;
import org.mpxj.DataLinkContainer;
import org.mpxj.EventManager;
import org.mpxj.ExpenseCategoryContainer;
import org.mpxj.ExternalProjectContainer;
import org.mpxj.FieldType;
import org.mpxj.FilterContainer;
import org.mpxj.GroupContainer;
import org.mpxj.LocationContainer;
import org.mpxj.NotesTopicContainer;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarContainer;
import org.mpxj.ProjectCodeContainer;
import org.mpxj.ProjectConfig;
import org.mpxj.ProjectFileSharedData;
import org.mpxj.ProjectProperties;
import org.mpxj.Relation;
import org.mpxj.RelationContainer;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignmentCodeContainer;
import org.mpxj.ResourceAssignmentContainer;
import org.mpxj.ResourceCodeContainer;
import org.mpxj.ResourceContainer;
import org.mpxj.RoleCodeContainer;
import org.mpxj.ShiftContainer;
import org.mpxj.ShiftPeriodContainer;
import org.mpxj.TableContainer;
import org.mpxj.Task;
import org.mpxj.TaskContainer;
import org.mpxj.UniqueIdObjectSequenceProvider;
import org.mpxj.UnitOfMeasureContainer;
import org.mpxj.UserDefinedFieldContainer;
import org.mpxj.ViewContainer;
import org.mpxj.WorkContourContainer;
import org.mpxj.common.NumberHelper;
import org.mpxj.common.ObjectSequence;

public final class ProjectFile
implements ChildTaskContainer,
ChildResourceContainer,
UniqueIdObjectSequenceProvider {
    private final ProjectConfig m_config = new ProjectConfig();
    private final ProjectProperties m_properties = new ProjectProperties(this);
    private final ResourceContainer m_resources = new ResourceContainer(this);
    private final TaskContainer m_tasks = new TaskContainer(this);
    private final List<Task> m_childTasks = new ArrayList<Task>();
    private final List<Resource> m_childResources = new ArrayList<Resource>();
    private final ResourceAssignmentContainer m_assignments = new ResourceAssignmentContainer(this);
    private final RelationContainer m_relations = new RelationContainer(this);
    private final ProjectCalendarContainer m_calendars = new ProjectCalendarContainer(this);
    private final TableContainer m_tables = new TableContainer();
    private final FilterContainer m_filters = new FilterContainer();
    private final GroupContainer m_groups = new GroupContainer();
    private final ViewContainer m_views = new ViewContainer();
    private final EventManager m_eventManager = new EventManager();
    private final DataLinkContainer m_dataLinks = new DataLinkContainer();
    private final ExternalProjectContainer m_externalProjects = new ExternalProjectContainer(this);
    private final ProjectFile[] m_baselines = new ProjectFile[11];
    private final Map<Integer, Map<Task, Task>> m_baselineTaskMap = new HashMap<Integer, Map<Task, Task>>();
    private final List<Exception> m_ignoredErrors = new ArrayList<Exception>();
    private final Map<String, ObjectSequence> m_uniqueIdObjectSequences = new HashMap<String, ObjectSequence>();
    private final ProjectFileSharedData m_shared;

    public ProjectFile() {
        this.m_shared = new ProjectFileSharedData();
    }

    public ProjectFile(ProjectFileSharedData shared) {
        this.m_shared = shared;
    }

    public ProjectConfig getProjectConfig() {
        return this.m_config;
    }

    @Override
    public Task addTask() {
        return this.m_tasks.add();
    }

    public void removeTask(Task task) {
        this.m_tasks.remove(task);
    }

    @Override
    public List<Task> getChildTasks() {
        return this.m_childTasks;
    }

    @Override
    public List<Resource> getChildResources() {
        return this.m_childResources;
    }

    public TaskContainer getTasks() {
        return this.m_tasks;
    }

    public ProjectCalendar addCalendar() {
        return this.m_calendars.add();
    }

    public void removeCalendar(ProjectCalendar calendar) {
        this.m_calendars.remove(calendar);
    }

    public ProjectCalendar addDefaultBaseCalendar() {
        return this.m_calendars.addDefaultBaseCalendar();
    }

    public ProjectCalendar addDefaultDerivedCalendar() {
        return this.m_calendars.addDefaultDerivedCalendar();
    }

    public ProjectCalendarContainer getCalendars() {
        return this.m_calendars;
    }

    public ProjectProperties getProjectProperties() {
        return this.m_properties;
    }

    @Override
    public Resource addResource() {
        return this.m_resources.add();
    }

    public void removeResource(Resource resource) {
        this.m_resources.remove(resource);
    }

    public ResourceContainer getResources() {
        return this.m_resources;
    }

    public ResourceAssignmentContainer getResourceAssignments() {
        return this.m_assignments;
    }

    public RelationContainer getRelations() {
        return this.m_relations;
    }

    public ProjectCalendar getCalendarByName(String calendarName) {
        return this.m_calendars.getByName(calendarName);
    }

    public ProjectCalendar getCalendarByUniqueID(Integer calendarID) {
        return (ProjectCalendar)this.m_calendars.getByUniqueID(calendarID);
    }

    public Task getTaskByID(Integer id) {
        return (Task)this.m_tasks.getByID(id);
    }

    public Task getTaskByUniqueID(Integer id) {
        return (Task)this.m_tasks.getByUniqueID(id);
    }

    public Resource getResourceByID(Integer id) {
        return (Resource)this.m_resources.getByID(id);
    }

    public Resource getResourceByUniqueID(Integer id) {
        return (Resource)this.m_resources.getByUniqueID(id);
    }

    public void updateStructure() {
        this.m_tasks.updateStructure();
        this.m_resources.updateStructure();
    }

    public LocalDateTime getEarliestStartDate() {
        return this.m_tasks.stream().map(this::getStartDate).filter(Objects::nonNull).min(Comparator.naturalOrder()).orElse(null);
    }

    LocalDateTime getActualStart() {
        return this.m_tasks.stream().map(Task::getActualStart).filter(Objects::nonNull).min(Comparator.naturalOrder()).orElse(null);
    }

    LocalDateTime getActualFinish() {
        if (this.m_tasks.stream().map(Task::getActualFinish).anyMatch(Objects::isNull)) {
            return null;
        }
        return this.m_tasks.stream().map(Task::getActualFinish).filter(Objects::nonNull).max(Comparator.naturalOrder()).orElse(null);
    }

    public LocalDateTime getLatestFinishDate() {
        return this.m_tasks.stream().map(this::getFinishDate).filter(Objects::nonNull).max(Comparator.naturalOrder()).orElse(null);
    }

    private LocalDateTime getStartDate(Task task) {
        LocalDateTime taskStartDate;
        if (NumberHelper.getInt(task.getUniqueID()) == 0) {
            return null;
        }
        if (task.getMilestone()) {
            taskStartDate = task.getActualFinish();
            if (taskStartDate == null) {
                taskStartDate = task.getFinish();
            }
        } else {
            taskStartDate = task.getActualStart();
            if (taskStartDate == null) {
                taskStartDate = task.getStart();
            }
        }
        return taskStartDate;
    }

    private LocalDateTime getFinishDate(Task task) {
        if (NumberHelper.getInt(task.getUniqueID()) == 0) {
            return null;
        }
        LocalDateTime taskFinishDate = task.getActualFinish();
        if (taskFinishDate == null) {
            taskFinishDate = task.getFinish();
        }
        return taskFinishDate;
    }

    public ViewContainer getViews() {
        return this.m_views;
    }

    public TableContainer getTables() {
        return this.m_tables;
    }

    public FilterContainer getFilters() {
        return this.m_filters;
    }

    public GroupContainer getGroups() {
        return this.m_groups;
    }

    public EventManager getEventManager() {
        return this.m_eventManager;
    }

    public CustomFieldContainer getCustomFields() {
        return this.m_shared.getCustomFields();
    }

    public ActivityCodeContainer getActivityCodes() {
        return this.m_shared.getActivityCodes();
    }

    public ProjectCodeContainer getProjectCodes() {
        return this.m_shared.getProjectCodes();
    }

    public ResourceCodeContainer getResourceCodes() {
        return this.m_shared.getResourceCodes();
    }

    public RoleCodeContainer getRoleCodes() {
        return this.m_shared.getRoleCodes();
    }

    public ResourceAssignmentCodeContainer getResourceAssignmentCodes() {
        return this.m_shared.getResourceAssignmentCodes();
    }

    public ShiftContainer getShifts() {
        return this.m_shared.getShifts();
    }

    public ShiftPeriodContainer getShiftPeriods() {
        return this.m_shared.getShiftPeriods();
    }

    public CurrencyContainer getCurrencies() {
        return this.m_shared.getCurrencies();
    }

    public DataLinkContainer getDataLinks() {
        return this.m_dataLinks;
    }

    public ExpenseCategoryContainer getExpenseCategories() {
        return this.m_shared.getExpenseCategories();
    }

    public CostAccountContainer getCostAccounts() {
        return this.m_shared.getCostAccounts();
    }

    public UserDefinedFieldContainer getUserDefinedFields() {
        return this.m_shared.getUserDefinedFields();
    }

    public WorkContourContainer getWorkContours() {
        return this.m_shared.getWorkContours();
    }

    public NotesTopicContainer getNotesTopics() {
        return this.m_shared.getNotesTopics();
    }

    public LocationContainer getLocations() {
        return this.m_shared.getLocations();
    }

    public UnitOfMeasureContainer getUnitsOfMeasure() {
        return this.m_shared.getUnitsOfMeasure();
    }

    public ProjectCalendar getDefaultCalendar() {
        return this.getProjectProperties().getDefaultCalendar();
    }

    public void setDefaultCalendar(ProjectCalendar calendar) {
        if (calendar != null) {
            this.m_properties.setDefaultCalendar(calendar);
        }
    }

    public ProjectCalendar getBaselineCalendar() {
        ProjectCalendar result = this.getCalendarByName(this.m_properties.getBaselineCalendarName());
        if (result == null) {
            result = this.getDefaultCalendar();
        }
        return result;
    }

    public List<ProjectFile> getBaselines() {
        return Arrays.asList(this.m_baselines);
    }

    public void setBaseline(ProjectFile baseline) {
        this.setBaseline(baseline, 0);
    }

    public ProjectFile getBaseline() {
        return this.getBaseline(0);
    }

    public void setBaseline(ProjectFile baseline, int index) {
        if (index < 0 || index >= this.m_baselines.length) {
            throw new IllegalArgumentException(index + " is not a valid baseline index");
        }
        this.m_baselines[index] = baseline;
        if (index == 0) {
            this.m_properties.setBaselineDate(baseline.getProjectProperties().getCreationDate());
        } else {
            this.m_properties.setBaselineDate(index, baseline.getProjectProperties().getCreationDate());
        }
        this.m_config.getBaselineStrategy().populateBaseline(this, baseline, index);
    }

    public ProjectFile getBaseline(int index) {
        if (index < 0 || index >= this.m_baselines.length) {
            throw new IllegalArgumentException(index + " is not a valid baseline index");
        }
        return this.m_baselines[index];
    }

    public void clearBaseline() {
        this.clearBaseline(0);
    }

    public void clearBaseline(int index) {
        this.m_config.getBaselineStrategy().clearBaseline(this, index);
    }

    void setBaselineTaskMap(int index, Map<Task, Task> map) {
        this.m_baselineTaskMap.put(index, map);
    }

    Map<Task, Task> getBaselineTaskMap(int index) {
        return this.m_baselineTaskMap.getOrDefault(index, Collections.emptyMap());
    }

    public Set<FieldType> getPopulatedFields() {
        return Stream.of(this.m_tasks.getPopulatedFields(), this.m_resources.getPopulatedFields(), this.m_assignments.getPopulatedFields(), this.m_properties.getPopulatedFields()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public void expandSubprojects(boolean replaceExternalTasks) {
        this.getTasks().stream().map(Task::expandSubproject).filter(Objects::nonNull).forEach(p -> p.expandSubprojects(replaceExternalTasks));
        if (replaceExternalTasks) {
            this.replaceExternalTasks();
        }
    }

    private void replaceExternalTasks() {
        ArrayList<Task> externalTasks = new ArrayList<Task>();
        this.findExternalTasks(this.getChildTasks(), externalTasks);
        Set<Task> replacedTasks = externalTasks.stream().map(this::replaceRelations).filter(Objects::nonNull).collect(Collectors.toSet());
        this.removeExternalTasks(this.getChildTasks(), replacedTasks);
    }

    private Task replaceRelations(Task externalTask) {
        ProjectFile originalProjectFile = this.findProject(externalTask.getSubprojectFile());
        if (originalProjectFile == null) {
            return null;
        }
        Task originalTask = this.findTask(originalProjectFile, externalTask);
        if (originalTask == null) {
            return null;
        }
        this.replaceRelations(externalTask, originalTask);
        return externalTask;
    }

    private ProjectFile findProject(String name) {
        if (name.equals(this.m_properties.getProjectFilePath())) {
            return this;
        }
        return this.m_externalProjects.read(name);
    }

    private Task findTask(ProjectFile file, Task externalTask) {
        Task result;
        Integer id = externalTask.getSubprojectTaskUniqueID();
        if (id != null && (result = file.getTaskByUniqueID(id)) != null) {
            return result;
        }
        id = externalTask.getSubprojectTaskID();
        if (id != null) {
            return file.getTaskByID(id);
        }
        return null;
    }

    private void replaceRelations(Task externalTask, Task originalTask) {
        RelationContainer relations = externalTask.getParentFile().getRelations();
        ArrayList<Relation> successors = new ArrayList<Relation>(relations.getSuccessors(externalTask));
        ArrayList<Relation> predecessors = new ArrayList<Relation>(relations.getPredecessors(externalTask));
        for (Relation originalRelation : successors) {
            relations.remove(originalRelation);
            originalRelation.getSuccessorTask().addPredecessor(new Relation.Builder().from(originalRelation).predecessorTask(originalTask));
        }
        for (Relation originalRelation : predecessors) {
            relations.remove(originalRelation);
            originalTask.addPredecessor(new Relation.Builder().from(originalRelation));
        }
    }

    private void findExternalTasks(List<Task> tasks, List<Task> externalTasks) {
        externalTasks.addAll(tasks.stream().filter(Task::getExternalTask).collect(Collectors.toList()));
        tasks.forEach(t -> this.findExternalTasks(t.getChildTasks(), externalTasks));
    }

    private void removeExternalTasks(List<Task> tasks, Set<Task> replacedTasks) {
        tasks.removeIf(replacedTasks::contains);
        for (Task task : tasks) {
            this.removeExternalTasks(task.getChildTasks(), replacedTasks);
        }
    }

    public void readComplete() {
        this.fixUniqueIdClashes();
    }

    public void fixUniqueIdClashes() {
        this.getTasks().fixUniqueIdClashes();
        this.getResources().fixUniqueIdClashes();
        this.getCalendars().fixUniqueIdClashes();
        this.getResourceAssignments().fixUniqueIdClashes();
        this.getRelations().fixUniqueIdClashes();
    }

    @Override
    public ObjectSequence getUniqueIdObjectSequence(Class<?> c) {
        return ProjectFileSharedData.contains(c) ? this.m_shared.getUniqueIdObjectSequence(c) : this.m_uniqueIdObjectSequences.computeIfAbsent(c.getName(), x -> new ObjectSequence(1));
    }

    public void addIgnoredError(Exception ex) {
        this.m_ignoredErrors.add(ex);
    }

    public List<Exception> getIgnoredErrors() {
        return this.m_ignoredErrors;
    }

    void addExternalProject(String fileName, ProjectFile projectFile) {
        this.m_externalProjects.add(fileName, projectFile);
    }

    ProjectFile readExternalProject(String fileName) {
        return this.m_externalProjects.read(fileName);
    }
}

