/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.text.DateFormatSymbols;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.mpxj.RecurrenceType;
import org.mpxj.common.DayOfWeekHelper;
import org.mpxj.common.NumberHelper;

public class RecurringData {
    private static final String[] ORDINAL = new String[]{null, "every", "every other", "every 3rd"};
    private static final String[] DAY_ORDINAL = new String[]{null, "First", "Second", "Third", "Fourth", "Last"};
    private LocalDate m_startDate;
    private LocalDate m_finishDate;
    private Integer m_occurrences;
    private RecurrenceType m_recurrenceType;
    private boolean m_relative;
    private boolean m_workingDaysOnly;
    private boolean m_useEndDate;
    private Integer m_frequency;
    private Integer m_dayNumber;
    private Integer m_monthNumber;
    private LocalDate[] m_dates;
    private final EnumSet<DayOfWeek> m_days = EnumSet.noneOf(DayOfWeek.class);

    public LocalDate getStartDate() {
        return this.m_startDate;
    }

    public void setStartDate(LocalDate val) {
        this.m_startDate = val;
        this.clearDatesCache();
    }

    public LocalDate getFinishDate() {
        return this.m_finishDate;
    }

    public void setFinishDate(LocalDate val) {
        this.m_finishDate = val;
        this.clearDatesCache();
    }

    public Integer getOccurrences() {
        return this.m_occurrences;
    }

    public void setOccurrences(Integer occurrences) {
        this.m_occurrences = occurrences;
        this.clearDatesCache();
    }

    public RecurrenceType getRecurrenceType() {
        return this.m_recurrenceType;
    }

    public void setRecurrenceType(RecurrenceType type) {
        this.m_recurrenceType = type;
        this.clearDatesCache();
    }

    public boolean getUseEndDate() {
        return this.m_useEndDate;
    }

    public void setUseEndDate(boolean useEndDate) {
        this.m_useEndDate = useEndDate;
        this.clearDatesCache();
    }

    public boolean getWorkingDaysOnly() {
        return this.m_workingDaysOnly;
    }

    public void setWorkingDaysOnly(boolean workingDaysOnly) {
        this.m_workingDaysOnly = workingDaysOnly;
        this.clearDatesCache();
    }

    public boolean getWeeklyDay(DayOfWeek day) {
        return this.m_days.contains(day);
    }

    public void setWeeklyDay(DayOfWeek day, boolean value) {
        if (value) {
            this.m_days.add(day);
        } else {
            this.m_days.remove(day);
        }
        this.clearDatesCache();
    }

    public void setWeeklyDaysFromBitmap(Integer days, int[] masks) {
        if (days != null) {
            int value = days;
            for (DayOfWeek day : DayOfWeek.values()) {
                this.setWeeklyDay(day, (value & masks[DayOfWeekHelper.getValue(day)]) != 0);
            }
            this.clearDatesCache();
        }
    }

    public boolean getRelative() {
        return this.m_relative;
    }

    public void setRelative(boolean relative) {
        this.m_relative = relative;
        this.clearDatesCache();
    }

    public Integer getFrequency() {
        return this.m_frequency;
    }

    public void setFrequency(Integer frequency) {
        this.m_frequency = frequency;
        this.clearDatesCache();
    }

    public DayOfWeek getDayOfWeek() {
        DayOfWeek result = null;
        if (!this.m_days.isEmpty()) {
            result = (DayOfWeek)this.m_days.iterator().next();
        }
        return result;
    }

    public void setDayOfWeek(DayOfWeek day) {
        this.m_days.clear();
        this.m_days.add(day);
        this.clearDatesCache();
    }

    public Integer getDayNumber() {
        return this.m_dayNumber;
    }

    public void setDayNumber(Integer day) {
        this.m_dayNumber = day;
        this.clearDatesCache();
    }

    public Integer getMonthNumber() {
        return this.m_monthNumber;
    }

    public void setMonthNumber(Integer month) {
        this.m_monthNumber = month;
        this.clearDatesCache();
    }

    public LocalDate[] getDates() {
        this.populateDates();
        return this.m_dates;
    }

    public boolean isValid() {
        this.populateDates();
        return this.m_dates.length > 0;
    }

    public LocalDate getCalculatedFirstDate() {
        this.populateDates();
        return this.m_dates[0];
    }

    public LocalDate getCalculatedLastDate() {
        this.populateDates();
        return this.m_dates[this.m_dates.length - 1];
    }

    private void populateDates() {
        if (this.m_dates != null) {
            return;
        }
        int frequency = NumberHelper.getInt(this.m_frequency);
        if (frequency < 1) {
            frequency = 1;
        }
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>();
        switch (this.m_recurrenceType) {
            case DAILY: {
                this.getDailyDates(frequency, dates);
                break;
            }
            case WEEKLY: {
                this.getWeeklyDates(frequency, dates);
                break;
            }
            case MONTHLY: {
                this.getMonthlyDates(frequency, dates);
                break;
            }
            case YEARLY: {
                this.getYearlyDates(dates);
            }
        }
        this.m_dates = dates.toArray(new LocalDate[0]);
    }

    private boolean moreDates(LocalDate date, List<LocalDate> dates) {
        boolean result;
        if (this.m_finishDate == null) {
            int occurrences = NumberHelper.getInt(this.m_occurrences);
            if (occurrences < 1) {
                occurrences = 1;
            }
            result = dates.size() < occurrences;
        } else {
            result = !date.isAfter(this.m_finishDate);
        }
        return result;
    }

    private void getDailyDates(int frequency, List<LocalDate> dates) {
        LocalDate date = this.m_startDate;
        while (this.moreDates(date, dates)) {
            dates.add(date);
            date = date.plusDays(frequency);
        }
    }

    private void getWeeklyDates(int frequency, List<LocalDate> dates) {
        LocalDate date = this.m_startDate;
        DayOfWeek currentDay = date.getDayOfWeek();
        if (currentDay != DayOfWeek.SUNDAY) {
            date = date.minusDays(currentDay.getValue());
            currentDay = DayOfWeek.SUNDAY;
        }
        while (this.moreDates(date, dates)) {
            int offset = 0;
            for (int dayIndex = 0; dayIndex < 7; ++dayIndex) {
                if (this.getWeeklyDay(currentDay)) {
                    if (offset != 0) {
                        date = date.plusDays(offset);
                        offset = 0;
                    }
                    if (!this.moreDates(date, dates)) break;
                    if (!date.isBefore(this.m_startDate)) {
                        dates.add(date);
                    }
                }
                ++offset;
                currentDay = currentDay.plus(1L);
            }
            if (frequency > 1) {
                offset += 7 * (frequency - 1);
            }
            date = date.plusDays(offset);
        }
    }

    private void getMonthlyDates(int frequency, List<LocalDate> dates) {
        if (this.m_relative) {
            this.getMonthlyRelativeDates(frequency, dates);
        } else {
            this.getMonthlyAbsoluteDates(frequency, dates);
        }
    }

    private void getMonthlyRelativeDates(int frequency, List<LocalDate> dates) {
        LocalDate date = LocalDate.of(this.m_startDate.getYear(), this.m_startDate.getMonth(), 1);
        int dayNumber = NumberHelper.getInt(this.m_dayNumber);
        while (this.moreDates(date, dates)) {
            date = dayNumber > 4 ? this.getLastRelativeDay(date) : this.getOrdinalRelativeDay(date, dayNumber);
            if (!date.isBefore(this.m_startDate)) {
                dates.add(date);
                if (!this.moreDates(date, dates)) break;
            }
            date = LocalDate.of(date.getYear(), date.getMonth(), 1);
            date = date.plusMonths(frequency);
        }
    }

    private void getMonthlyAbsoluteDates(int frequency, List<LocalDate> dates) {
        LocalDate date = this.m_startDate;
        int currentDayNumber = date.getDayOfMonth();
        date = LocalDate.of(date.getYear(), date.getMonth(), 1);
        int requiredDayNumber = NumberHelper.getInt(this.m_dayNumber);
        if (requiredDayNumber < currentDayNumber) {
            date = date.plusMonths(1L);
        }
        while (this.moreDates(date, dates)) {
            int useDayNumber = requiredDayNumber;
            YearMonth month = YearMonth.of(date.getYear(), date.getMonth());
            int maxDayNumber = month.lengthOfMonth();
            if (useDayNumber > maxDayNumber) {
                useDayNumber = maxDayNumber;
            }
            date = LocalDate.of(date.getYear(), date.getMonth(), useDayNumber);
            dates.add(date);
            date = LocalDate.of(date.getYear(), date.getMonth(), 1);
            date = date.plusMonths(frequency);
        }
    }

    private void getYearlyDates(List<LocalDate> dates) {
        if (this.m_relative) {
            this.getYearlyRelativeDates(dates);
        } else {
            this.getYearlyAbsoluteDates(dates);
        }
    }

    private void getYearlyRelativeDates(List<LocalDate> dates) {
        LocalDate date = LocalDate.of(this.m_startDate.getYear(), NumberHelper.getInt(this.m_monthNumber), 1);
        int dayNumber = NumberHelper.getInt(this.m_dayNumber);
        while (this.moreDates(date, dates)) {
            date = dayNumber > 4 ? this.getLastRelativeDay(date) : this.getOrdinalRelativeDay(date, dayNumber);
            if (!date.isBefore(this.m_startDate)) {
                dates.add(date);
                if (!this.moreDates(date, dates)) break;
            }
            date = LocalDate.of(date.getYear() + 1, date.getMonth(), 1);
        }
    }

    private void getYearlyAbsoluteDates(List<LocalDate> dates) {
        LocalDate date = LocalDate.of(this.m_startDate.getYear(), NumberHelper.getInt(this.m_monthNumber), 1);
        int requiredDayNumber = NumberHelper.getInt(this.m_dayNumber);
        while (this.moreDates(date, dates)) {
            int useDayNumber = requiredDayNumber;
            YearMonth month = YearMonth.of(date.getYear(), date.getMonth());
            int maxDayNumber = month.lengthOfMonth();
            if (useDayNumber > maxDayNumber) {
                useDayNumber = maxDayNumber;
            }
            if ((date = LocalDate.of(date.getYear(), date.getMonth(), useDayNumber)).isBefore(this.m_startDate)) {
                date = date.plusYears(1L);
            }
            dates.add(date);
            date = LocalDate.of(date.getYear(), date.getMonth(), 1);
            date = date.plusYears(1L);
        }
    }

    private LocalDate getOrdinalRelativeDay(LocalDate date, int dayNumber) {
        int currentDayOfWeek = DayOfWeekHelper.getValue(date.getDayOfWeek());
        int requiredDayOfWeek = DayOfWeekHelper.getValue(this.getDayOfWeek());
        int dayOfWeekOffset = 0;
        if (requiredDayOfWeek > currentDayOfWeek) {
            dayOfWeekOffset = requiredDayOfWeek - currentDayOfWeek;
        } else if (requiredDayOfWeek < currentDayOfWeek) {
            dayOfWeekOffset = 7 - (currentDayOfWeek - requiredDayOfWeek);
        }
        if (dayOfWeekOffset != 0) {
            date = date.plusDays(dayOfWeekOffset);
        }
        if (dayNumber > 1) {
            date = date.plusDays(7L * ((long)dayNumber - 1L));
        }
        return date;
    }

    private LocalDate getLastRelativeDay(LocalDate date) {
        YearMonth month = YearMonth.of(date.getYear(), date.getMonth());
        date = LocalDate.of(date.getYear(), date.getMonth(), month.lengthOfMonth());
        int currentDayOfWeek = DayOfWeekHelper.getValue(date.getDayOfWeek());
        int requiredDayOfWeek = DayOfWeekHelper.getValue(this.getDayOfWeek());
        int dayOfWeekOffset = 0;
        if (currentDayOfWeek > requiredDayOfWeek) {
            dayOfWeekOffset = requiredDayOfWeek - currentDayOfWeek;
        } else if (currentDayOfWeek < requiredDayOfWeek) {
            dayOfWeekOffset = -7 + (requiredDayOfWeek - currentDayOfWeek);
        }
        if (dayOfWeekOffset != 0) {
            date = date.plusDays(dayOfWeekOffset);
        }
        return date;
    }

    public void setYearlyAbsoluteFromDate(LocalDate date) {
        if (date != null) {
            this.m_dayNumber = date.getDayOfMonth();
            this.m_monthNumber = date.getMonthValue();
            this.clearDatesCache();
        }
    }

    private String getOrdinal(Integer value) {
        int index = value;
        String result = index >= ORDINAL.length ? "every " + index + "th" : ORDINAL[index];
        return result;
    }

    private void clearDatesCache() {
        this.m_dates = null;
    }

    public String toString() {
        DateFormatSymbols dfs = new DateFormatSymbols();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(os);
        pw.print("[RecurringData ");
        pw.print(this.m_recurrenceType);
        switch (this.m_recurrenceType) {
            case DAILY: {
                pw.print(" " + this.getOrdinal(this.m_frequency));
                pw.print(this.m_workingDaysOnly ? " Working day" : " Day");
                break;
            }
            case WEEKLY: {
                pw.print(" " + this.getOrdinal(this.m_frequency));
                pw.print(" week on ");
                StringBuilder sb = new StringBuilder();
                for (DayOfWeek day : DayOfWeek.values()) {
                    if (!this.getWeeklyDay(day)) continue;
                    if (sb.length() != 0) {
                        sb.append(", ");
                    }
                    sb.append(dfs.getWeekdays()[DayOfWeekHelper.getValue(day)]);
                }
                pw.print(sb);
                break;
            }
            case MONTHLY: {
                if (this.m_relative) {
                    pw.print(" on The ");
                    pw.print(DAY_ORDINAL[this.m_dayNumber]);
                    pw.print(" ");
                    pw.print(dfs.getWeekdays()[DayOfWeekHelper.getValue(this.getDayOfWeek())]);
                    pw.print(" of ");
                    pw.print(this.getOrdinal(this.m_frequency));
                } else {
                    pw.print(" on Day ");
                    pw.print(this.m_dayNumber);
                    pw.print(" of ");
                    pw.print(this.getOrdinal(this.m_frequency));
                }
                pw.print(" month");
                break;
            }
            case YEARLY: {
                pw.print(" on the ");
                if (this.m_relative) {
                    pw.print(DAY_ORDINAL[this.m_dayNumber]);
                    pw.print(" ");
                    pw.print(dfs.getWeekdays()[DayOfWeekHelper.getValue(this.getDayOfWeek())]);
                    pw.print(" of ");
                    pw.print(dfs.getMonths()[this.m_monthNumber - 1]);
                    break;
                }
                pw.print(this.m_dayNumber + " " + dfs.getMonths()[this.m_monthNumber - 1]);
            }
        }
        if (this.m_startDate != null) {
            pw.print(" From " + this.m_startDate);
        }
        if (this.m_occurrences != null) {
            pw.print(" For " + this.m_occurrences + " occurrences");
        }
        if (this.m_finishDate != null) {
            pw.print(" To " + this.m_finishDate);
        }
        pw.print("]");
        pw.flush();
        return os.toString();
    }
}

