/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mpxj.Duration;
import org.mpxj.ProjectEntityContainer;
import org.mpxj.ProjectFile;
import org.mpxj.Relation;
import org.mpxj.RelationType;
import org.mpxj.Task;
import org.mpxj.TimeUnit;

public class RelationContainer
extends ProjectEntityContainer<Relation> {
    private final Map<Task, List<Relation>> m_predecessors = new HashMap<Task, List<Relation>>();
    private final Map<Task, List<Relation>> m_successors = new HashMap<Task, List<Relation>>();
    private static final List<Relation> EMPTY_LIST = Collections.emptyList();

    public RelationContainer(ProjectFile projectFile) {
        super(projectFile);
    }

    public List<Relation> getPredecessors(Task task) {
        return this.m_predecessors.getOrDefault(task, EMPTY_LIST);
    }

    @Override
    protected void added(Relation element) {
        this.m_predecessors.computeIfAbsent(element.getSuccessorTask(), t -> new ArrayList()).add(element);
        this.m_successors.computeIfAbsent(element.getPredecessorTask(), t -> new ArrayList()).add(element);
    }

    @Override
    protected void removed(Relation element) {
        this.m_predecessors.getOrDefault(element.getSuccessorTask(), EMPTY_LIST).remove(element);
        this.m_successors.getOrDefault(element.getPredecessorTask(), EMPTY_LIST).remove(element);
    }

    @Override
    protected void replaced(Relation oldElement, Relation newElement) {
        this.removed(oldElement);
        this.added(newElement);
    }

    public List<Relation> getSuccessors(Task task) {
        return this.m_successors.getOrDefault(task, EMPTY_LIST);
    }

    public Relation addPredecessor(Relation.Builder builder) {
        List<Relation> predecessorList = this.m_predecessors.getOrDefault(builder.m_successorTask, EMPTY_LIST);
        for (Relation relation : predecessorList) {
            if (relation.getPredecessorTask() != builder.m_predecessorTask) continue;
            if (relation.getType() != builder.m_type || relation.getLag().compareTo(builder.m_lag) != 0) break;
            return relation;
        }
        Relation predecessorRelation = builder.build();
        this.add(predecessorRelation);
        return predecessorRelation;
    }

    public boolean removePredecessor(Task successorTask, Task predecessorTask, RelationType type, Duration lag) {
        List<Relation> predecessorList = this.m_predecessors.getOrDefault(successorTask, EMPTY_LIST);
        if (predecessorList.isEmpty()) {
            return false;
        }
        if (lag == null) {
            lag = Duration.getInstance(0, TimeUnit.DAYS);
        }
        boolean matchFound = false;
        for (Relation relation : predecessorList) {
            if (relation.getPredecessorTask() != predecessorTask || relation.getType() != type || relation.getLag().compareTo(lag) != 0) continue;
            matchFound = true;
            this.remove(relation);
            break;
        }
        return matchFound;
    }
}

