/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.mpxj.AbstractFieldContainer;
import org.mpxj.AccrueType;
import org.mpxj.Availability;
import org.mpxj.AvailabilityTable;
import org.mpxj.BookingType;
import org.mpxj.ChildResourceContainer;
import org.mpxj.CostRateTable;
import org.mpxj.CostRateTableEntry;
import org.mpxj.Currency;
import org.mpxj.Duration;
import org.mpxj.FieldContainerDependencies;
import org.mpxj.FieldType;
import org.mpxj.Location;
import org.mpxj.MPXJException;
import org.mpxj.Notes;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectConfig;
import org.mpxj.ProjectEntityWithID;
import org.mpxj.ProjectFile;
import org.mpxj.Rate;
import org.mpxj.ResourceAssignment;
import org.mpxj.ResourceCode;
import org.mpxj.ResourceCodeValue;
import org.mpxj.ResourceField;
import org.mpxj.ResourceType;
import org.mpxj.RoleCode;
import org.mpxj.RoleCodeValue;
import org.mpxj.Shift;
import org.mpxj.SkillLevel;
import org.mpxj.UnitOfMeasure;
import org.mpxj.WorkGroup;
import org.mpxj.common.BooleanHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.common.ResourceFieldLists;

public final class Resource
extends AbstractFieldContainer<Resource>
implements Comparable<Resource>,
ProjectEntityWithID,
ChildResourceContainer {
    private final List<ResourceAssignment> m_assignments = new ArrayList<ResourceAssignment>();
    private final Map<Resource, SkillLevel> m_roleAssignments = new HashMap<Resource, SkillLevel>();
    private final List<Resource> m_children = new ArrayList<Resource>();
    private boolean m_null;
    private String m_activeDirectoryGUID;
    private final CostRateTable[] m_costRateTables;
    private final AvailabilityTable m_availability = new AvailabilityTable();
    private static final Set<FieldType> ALWAYS_CALCULATED_FIELDS = new HashSet<ResourceField>(Arrays.asList(ResourceField.STANDARD_RATE, ResourceField.OVERTIME_RATE, ResourceField.COST_PER_USE, ResourceField.START, ResourceField.FINISH, ResourceField.MAX_UNITS, ResourceField.AVAILABLE_FROM, ResourceField.AVAILABLE_TO));
    private static final Map<FieldType, Function<Resource, Object>> CALCULATED_FIELD_MAP = new HashMap<FieldType, Function<Resource, Object>>();
    private static final Map<FieldType, List<FieldType>> DEPENDENCY_MAP;
    private static final Number DEFAULT_DEFAULT_UNITS;

    Resource(ProjectFile file) {
        super(file);
        ProjectConfig config = file.getProjectConfig();
        if (config.getAutoResourceUniqueID()) {
            this.setUniqueID(file.getUniqueIdObjectSequence(Resource.class).getNext());
        }
        if (config.getAutoResourceID()) {
            this.setID(file.getResources().getNextID());
        }
        this.m_costRateTables = new CostRateTable[5];
        for (int index = 0; index < this.m_costRateTables.length; ++index) {
            CostRateTable table = new CostRateTable();
            table.add(CostRateTableEntry.DEFAULT_ENTRY);
            this.m_costRateTables[index] = table;
        }
    }

    @Override
    public Resource addResource() {
        ProjectFile parent = this.getParentFile();
        Resource resource = new Resource(parent);
        resource.setParentResource(this);
        this.m_children.add(resource);
        parent.getResources().add(resource);
        return resource;
    }

    public void addChildResource(Resource child) {
        child.setParentResource(this);
        this.m_children.add(child);
    }

    @Override
    public List<Resource> getChildResources() {
        return this.m_children;
    }

    public void removeChildResource(Resource child) {
        if (this.m_children.remove(child)) {
            child.setParentResourceUniqueID(null);
        }
    }

    public void setName(String val) {
        this.set((FieldType)ResourceField.NAME, val);
    }

    public String getName() {
        return (String)this.get(ResourceField.NAME);
    }

    public void setType(ResourceType type) {
        this.set((FieldType)ResourceField.TYPE, type);
    }

    public ResourceType getType() {
        return (ResourceType)this.get(ResourceField.TYPE);
    }

    public void setIsNull(boolean isNull) {
        this.m_null = isNull;
    }

    public boolean getNull() {
        return this.m_null;
    }

    public void setInitials(String val) {
        this.set((FieldType)ResourceField.INITIALS, val);
    }

    public String getInitials() {
        return (String)this.get(ResourceField.INITIALS);
    }

    public void setPhonetics(String phonetics) {
        this.set((FieldType)ResourceField.PHONETICS, phonetics);
    }

    public String getPhonetics() {
        return (String)this.get(ResourceField.PHONETICS);
    }

    public void setNtAccount(String ntAccount) {
        this.set((FieldType)ResourceField.WINDOWS_USER_ACCOUNT, ntAccount);
    }

    public String getNtAccount() {
        return (String)this.get(ResourceField.WINDOWS_USER_ACCOUNT);
    }

    public String getMaterialLabel() {
        return (String)this.get(ResourceField.MATERIAL_LABEL);
    }

    public void setCode(String val) {
        this.set((FieldType)ResourceField.CODE, val);
    }

    public String getCode() {
        return (String)this.get(ResourceField.CODE);
    }

    public void setGroup(String val) {
        this.set((FieldType)ResourceField.GROUP, val);
    }

    public String getGroup() {
        return (String)this.get(ResourceField.GROUP);
    }

    public void setWorkGroup(WorkGroup workGroup) {
        this.set((FieldType)ResourceField.WORKGROUP, workGroup);
    }

    public WorkGroup getWorkGroup() {
        return (WorkGroup)this.get(ResourceField.WORKGROUP);
    }

    public void setEmailAddress(String emailAddress) {
        this.set((FieldType)ResourceField.EMAIL_ADDRESS, emailAddress);
    }

    public String getEmailAddress() {
        return (String)this.get(ResourceField.EMAIL_ADDRESS);
    }

    public void setHyperlink(String hyperlink) {
        this.set((FieldType)ResourceField.HYPERLINK, hyperlink);
    }

    public String getHyperlink() {
        return (String)this.get(ResourceField.HYPERLINK);
    }

    public void setHyperlinkAddress(String hyperlinkAddress) {
        this.set((FieldType)ResourceField.HYPERLINK_ADDRESS, hyperlinkAddress);
    }

    public String getHyperlinkAddress() {
        return (String)this.get(ResourceField.HYPERLINK_ADDRESS);
    }

    public void setHyperlinkSubAddress(String hyperlinkSubAddress) {
        this.set((FieldType)ResourceField.HYPERLINK_SUBADDRESS, hyperlinkSubAddress);
    }

    public String getHyperlinkSubAddress() {
        return (String)this.get(ResourceField.HYPERLINK_SUBADDRESS);
    }

    public void setHyperlinkScreenTip(String text) {
        this.set((FieldType)ResourceField.HYPERLINK_SCREEN_TIP, text);
    }

    public String getHyperlinkScreenTip() {
        return (String)this.get(ResourceField.HYPERLINK_SCREEN_TIP);
    }

    public void setDefaultUnits(Number defaultUnits) {
        this.set((FieldType)ResourceField.DEFAULT_UNITS, defaultUnits);
    }

    public Number getDefaultUnits() {
        return (Number)this.get(ResourceField.DEFAULT_UNITS);
    }

    public Number getMaxUnits() {
        return (Number)this.get(ResourceField.MAX_UNITS);
    }

    public void setPeakUnits(Number peakUnits) {
        this.set((FieldType)ResourceField.PEAK, peakUnits);
    }

    public Number getPeakUnits() {
        return (Number)this.get(ResourceField.PEAK);
    }

    public void setOverAllocated(boolean overallocated) {
        this.set((FieldType)ResourceField.OVERALLOCATED, overallocated);
    }

    public boolean getOverAllocated() {
        return BooleanHelper.getBoolean((Boolean)this.get(ResourceField.OVERALLOCATED));
    }

    public LocalDateTime getAvailableFrom() {
        return (LocalDateTime)this.get(ResourceField.AVAILABLE_FROM);
    }

    public LocalDateTime getAvailableTo() {
        return (LocalDateTime)this.get(ResourceField.AVAILABLE_TO);
    }

    public LocalDateTime getStart() {
        return (LocalDateTime)this.get(ResourceField.START);
    }

    public LocalDateTime getFinish() {
        return (LocalDateTime)this.get(ResourceField.FINISH);
    }

    public void setCanLevel(boolean canLevel) {
        this.set((FieldType)ResourceField.CAN_LEVEL, canLevel);
    }

    public boolean getCanLevel() {
        return BooleanHelper.getBoolean((Boolean)this.get(ResourceField.CAN_LEVEL));
    }

    public void setAccrueAt(AccrueType type) {
        this.set((FieldType)ResourceField.ACCRUE_AT, type);
    }

    public AccrueType getAccrueAt() {
        return (AccrueType)this.get(ResourceField.ACCRUE_AT);
    }

    public void setWork(Duration val) {
        this.set((FieldType)ResourceField.WORK, val);
    }

    public Duration getWork() {
        return (Duration)this.get(ResourceField.WORK);
    }

    public Duration getRegularWork() {
        return (Duration)this.get(ResourceField.REGULAR_WORK);
    }

    public void setRegularWork(Duration duration) {
        this.set((FieldType)ResourceField.REGULAR_WORK, duration);
    }

    public void setActualWork(Duration val) {
        this.set((FieldType)ResourceField.ACTUAL_WORK, val);
    }

    public Duration getActualWork() {
        return (Duration)this.get(ResourceField.ACTUAL_WORK);
    }

    public void setOvertimeWork(Duration overtimeWork) {
        this.set((FieldType)ResourceField.OVERTIME_WORK, overtimeWork);
    }

    public Duration getOvertimeWork() {
        return (Duration)this.get(ResourceField.OVERTIME_WORK);
    }

    public void setRemainingWork(Duration val) {
        this.set((FieldType)ResourceField.REMAINING_WORK, val);
    }

    public Duration getRemainingWork() {
        return (Duration)this.get(ResourceField.REMAINING_WORK);
    }

    public Duration getActualOvertimeWork() {
        return (Duration)this.get(ResourceField.ACTUAL_OVERTIME_WORK);
    }

    public void setActualOvertimeWork(Duration duration) {
        this.set((FieldType)ResourceField.ACTUAL_OVERTIME_WORK, duration);
    }

    public Duration getRemainingOvertimeWork() {
        return (Duration)this.get(ResourceField.REMAINING_OVERTIME_WORK);
    }

    public void setRemainingOvertimeWork(Duration duration) {
        this.set((FieldType)ResourceField.REMAINING_OVERTIME_WORK, duration);
    }

    public void setPercentWorkComplete(Number percentWorkComplete) {
        this.set((FieldType)ResourceField.PERCENT_WORK_COMPLETE, percentWorkComplete);
    }

    public Number getPercentWorkComplete() {
        return (Number)this.get(ResourceField.PERCENT_WORK_COMPLETE);
    }

    public Rate getStandardRate() {
        return (Rate)this.get(ResourceField.STANDARD_RATE);
    }

    public void setCost(Number cost) {
        this.set((FieldType)ResourceField.COST, cost);
    }

    public Number getCost() {
        return (Number)this.get(ResourceField.COST);
    }

    public Rate getOvertimeRate() {
        return (Rate)this.get(ResourceField.OVERTIME_RATE);
    }

    public Number getOvertimeCost() {
        return (Number)this.get(ResourceField.OVERTIME_COST);
    }

    public void setOvertimeCost(Number currency) {
        this.set((FieldType)ResourceField.OVERTIME_COST, currency);
    }

    public Number getCostPerUse() {
        return (Number)this.get(ResourceField.COST_PER_USE);
    }

    public void setActualCost(Number actualCost) {
        this.set((FieldType)ResourceField.ACTUAL_COST, actualCost);
    }

    public Number getActualCost() {
        return (Number)this.get(ResourceField.ACTUAL_COST);
    }

    public Number getActualOvertimeCost() {
        return (Number)this.get(ResourceField.ACTUAL_OVERTIME_COST);
    }

    public void setActualOvertimeCost(Number actualOvertimeCost) {
        this.set((FieldType)ResourceField.ACTUAL_OVERTIME_COST, actualOvertimeCost);
    }

    public void setRemainingCost(Number remainingCost) {
        this.set((FieldType)ResourceField.REMAINING_COST, remainingCost);
    }

    public Number getRemainingCost() {
        return (Number)this.get(ResourceField.REMAINING_COST);
    }

    public Number getRemainingOvertimeCost() {
        return (Number)this.get(ResourceField.REMAINING_OVERTIME_COST);
    }

    public void setRemainingOvertimeCost(Number remainingOvertimeCost) {
        this.set((FieldType)ResourceField.REMAINING_OVERTIME_COST, remainingOvertimeCost);
    }

    public void setWorkVariance(Duration workVariance) {
        this.set((FieldType)ResourceField.WORK_VARIANCE, workVariance);
    }

    public Duration getWorkVariance() {
        return (Duration)this.get(ResourceField.WORK_VARIANCE);
    }

    public void setCostVariance(Number costVariance) {
        this.set((FieldType)ResourceField.COST_VARIANCE, costVariance);
    }

    public Number getCostVariance() {
        return (Number)this.get(ResourceField.COST_VARIANCE);
    }

    public void setSV(Number sv) {
        this.set((FieldType)ResourceField.SV, sv);
    }

    public Number getSV() {
        return (Number)this.get(ResourceField.SV);
    }

    public void setCV(Number cv) {
        this.set((FieldType)ResourceField.CV, cv);
    }

    public Number getCV() {
        return (Number)this.get(ResourceField.CV);
    }

    public void setACWP(Number acwp) {
        this.set((FieldType)ResourceField.ACWP, acwp);
    }

    public Number getACWP() {
        return (Number)this.get(ResourceField.ACWP);
    }

    public void setNotes(String notes) {
        this.set((FieldType)ResourceField.NOTES, notes == null ? null : new Notes(notes));
    }

    public String getNotes() {
        Object notes = this.get(ResourceField.NOTES);
        return notes == null ? "" : notes.toString();
    }

    public void setNotesObject(Notes notes) {
        this.set((FieldType)ResourceField.NOTES, notes);
    }

    public Notes getNotesObject() {
        return (Notes)this.get(ResourceField.NOTES);
    }

    public void setBCWS(Number bcws) {
        this.set((FieldType)ResourceField.BCWS, bcws);
    }

    public Number getBCWS() {
        return (Number)this.get(ResourceField.BCWS);
    }

    public void setBCWP(Number bcwp) {
        this.set((FieldType)ResourceField.BCWP, bcwp);
    }

    public Number getBCWP() {
        return (Number)this.get(ResourceField.BCWP);
    }

    public void setGeneric(boolean value) {
        this.set((FieldType)ResourceField.GENERIC, value);
    }

    public boolean getGeneric() {
        return BooleanHelper.getBoolean((Boolean)this.get(ResourceField.GENERIC));
    }

    public void setActive(boolean value) {
        this.set((FieldType)ResourceField.ACTIVE, value);
    }

    public boolean getActive() {
        return BooleanHelper.getBoolean((Boolean)this.get(ResourceField.ACTIVE));
    }

    public void setActiveDirectoryGUID(String guid) {
        this.m_activeDirectoryGUID = guid;
    }

    public String getActiveDirectoryGUID() {
        return this.m_activeDirectoryGUID;
    }

    public void setActualOvertimeWorkProtected(Duration duration) {
        this.set((FieldType)ResourceField.ACTUAL_OVERTIME_WORK_PROTECTED, duration);
    }

    public Duration getActualOvertimeWorkProtected() {
        return (Duration)this.get(ResourceField.ACTUAL_OVERTIME_WORK_PROTECTED);
    }

    public void setActualWorkProtected(Duration duration) {
        this.set((FieldType)ResourceField.ACTUAL_WORK_PROTECTED, duration);
    }

    public Duration getActualWorkProtected() {
        return (Duration)this.get(ResourceField.ACTUAL_WORK_PROTECTED);
    }

    public void setBookingType(BookingType bookingType) {
        this.set((FieldType)ResourceField.BOOKING_TYPE, bookingType);
    }

    public BookingType getBookingType() {
        return (BookingType)this.get(ResourceField.BOOKING_TYPE);
    }

    public void setCreationDate(LocalDateTime creationDate) {
        this.set((FieldType)ResourceField.CREATED, creationDate);
    }

    public LocalDateTime getCreationDate() {
        return (LocalDateTime)this.get(ResourceField.CREATED);
    }

    public void setEnterprise(boolean enterprise) {
        this.set((FieldType)ResourceField.ENTERPRISE, enterprise);
    }

    public boolean getEnterprise() {
        return BooleanHelper.getBoolean((Boolean)this.get(ResourceField.ENTERPRISE));
    }

    public Integer getCalendarUniqueID() {
        return (Integer)this.get(ResourceField.CALENDAR_UNIQUE_ID);
    }

    public void setCalendarUniqueID(Integer id) {
        this.set((FieldType)ResourceField.CALENDAR_UNIQUE_ID, id);
    }

    public ProjectCalendar getCalendar() {
        return (ProjectCalendar)this.getParentFile().getCalendars().getByUniqueID(this.getCalendarUniqueID());
    }

    public void setCalendar(ProjectCalendar calendar) {
        if (calendar == null) {
            this.setCalendarUniqueID(null);
        } else {
            this.setCalendarUniqueID(calendar.getUniqueID());
        }
    }

    public ProjectCalendar addCalendar() throws MPXJException {
        if (this.getCalendar() != null) {
            throw new MPXJException("Maximum number of records of this type exist");
        }
        ProjectCalendar calendar = this.getParentFile().addCalendar();
        String name = this.getName();
        if (name == null || name.isEmpty()) {
            name = "Unnamed Resource";
        }
        calendar.setName(name);
        this.setCalendar(calendar);
        return calendar;
    }

    public void setBaseCalendar(String val) {
        this.set((FieldType)ResourceField.BASE_CALENDAR, val == null || val.isEmpty() ? "Standard" : val);
    }

    public void setBaselineCost(Number val) {
        this.set((FieldType)ResourceField.BASELINE_COST, val);
    }

    public void setBaselineWork(Duration val) {
        this.set((FieldType)ResourceField.BASELINE_WORK, val);
    }

    @Override
    public void setID(Integer val) {
        ProjectFile parent = this.getParentFile();
        Integer previous = this.getID();
        if (previous != null) {
            parent.getResources().unmapID(previous);
        }
        parent.getResources().mapID(val, this);
        this.set((FieldType)ResourceField.ID, val);
    }

    public void setLinkedFields(boolean val) {
        this.set((FieldType)ResourceField.LINKED_FIELDS, val);
    }

    public void setObjects(Integer val) {
        this.set((FieldType)ResourceField.OBJECTS, val);
    }

    public void setText(int index, String value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_TEXT, index), value);
    }

    public String getText(int index) {
        return (String)this.get(this.selectField(ResourceFieldLists.CUSTOM_TEXT, index));
    }

    @Override
    public void setUniqueID(Integer val) {
        this.set((FieldType)ResourceField.UNIQUE_ID, val);
    }

    public String getBaseCalendar() {
        return (String)this.get(ResourceField.BASE_CALENDAR);
    }

    public Number getBaselineCost() {
        return (Number)this.get(ResourceField.BASELINE_COST);
    }

    public Duration getBaselineWork() {
        return (Duration)this.get(ResourceField.BASELINE_WORK);
    }

    @Override
    public Integer getID() {
        return (Integer)this.get(ResourceField.ID);
    }

    public boolean getLinkedFields() {
        return BooleanHelper.getBoolean((Boolean)this.get(ResourceField.LINKED_FIELDS));
    }

    public Integer getObjects() {
        return (Integer)this.get(ResourceField.OBJECTS);
    }

    @Override
    public Integer getUniqueID() {
        return (Integer)this.get(ResourceField.UNIQUE_ID);
    }

    public Integer getParentResourceUniqueID() {
        return (Integer)this.get(ResourceField.PARENT_ID);
    }

    public void setParentResourceUniqueID(Integer id) {
        this.set((FieldType)ResourceField.PARENT_ID, id);
    }

    public Resource getParentResource() {
        return this.getParentFile().getResourceByUniqueID(this.getParentResourceUniqueID());
    }

    public void setParentResource(Resource resource) {
        this.setParentResourceUniqueID(resource == null ? null : resource.getUniqueID());
    }

    public void setStart(int index, LocalDateTime value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_START, index), value);
    }

    public LocalDateTime getStart(int index) {
        return (LocalDateTime)this.get(this.selectField(ResourceFieldLists.CUSTOM_START, index));
    }

    public void setFinish(int index, LocalDateTime value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_FINISH, index), value);
    }

    public LocalDateTime getFinish(int index) {
        return (LocalDateTime)this.get(this.selectField(ResourceFieldLists.CUSTOM_FINISH, index));
    }

    public void setNumber(int index, Number value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_NUMBER, index), value);
    }

    public Number getNumber(int index) {
        return (Number)this.get(this.selectField(ResourceFieldLists.CUSTOM_NUMBER, index));
    }

    public void setDuration(int index, Duration value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_DURATION, index), value);
    }

    public Duration getDuration(int index) {
        return (Duration)this.get(this.selectField(ResourceFieldLists.CUSTOM_DURATION, index));
    }

    public void setDate(int index, LocalDateTime value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_DATE, index), value);
    }

    public LocalDateTime getDate(int index) {
        return (LocalDateTime)this.get(this.selectField(ResourceFieldLists.CUSTOM_DATE, index));
    }

    public void setCost(int index, Number value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_COST, index), value);
    }

    public Number getCost(int index) {
        return (Number)this.get(this.selectField(ResourceFieldLists.CUSTOM_COST, index));
    }

    public void setFlag(int index, boolean value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_FLAG, index), value);
    }

    public boolean getFlag(int index) {
        return BooleanHelper.getBoolean((Boolean)this.get(this.selectField(ResourceFieldLists.CUSTOM_FLAG, index)));
    }

    public void setOutlineCode(int index, String value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_OUTLINE_CODE, index), value);
    }

    public String getOutlineCode(int index) {
        return (String)this.get(this.selectField(ResourceFieldLists.CUSTOM_OUTLINE_CODE, index));
    }

    public void remove() {
        this.getParentFile().removeResource(this);
    }

    public Object getFieldByAlias(String alias) {
        return this.get(this.getParentFile().getResources().getFieldTypeByAlias(alias));
    }

    public void setFieldByAlias(String alias, Object value) {
        this.set(this.getParentFile().getResources().getFieldTypeByAlias(alias), value);
    }

    public void addResourceAssignment(ResourceAssignment assignment) {
        this.m_assignments.add(assignment);
    }

    void removeResourceAssignment(ResourceAssignment assignment) {
        this.m_assignments.remove(assignment);
    }

    public List<ResourceAssignment> getTaskAssignments() {
        return this.m_assignments;
    }

    public void addRoleAssignment(Resource role, SkillLevel skillLevel) {
        this.m_roleAssignments.put(role, skillLevel);
    }

    public void removeRoleAssignment(Resource role) {
        this.m_roleAssignments.remove(role);
    }

    public Map<Resource, SkillLevel> getRoleAssignments() {
        return this.m_roleAssignments;
    }

    public Integer getSubprojectResourceUniqueID() {
        return (Integer)this.get(ResourceField.SUBPROJECT_RESOURCE_UNIQUE_ID);
    }

    public void setSubprojectResourceUniqueID(Integer subprojectUniqueResourceID) {
        this.set((FieldType)ResourceField.SUBPROJECT_RESOURCE_UNIQUE_ID, subprojectUniqueResourceID);
    }

    public Number getEnterpriseCost(int index) {
        return (Number)this.get(this.selectField(ResourceFieldLists.ENTERPRISE_CUSTOM_COST, index));
    }

    public void setEnterpriseCost(int index, Number value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.ENTERPRISE_CUSTOM_COST, index), value);
    }

    public LocalDateTime getEnterpriseDate(int index) {
        return (LocalDateTime)this.get(this.selectField(ResourceFieldLists.ENTERPRISE_CUSTOM_DATE, index));
    }

    public void setEnterpriseDate(int index, LocalDateTime value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.ENTERPRISE_CUSTOM_DATE, index), value);
    }

    public Duration getEnterpriseDuration(int index) {
        return (Duration)this.get(this.selectField(ResourceFieldLists.ENTERPRISE_CUSTOM_DURATION, index));
    }

    public void setEnterpriseDuration(int index, Duration value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.ENTERPRISE_CUSTOM_DURATION, index), value);
    }

    public boolean getEnterpriseFlag(int index) {
        return BooleanHelper.getBoolean((Boolean)this.get(this.selectField(ResourceFieldLists.ENTERPRISE_CUSTOM_FLAG, index)));
    }

    public void setEnterpriseFlag(int index, boolean value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.ENTERPRISE_CUSTOM_FLAG, index), value);
    }

    public Number getEnterpriseNumber(int index) {
        return (Number)this.get(this.selectField(ResourceFieldLists.ENTERPRISE_CUSTOM_NUMBER, index));
    }

    public void setEnterpriseNumber(int index, Number value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.ENTERPRISE_CUSTOM_NUMBER, index), value);
    }

    public String getEnterpriseText(int index) {
        return (String)this.get(this.selectField(ResourceFieldLists.ENTERPRISE_CUSTOM_TEXT, index));
    }

    public void setEnterpriseText(int index, String value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.ENTERPRISE_CUSTOM_TEXT, index), value);
    }

    public void setBaselineCost(int baselineNumber, Number value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.BASELINE_COSTS, baselineNumber), value);
    }

    public void setBaselineWork(int baselineNumber, Duration value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.BASELINE_WORKS, baselineNumber), value);
    }

    public Number getBaselineCost(int baselineNumber) {
        return (Number)this.get(this.selectField(ResourceFieldLists.BASELINE_COSTS, baselineNumber));
    }

    public Duration getBaselineWork(int baselineNumber) {
        return (Duration)this.get(this.selectField(ResourceFieldLists.BASELINE_WORKS, baselineNumber));
    }

    public boolean getBudget() {
        return BooleanHelper.getBoolean((Boolean)this.get(ResourceField.BUDGET));
    }

    public void setBudget(boolean budget) {
        this.set((FieldType)ResourceField.BUDGET, budget);
    }

    public UUID getGUID() {
        return (UUID)this.get(ResourceField.GUID);
    }

    public void setUnit(String value) {
        this.set((FieldType)ResourceField.UNIT, value);
    }

    public String getUnit() {
        return (String)this.get(ResourceField.UNIT);
    }

    public void setSupplyReference(String value) {
        this.set((FieldType)ResourceField.SUPPLY_REFERENCE, value);
    }

    public String getSupplyReference() {
        return (String)this.get(ResourceField.SUPPLY_REFERENCE);
    }

    public void setDescription(String value) {
        this.set((FieldType)ResourceField.DESCRIPTION, value);
    }

    public String getDescription() {
        return (String)this.get(ResourceField.DESCRIPTION);
    }

    public void setResourceID(String value) {
        this.set((FieldType)ResourceField.RESOURCE_ID, value);
    }

    public String getResourceID() {
        return (String)this.get(ResourceField.RESOURCE_ID);
    }

    public void setModifyOnIntegrate(boolean value) {
        this.set((FieldType)ResourceField.MODIFY_ON_INTEGRATE, value);
    }

    public boolean getModifyOnIntegrate() {
        return BooleanHelper.getBoolean((Boolean)this.get(ResourceField.MODIFY_ON_INTEGRATE));
    }

    public void setExpensesOnly(boolean value) {
        this.set((FieldType)ResourceField.EXPENSES_ONLY, value);
    }

    public boolean getExpensesOnly() {
        return BooleanHelper.getBoolean((Boolean)this.get(ResourceField.EXPENSES_ONLY));
    }

    public void setPeriodDur(Number value) {
        this.set((FieldType)ResourceField.PERIOD_DUR, value);
    }

    public Number getPeriodDur() {
        return (Number)this.get(ResourceField.PERIOD_DUR);
    }

    public void setPriority(Number value) {
        this.set((FieldType)ResourceField.PRIORITY, value);
    }

    public Number getPriority() {
        return (Number)this.get(ResourceField.PRIORITY);
    }

    public void setRate(Number value) {
        this.set((FieldType)ResourceField.RATE, value);
    }

    public Number getRate() {
        return (Number)this.get(ResourceField.RATE);
    }

    public void setPool(Number value) {
        this.set((FieldType)ResourceField.POOL, value);
    }

    public Number getPool() {
        return (Number)this.get(ResourceField.POOL);
    }

    public void setPerDay(Number value) {
        this.set((FieldType)ResourceField.PER_DAY, value);
    }

    public Number getPerDay() {
        return (Number)this.get(ResourceField.PER_DAY);
    }

    public void setPhone(String value) {
        this.set((FieldType)ResourceField.PHONE, value);
    }

    public String getPhone() {
        return (String)this.get(ResourceField.PHONE);
    }

    public void setRole(boolean value) {
        this.set((FieldType)ResourceField.ROLE, value);
    }

    public boolean getRole() {
        return BooleanHelper.getBoolean((Boolean)this.get(ResourceField.ROLE));
    }

    public void setGUID(UUID value) {
        this.set((FieldType)ResourceField.GUID, value);
    }

    public void setCostRateTable(int index, CostRateTable crt) {
        this.m_costRateTables[index] = crt;
    }

    public CostRateTable getCostRateTable(int index) {
        return index < 0 || index >= 5 ? null : this.m_costRateTables[index];
    }

    public CostRateTableEntry getCurrentCostRateTableEntry(int costRateTable) {
        return this.getCostRateTable(costRateTable).getEntryByDate(LocalDateTime.now());
    }

    public AvailabilityTable getAvailability() {
        return this.m_availability;
    }

    public Availability getCurrentAvailabilityTableEntry() {
        return this.m_availability.getEntryByDate(LocalDateTime.now());
    }

    public Number getBudgetCost() {
        return (Number)this.get(ResourceField.BUDGET_COST);
    }

    public void setBudgetCost(Number value) {
        this.set((FieldType)ResourceField.BUDGET_COST, value);
    }

    public Duration getBudgetWork() {
        return (Duration)this.get(ResourceField.BUDGET_WORK);
    }

    public void setBudgetWork(Duration value) {
        this.set((FieldType)ResourceField.BUDGET_WORK, value);
    }

    public Number getBaselineBudgetCost() {
        return (Number)this.get(ResourceField.BASELINE_BUDGET_COST);
    }

    public void setBaselineBudgetCost(Number value) {
        this.set((FieldType)ResourceField.BASELINE_BUDGET_COST, value);
    }

    public Duration getBaselineBudgetWork() {
        return (Duration)this.get(ResourceField.BASELINE_BUDGET_WORK);
    }

    public void setBaselineBudgetWork(Duration value) {
        this.set((FieldType)ResourceField.BASELINE_BUDGET_WORK, value);
    }

    public Number getBaselineBudgetCost(int baselineNumber) {
        return (Number)this.get(this.selectField(ResourceFieldLists.BASELINE_BUDGET_COSTS, baselineNumber));
    }

    public void setBaselineBudgetCost(int baselineNumber, Number value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.BASELINE_BUDGET_COSTS, baselineNumber), value);
    }

    public Duration getBaselineBudgetWork(int baselineNumber) {
        return (Duration)this.get(this.selectField(ResourceFieldLists.BASELINE_BUDGET_WORKS, baselineNumber));
    }

    public void setBaselineBudgetWork(int baselineNumber, Duration value) {
        this.set((FieldType)this.selectField(ResourceFieldLists.BASELINE_BUDGET_WORKS, baselineNumber), value);
    }

    public String getCostCenter() {
        return (String)this.get(ResourceField.COST_CENTER);
    }

    public void setCostCenter(String value) {
        this.set((FieldType)ResourceField.COST_CENTER, value);
    }

    public boolean getCalculateCostsFromUnits() {
        return BooleanHelper.getBoolean((Boolean)this.get(ResourceField.CALCULATE_COSTS_FROM_UNITS));
    }

    public void setCalculateCostsFromUnits(boolean calculateCostsFromUnits) {
        this.set((FieldType)ResourceField.CALCULATE_COSTS_FROM_UNITS, calculateCostsFromUnits);
    }

    public Integer getSequenceNumber() {
        return (Integer)this.get(ResourceField.SEQUENCE_NUMBER);
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.set((FieldType)ResourceField.SEQUENCE_NUMBER, sequenceNumber);
    }

    public Integer getLocationUniqueID() {
        return (Integer)this.get(ResourceField.LOCATION_UNIQUE_ID);
    }

    public void setLocationUniqueID(Integer uniqueID) {
        this.set((FieldType)ResourceField.LOCATION_UNIQUE_ID, uniqueID);
    }

    public Location getLocation() {
        return (Location)this.getParentFile().getLocations().getByUniqueID(this.getLocationUniqueID());
    }

    public void setLocation(Location location) {
        this.setLocationUniqueID(location == null ? null : location.getUniqueID());
    }

    public Integer getShiftUniqueID() {
        return (Integer)this.get(ResourceField.SHIFT_UNIQUE_ID);
    }

    public void setShiftUniqueID(Integer uniqueID) {
        this.set((FieldType)ResourceField.SHIFT_UNIQUE_ID, uniqueID);
    }

    public Shift getShift() {
        return (Shift)this.getParentFile().getShifts().getByUniqueID(this.getShiftUniqueID());
    }

    public void setShift(Shift shift) {
        this.setShiftUniqueID(shift == null ? null : shift.getUniqueID());
    }

    public Integer getUnitOfMeasureUniqueID() {
        return (Integer)this.get(ResourceField.UNIT_OF_MEASURE_UNIQUE_ID);
    }

    public void setUnitOfMeasureUniqueID(Integer uniqueID) {
        this.set((FieldType)ResourceField.UNIT_OF_MEASURE_UNIQUE_ID, uniqueID);
    }

    public UnitOfMeasure getUnitOfMeasure() {
        return (UnitOfMeasure)this.getParentFile().getUnitsOfMeasure().getByUniqueID(this.getUnitOfMeasureUniqueID());
    }

    public void setUnitOfMeasure(UnitOfMeasure unitOfMeasure) {
        this.setUnitOfMeasureUniqueID(unitOfMeasure == null ? null : unitOfMeasure.getUniqueID());
    }

    public Integer getPrimaryRoleUniqueID() {
        return (Integer)this.get(ResourceField.PRIMARY_ROLE_UNIQUE_ID);
    }

    public void setPrimaryRoleUniqueID(Integer uniqueID) {
        this.set((FieldType)ResourceField.PRIMARY_ROLE_UNIQUE_ID, uniqueID);
    }

    public Resource getPrimaryRole() {
        return (Resource)this.getParentFile().getResources().getByUniqueID(this.getPrimaryRoleUniqueID());
    }

    public void setPrimaryRole(Resource role) {
        this.setPrimaryRoleUniqueID(role == null ? null : role.getUniqueID());
    }

    public Map<ResourceCode, ResourceCodeValue> getResourceCodeValues() {
        return (Map)this.get(ResourceField.RESOURCE_CODE_VALUES);
    }

    public void addResourceCodeValue(ResourceCodeValue value) {
        ((Map)this.get(ResourceField.RESOURCE_CODE_VALUES)).put(value.getParentCode(), value);
    }

    public Map<RoleCode, RoleCodeValue> getRoleCodeValues() {
        return (Map)this.get(ResourceField.ROLE_CODE_VALUES);
    }

    public void addRoleCodeValue(RoleCodeValue value) {
        ((Map)this.get(ResourceField.ROLE_CODE_VALUES)).put(value.getParentCode(), value);
    }

    public Integer getCurrencyUniqueID() {
        return (Integer)this.get(ResourceField.CURRENCY_UNIQUE_ID);
    }

    public void setCurrencyUniqueID(Integer uniqueID) {
        this.set((FieldType)ResourceField.CURRENCY_UNIQUE_ID, uniqueID);
    }

    public Currency getCurrency() {
        return (Currency)this.getParentFile().getCurrencies().getByUniqueID(this.getCurrencyUniqueID());
    }

    public void setCurrency(Currency currency) {
        this.setCurrencyUniqueID(currency == null ? null : currency.getUniqueID());
    }

    private ResourceField selectField(ResourceField[] fields, int index) {
        if (index < 1 || index > fields.length) {
            throw new IllegalArgumentException(index + " is not a valid field index");
        }
        return fields[index - 1];
    }

    @Override
    protected void handleFieldChange(FieldType field, Object oldValue, Object newValue) {
        if (field == ResourceField.UNIQUE_ID) {
            this.getParentFile().getResources().updateUniqueID(this, (Integer)oldValue, (Integer)newValue);
            if (!this.m_assignments.isEmpty()) {
                for (ResourceAssignment assignment : this.m_assignments) {
                    assignment.setResourceUniqueID((Integer)newValue);
                }
            }
            return;
        }
        this.clearDependentFields(DEPENDENCY_MAP, field);
    }

    @Override
    protected boolean getAlwaysCalculatedField(FieldType field) {
        return ALWAYS_CALCULATED_FIELDS.contains(field);
    }

    @Override
    protected Function<Resource, Object> getCalculationMethod(FieldType field) {
        return CALCULATED_FIELD_MAP.get(field);
    }

    private void set(FieldType field, boolean value) {
        this.set(field, value ? Boolean.TRUE : Boolean.FALSE);
    }

    private Double calculateCostVariance() {
        Double variance = null;
        Number cost = this.getCost();
        Number baselineCost = this.getBaselineCost();
        if (cost != null && baselineCost != null) {
            variance = NumberHelper.getDouble(cost.doubleValue() - baselineCost.doubleValue());
        }
        return variance;
    }

    private Duration calculateWorkVariance() {
        Duration variance = null;
        Duration work = this.getWork();
        Duration baselineWork = this.getBaselineWork();
        if (work != null && baselineWork != null) {
            variance = Duration.getInstance(work.getDuration() - baselineWork.convertUnits(work.getUnits(), this.getParentFile().getProjectProperties()).getDuration(), work.getUnits());
        }
        return variance;
    }

    private Double calculateCV() {
        return NumberHelper.getDouble(this.getBCWP()) - NumberHelper.getDouble(this.getACWP());
    }

    private Boolean calculateOverallocated() {
        Number peakUnits = this.getPeakUnits();
        Number maxUnits = this.getMaxUnits();
        return NumberHelper.getDouble(peakUnits) > NumberHelper.getDouble(maxUnits);
    }

    private ResourceType defaultType() {
        return ResourceType.WORK;
    }

    private Boolean defaultRoleFlag() {
        return Boolean.FALSE;
    }

    private Boolean defaultCalculateCostsFromUnits() {
        return Boolean.TRUE;
    }

    private Boolean defaultActive() {
        return Boolean.TRUE;
    }

    private Number defaultDefaultUnits() {
        return DEFAULT_DEFAULT_UNITS;
    }

    private Map<ResourceCode, ResourceCodeValue> defaultResourceCodeValues() {
        return new HashMap<ResourceCode, ResourceCodeValue>();
    }

    private Map<RoleCode, RoleCodeValue> defaultRoleCodeValues() {
        return new HashMap<RoleCode, RoleCodeValue>();
    }

    private Double calculateSV() {
        Double variance = null;
        Number bcwp = this.getBCWP();
        Number bcws = this.getBCWS();
        if (bcwp != null && bcws != null) {
            variance = NumberHelper.getDouble(bcwp.doubleValue() - bcws.doubleValue());
        }
        return variance;
    }

    private Rate calculateStandardRate() {
        CostRateTableEntry entry = this.getCurrentCostRateTableEntry(0);
        if (entry == null) {
            return null;
        }
        return entry.getStandardRate();
    }

    private Rate calculateOvertimeRate() {
        CostRateTableEntry entry = this.getCurrentCostRateTableEntry(0);
        if (entry == null) {
            return null;
        }
        return entry.getOvertimeRate();
    }

    private Number calculateCostPerUse() {
        CostRateTableEntry entry = this.getCurrentCostRateTableEntry(0);
        if (entry == null) {
            return null;
        }
        return entry.getCostPerUse();
    }

    private String calculateMaterialLabel() {
        UnitOfMeasure uom = this.getUnitOfMeasure();
        return uom == null ? null : uom.getAbbreviation();
    }

    private LocalDateTime calculateStart() {
        return this.m_assignments.stream().map(ResourceAssignment::getStart).filter(Objects::nonNull).min(Comparator.naturalOrder()).orElse(null);
    }

    private LocalDateTime calculateFinish() {
        return this.m_assignments.stream().map(ResourceAssignment::getFinish).filter(Objects::nonNull).max(Comparator.naturalOrder()).orElse(null);
    }

    private Number calculateMaxUnits() {
        Availability entry = this.getCurrentAvailabilityTableEntry();
        return entry == null ? (Number)null : (Number)entry.getUnits();
    }

    private LocalDateTime calculateAvailableFrom() {
        return this.m_availability.availableFrom(LocalDateTime.now());
    }

    private LocalDateTime calculateAvailableTo() {
        return this.m_availability.availableTo(LocalDateTime.now());
    }

    @Override
    public int compareTo(Resource o) {
        int id1 = NumberHelper.getInt(this.getID());
        int id2 = NumberHelper.getInt(o.getID());
        return Integer.compare(id1, id2);
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof Resource) {
            result = this.compareTo((Resource)o) == 0;
        }
        return result;
    }

    public int hashCode() {
        return NumberHelper.getInt(this.getID());
    }

    public String toString() {
        return "[Resource id=" + this.getID() + " uniqueID=" + this.getUniqueID() + " name=" + this.getName() + "]";
    }

    static {
        CALCULATED_FIELD_MAP.put(ResourceField.COST_VARIANCE, Resource::calculateCostVariance);
        CALCULATED_FIELD_MAP.put(ResourceField.WORK_VARIANCE, Resource::calculateWorkVariance);
        CALCULATED_FIELD_MAP.put(ResourceField.CV, Resource::calculateCV);
        CALCULATED_FIELD_MAP.put(ResourceField.SV, Resource::calculateSV);
        CALCULATED_FIELD_MAP.put(ResourceField.OVERALLOCATED, Resource::calculateOverallocated);
        CALCULATED_FIELD_MAP.put(ResourceField.STANDARD_RATE, Resource::calculateStandardRate);
        CALCULATED_FIELD_MAP.put(ResourceField.OVERTIME_RATE, Resource::calculateOvertimeRate);
        CALCULATED_FIELD_MAP.put(ResourceField.COST_PER_USE, Resource::calculateCostPerUse);
        CALCULATED_FIELD_MAP.put(ResourceField.MATERIAL_LABEL, Resource::calculateMaterialLabel);
        CALCULATED_FIELD_MAP.put(ResourceField.MAX_UNITS, Resource::calculateMaxUnits);
        CALCULATED_FIELD_MAP.put(ResourceField.AVAILABLE_FROM, Resource::calculateAvailableFrom);
        CALCULATED_FIELD_MAP.put(ResourceField.AVAILABLE_TO, Resource::calculateAvailableTo);
        CALCULATED_FIELD_MAP.put(ResourceField.START, Resource::calculateStart);
        CALCULATED_FIELD_MAP.put(ResourceField.FINISH, Resource::calculateFinish);
        CALCULATED_FIELD_MAP.put(ResourceField.TYPE, Resource::defaultType);
        CALCULATED_FIELD_MAP.put(ResourceField.ROLE, Resource::defaultRoleFlag);
        CALCULATED_FIELD_MAP.put(ResourceField.CALCULATE_COSTS_FROM_UNITS, Resource::defaultCalculateCostsFromUnits);
        CALCULATED_FIELD_MAP.put(ResourceField.ACTIVE, Resource::defaultActive);
        CALCULATED_FIELD_MAP.put(ResourceField.DEFAULT_UNITS, Resource::defaultDefaultUnits);
        CALCULATED_FIELD_MAP.put(ResourceField.RESOURCE_CODE_VALUES, Resource::defaultResourceCodeValues);
        CALCULATED_FIELD_MAP.put(ResourceField.ROLE_CODE_VALUES, Resource::defaultRoleCodeValues);
        DEPENDENCY_MAP = new HashMap<FieldType, List<FieldType>>();
        FieldContainerDependencies<FieldType> dependencies = new FieldContainerDependencies<FieldType>(DEPENDENCY_MAP);
        dependencies.calculatedField(ResourceField.COST_VARIANCE).dependsOn((FieldType[])new FieldType[]{ResourceField.COST, ResourceField.BASELINE_COST});
        dependencies.calculatedField(ResourceField.CV).dependsOn((FieldType[])new FieldType[]{ResourceField.BCWP, ResourceField.ACWP});
        dependencies.calculatedField(ResourceField.SV).dependsOn((FieldType[])new FieldType[]{ResourceField.BCWP, ResourceField.BCWS});
        dependencies.calculatedField(ResourceField.OVERALLOCATED).dependsOn((FieldType[])new FieldType[]{ResourceField.PEAK, ResourceField.MAX_UNITS});
        dependencies.calculatedField(ResourceField.MATERIAL_LABEL).dependsOn((FieldType[])new FieldType[]{ResourceField.UNIT_OF_MEASURE_UNIQUE_ID});
        DEFAULT_DEFAULT_UNITS = 100.0;
    }
}

