/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.util.List;
import java.util.stream.Collectors;
import org.mpxj.CodeValue;
import org.mpxj.ResourceAssignmentCode;
import org.mpxj.UniqueIdObjectSequenceProvider;

public final class ResourceAssignmentCodeValue
implements CodeValue {
    private final ResourceAssignmentCode m_resourceAssignmentCode;
    private final Integer m_uniqueID;
    private final Integer m_sequenceNumber;
    private final String m_name;
    private final String m_description;
    private final ResourceAssignmentCodeValue m_parentValue;

    private ResourceAssignmentCodeValue(Builder builder) {
        this.m_uniqueID = builder.m_sequenceProvider.getUniqueIdObjectSequence(ResourceAssignmentCodeValue.class).syncOrGetNext(builder.m_uniqueID);
        this.m_resourceAssignmentCode = builder.m_resourceAssignmentCode;
        this.m_sequenceNumber = builder.m_sequenceNumber;
        this.m_name = builder.m_name;
        this.m_description = builder.m_description;
        this.m_parentValue = builder.m_parentValue;
    }

    @Override
    public ResourceAssignmentCode getParentCode() {
        return this.m_resourceAssignmentCode;
    }

    @Override
    public Integer getParentCodeUniqueID() {
        return this.m_resourceAssignmentCode == null ? null : this.m_resourceAssignmentCode.getUniqueID();
    }

    @Override
    public Integer getUniqueID() {
        return this.m_uniqueID;
    }

    @Override
    public Integer getSequenceNumber() {
        return this.m_sequenceNumber;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    public ResourceAssignmentCodeValue getParentValue() {
        return this.m_parentValue;
    }

    @Override
    public Integer getParentValueUniqueID() {
        return this.m_parentValue == null ? null : this.m_parentValue.getUniqueID();
    }

    public List<ResourceAssignmentCodeValue> getChildValues() {
        return this.m_resourceAssignmentCode.getValues().stream().filter(a -> a.m_parentValue == this).collect(Collectors.toList());
    }

    public String toString() {
        return this.m_resourceAssignmentCode.getName() + ": " + this.m_name;
    }

    public static class Builder {
        private final UniqueIdObjectSequenceProvider m_sequenceProvider;
        private ResourceAssignmentCode m_resourceAssignmentCode;
        private Integer m_uniqueID;
        private Integer m_sequenceNumber;
        private String m_name;
        private String m_description;
        private ResourceAssignmentCodeValue m_parentValue;

        public Builder(UniqueIdObjectSequenceProvider sequenceProvider) {
            this.m_sequenceProvider = sequenceProvider;
        }

        public Builder from(ResourceAssignmentCodeValue value) {
            this.m_resourceAssignmentCode = value.m_resourceAssignmentCode;
            this.m_uniqueID = value.m_uniqueID;
            this.m_sequenceNumber = value.m_sequenceNumber;
            this.m_name = value.m_name;
            this.m_description = value.m_description;
            this.m_parentValue = value.m_parentValue;
            return this;
        }

        public Builder resourceAssignmentCode(ResourceAssignmentCode value) {
            this.m_resourceAssignmentCode = value;
            return this;
        }

        public Builder uniqueID(Integer value) {
            this.m_uniqueID = value;
            return this;
        }

        public Builder sequenceNumber(Integer value) {
            this.m_sequenceNumber = value;
            return this;
        }

        public Builder name(String value) {
            this.m_name = value;
            return this;
        }

        public Builder description(String value) {
            this.m_description = value;
            return this;
        }

        public Builder parentValue(ResourceAssignmentCodeValue value) {
            this.m_parentValue = value;
            return this;
        }

        public ResourceAssignmentCodeValue build() {
            return new ResourceAssignmentCodeValue(this);
        }
    }
}

