/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.util.List;
import java.util.Set;
import org.mpxj.AssignmentField;
import org.mpxj.CustomField;
import org.mpxj.FieldType;
import org.mpxj.FieldTypeClass;
import org.mpxj.ProjectEntityContainer;
import org.mpxj.ProjectFile;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignment;
import org.mpxj.common.PopulatedFields;

public class ResourceAssignmentContainer
extends ProjectEntityContainer<ResourceAssignment> {
    private final ProjectFile m_projectFile;

    public ResourceAssignmentContainer(ProjectFile projectFile) {
        super(projectFile);
        this.m_projectFile = projectFile;
    }

    @Override
    public void removed(ResourceAssignment assignment) {
        super.removed(assignment);
        assignment.getTask().removeResourceAssignment(assignment);
        Resource resource = assignment.getResource();
        if (resource != null) {
            resource.removeResourceAssignment(assignment);
        }
    }

    public Set<FieldType> getPopulatedFields() {
        return new PopulatedFields<AssignmentField, ResourceAssignment>(this.m_projectFile, AssignmentField.class, this.m_projectFile.getUserDefinedFields().getAssignmentFields(), this).getPopulatedFields();
    }

    public List<CustomField> getCustomFields() {
        return this.m_projectFile.getCustomFields().getCustomFieldsByFieldTypeClass(FieldTypeClass.ASSIGNMENT);
    }

    public FieldType getFieldTypeByAlias(String alias) {
        return this.m_projectFile.getCustomFields().getFieldTypeByAlias(FieldTypeClass.ASSIGNMENT, alias);
    }
}

