/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.util.List;
import java.util.stream.Collectors;
import org.mpxj.CodeValue;
import org.mpxj.ResourceCode;
import org.mpxj.UniqueIdObjectSequenceProvider;

public final class ResourceCodeValue
implements CodeValue {
    private final ResourceCode m_resourceCode;
    private final Integer m_uniqueID;
    private final Integer m_sequenceNumber;
    private final String m_name;
    private final String m_description;
    private final ResourceCodeValue m_parentValue;

    private ResourceCodeValue(Builder builder) {
        this.m_uniqueID = builder.m_sequenceProvider.getUniqueIdObjectSequence(ResourceCodeValue.class).syncOrGetNext(builder.m_uniqueID);
        this.m_resourceCode = builder.m_resourceCode;
        this.m_sequenceNumber = builder.m_sequenceNumber;
        this.m_name = builder.m_name;
        this.m_description = builder.m_description;
        this.m_parentValue = builder.m_parentValue;
    }

    @Override
    public ResourceCode getParentCode() {
        return this.m_resourceCode;
    }

    @Override
    public Integer getParentCodeUniqueID() {
        return this.m_resourceCode == null ? null : this.m_resourceCode.getUniqueID();
    }

    @Override
    public Integer getUniqueID() {
        return this.m_uniqueID;
    }

    @Override
    public Integer getSequenceNumber() {
        return this.m_sequenceNumber;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    public ResourceCodeValue getParentValue() {
        return this.m_parentValue;
    }

    @Override
    public Integer getParentValueUniqueID() {
        return this.m_parentValue == null ? null : this.m_parentValue.getUniqueID();
    }

    public List<ResourceCodeValue> getChildValues() {
        return this.m_resourceCode.getValues().stream().filter(a -> a.m_parentValue == this).collect(Collectors.toList());
    }

    public String toString() {
        return this.m_resourceCode.getName() + ": " + this.m_name;
    }

    public static class Builder {
        private final UniqueIdObjectSequenceProvider m_sequenceProvider;
        private ResourceCode m_resourceCode;
        private Integer m_uniqueID;
        private Integer m_sequenceNumber;
        private String m_name;
        private String m_description;
        private ResourceCodeValue m_parentValue;

        public Builder(UniqueIdObjectSequenceProvider sequenceProvider) {
            this.m_sequenceProvider = sequenceProvider;
        }

        public Builder from(ResourceCodeValue value) {
            this.m_resourceCode = value.m_resourceCode;
            this.m_uniqueID = value.m_uniqueID;
            this.m_sequenceNumber = value.m_sequenceNumber;
            this.m_name = value.m_name;
            this.m_description = value.m_description;
            this.m_parentValue = value.m_parentValue;
            return this;
        }

        public Builder resourceCode(ResourceCode value) {
            this.m_resourceCode = value;
            return this;
        }

        public Builder uniqueID(Integer value) {
            this.m_uniqueID = value;
            return this;
        }

        public Builder sequenceNumber(Integer value) {
            this.m_sequenceNumber = value;
            return this;
        }

        public Builder name(String value) {
            this.m_name = value;
            return this;
        }

        public Builder description(String value) {
            this.m_description = value;
            return this;
        }

        public Builder parentValue(ResourceCodeValue value) {
            this.m_parentValue = value;
            return this;
        }

        public ResourceCodeValue build() {
            return new ResourceCodeValue(this);
        }
    }
}

