/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import org.mpxj.Notes;
import org.mpxj.Task;
import org.mpxj.common.NumberHelper;

public final class Step {
    private final Task m_task;
    private final Integer m_uniqueID;
    private final String m_name;
    private final Double m_percentComplete;
    private final Integer m_sequenceNumber;
    private final Double m_weight;
    private final Notes m_description;

    private Step(Builder builder) {
        this.m_task = builder.m_task;
        this.m_uniqueID = this.m_task.getParentFile().getUniqueIdObjectSequence(Step.class).syncOrGetNext(builder.m_uniqueID);
        this.m_name = builder.m_name;
        this.m_percentComplete = builder.m_percentComplete;
        this.m_sequenceNumber = builder.m_sequenceNumber;
        this.m_weight = builder.m_weight;
        this.m_description = builder.m_description;
    }

    public Task getTask() {
        return this.m_task;
    }

    public Integer getUniqueID() {
        return this.m_uniqueID;
    }

    public String getName() {
        return this.m_name;
    }

    public Double getPercentComplete() {
        return this.m_percentComplete;
    }

    public Integer getSequenceNumber() {
        return this.m_sequenceNumber;
    }

    public Double getWeight() {
        return this.m_weight;
    }

    public String getDescription() {
        return this.m_description == null ? "" : this.m_description.toString();
    }

    public Notes getDescriptionObject() {
        return this.m_description;
    }

    public boolean getComplete() {
        return NumberHelper.getDouble(this.m_percentComplete) == 100.0;
    }

    public static class Builder {
        private final Task m_task;
        private Integer m_uniqueID;
        private String m_name;
        private Double m_percentComplete;
        private Integer m_sequenceNumber;
        private Double m_weight;
        private Notes m_description;

        public Builder(Task task) {
            this.m_task = task;
        }

        public Builder from(Step value) {
            this.m_uniqueID = value.m_uniqueID;
            this.m_name = value.m_name;
            this.m_percentComplete = value.m_percentComplete;
            this.m_sequenceNumber = value.m_sequenceNumber;
            this.m_weight = value.m_weight;
            this.m_description = value.m_description;
            return this;
        }

        public Builder uniqueID(Integer value) {
            this.m_uniqueID = value;
            return this;
        }

        public Builder name(String value) {
            this.m_name = value;
            return this;
        }

        public Builder percentComplete(Double value) {
            this.m_percentComplete = value;
            return this;
        }

        public Builder sequenceNumber(Integer value) {
            this.m_sequenceNumber = value;
            return this;
        }

        public Builder weight(Double value) {
            this.m_weight = value;
            return this;
        }

        public Builder description(Notes value) {
            this.m_description = value;
            return this;
        }

        public Builder description(String value) {
            this.m_description = value == null ? null : new Notes(value);
            return this;
        }

        public Step build() {
            return new Step(this);
        }
    }
}

