/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import org.mpxj.MpxjEnum;
import org.mpxj.common.EnumHelper;
import org.mpxj.common.NumberHelper;

public enum TestOperator implements MpxjEnum
{
    IS_ANY_VALUE(0){

        @Override
        public boolean evaluate(Object lhs, Object rhs) {
            return true;
        }
    }
    ,
    IS_WITHIN(1){

        @Override
        public boolean evaluate(Object lhs, Object rhs) {
            return this.evaluateWithin(lhs, rhs);
        }
    }
    ,
    IS_GREATER_THAN(2){

        @Override
        public boolean evaluate(Object lhs, Object rhs) {
            return this.evaluateCompareTo(lhs, rhs) > 0;
        }
    }
    ,
    IS_LESS_THAN(3){

        @Override
        public boolean evaluate(Object lhs, Object rhs) {
            return this.evaluateCompareTo(lhs, rhs) < 0;
        }
    }
    ,
    IS_GREATER_THAN_OR_EQUAL_TO(4){

        @Override
        public boolean evaluate(Object lhs, Object rhs) {
            return this.evaluateCompareTo(lhs, rhs) >= 0;
        }
    }
    ,
    IS_LESS_THAN_OR_EQUAL_TO(5){

        @Override
        public boolean evaluate(Object lhs, Object rhs) {
            return this.evaluateCompareTo(lhs, rhs) <= 0;
        }
    }
    ,
    EQUALS(6){

        @Override
        public boolean evaluate(Object lhs, Object rhs) {
            boolean result = lhs == null ? this.getSingleOperand(rhs) == null : lhs.equals(this.getSingleOperand(rhs));
            return result;
        }
    }
    ,
    DOES_NOT_EQUAL(7){

        @Override
        public boolean evaluate(Object lhs, Object rhs) {
            boolean result = lhs == null ? this.getSingleOperand(rhs) != null : !lhs.equals(this.getSingleOperand(rhs));
            return result;
        }
    }
    ,
    CONTAINS(8){

        @Override
        public boolean evaluate(Object lhs, Object rhs) {
            return this.evaluateContains(lhs, rhs);
        }
    }
    ,
    IS_NOT_WITHIN(9){

        @Override
        public boolean evaluate(Object lhs, Object rhs) {
            return !this.evaluateWithin(lhs, rhs);
        }
    }
    ,
    DOES_NOT_CONTAIN(10){

        @Override
        public boolean evaluate(Object lhs, Object rhs) {
            return !this.evaluateContains(lhs, rhs);
        }
    }
    ,
    CONTAINS_EXACTLY(11){

        @Override
        public boolean evaluate(Object lhs, Object rhs) {
            return this.evaluateContainsExactly(lhs, rhs);
        }
    }
    ,
    AND(12){

        @Override
        public boolean evaluate(Object lhs, Object rhs) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    OR(13){

        @Override
        public boolean evaluate(Object lhs, Object rhs) {
            throw new UnsupportedOperationException();
        }
    };

    private static final TestOperator[] TYPE_VALUES;
    private final int m_value;

    private TestOperator(int type) {
        this.m_value = type;
    }

    public static TestOperator getInstance(int type) {
        if (type < 0 || type >= TYPE_VALUES.length) {
            type = IS_ANY_VALUE.getValue();
        }
        return TYPE_VALUES[type];
    }

    public static TestOperator getInstance(Number type) {
        int value = type == null ? -1 : NumberHelper.getInt(type);
        return TestOperator.getInstance(value);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    public abstract boolean evaluate(Object var1, Object var2);

    protected Object getSingleOperand(Object operand) {
        if (operand instanceof Object[]) {
            Object[] list = (Object[])operand;
            operand = list[0];
        }
        return operand;
    }

    protected boolean evaluateWithin(Object lhs, Object rhs) {
        boolean result = false;
        if (rhs instanceof Object[]) {
            Object[] rhsList = (Object[])rhs;
            if (lhs != null) {
                Comparable lhsComparable = (Comparable)lhs;
                if (rhsList[0] != null && rhsList[1] != null) {
                    result = lhsComparable.compareTo(rhsList[0]) >= 0 && lhsComparable.compareTo(rhsList[1]) <= 0 || lhsComparable.compareTo(rhsList[0]) <= 0 && lhsComparable.compareTo(rhsList[1]) >= 0;
                }
            } else {
                result = rhsList[0] == null || rhsList[1] == null;
            }
        }
        return result;
    }

    protected int evaluateCompareTo(Object lhs, Object rhs) {
        rhs = this.getSingleOperand(rhs);
        int result = lhs == null || rhs == null ? (lhs == rhs ? 0 : (lhs == null ? 1 : -1)) : ((Comparable)lhs).compareTo(rhs);
        return result;
    }

    protected boolean evaluateContains(Object lhs, Object rhs) {
        boolean result = false;
        rhs = this.getSingleOperand(rhs);
        if (lhs instanceof String && rhs instanceof String) {
            result = ((String)lhs).toUpperCase().contains(((String)rhs).toUpperCase());
        }
        return result;
    }

    protected boolean evaluateContainsExactly(Object lhs, Object rhs) {
        boolean result = false;
        rhs = this.getSingleOperand(rhs);
        if (lhs instanceof String && rhs instanceof String) {
            result = ((String)lhs).contains((String)rhs);
        }
        return result;
    }

    static {
        TYPE_VALUES = (TestOperator[])EnumHelper.createTypeArray(TestOperator.class);
    }
}

