/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import org.mpxj.MpxjEnum;
import org.mpxj.common.EnumHelper;
import org.mpxj.common.NumberHelper;

public enum TimeUnit implements MpxjEnum
{
    MINUTES(0, "m", false),
    HOURS(1, "h", false),
    DAYS(2, "d", false),
    WEEKS(3, "w", false),
    MONTHS(4, "mo", false),
    PERCENT(5, "%", false),
    YEARS(6, "y", false),
    ELAPSED_MINUTES(7, "em", true),
    ELAPSED_HOURS(8, "eh", true),
    ELAPSED_DAYS(9, "ed", true),
    ELAPSED_WEEKS(10, "ew", true),
    ELAPSED_MONTHS(11, "emo", true),
    ELAPSED_YEARS(12, "ey", true),
    ELAPSED_PERCENT(13, "e%", true);

    private static final TimeUnit[] TYPE_VALUES;
    private final int m_value;
    private final String m_name;
    private final boolean m_elapsed;

    private TimeUnit(int type, String name, boolean elapsed) {
        this.m_value = type;
        this.m_name = name;
        this.m_elapsed = elapsed;
    }

    public static TimeUnit getInstance(int type) {
        if (type < 0 || type >= TYPE_VALUES.length) {
            type = DAYS.getValue();
        }
        return TYPE_VALUES[type];
    }

    public static TimeUnit getInstance(Number type) {
        int value = type == null ? -1 : NumberHelper.getInt(type);
        return TimeUnit.getInstance(value);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean isElapsed() {
        return this.m_elapsed;
    }

    public String toString() {
        return this.getName();
    }

    static {
        TYPE_VALUES = (TimeUnit[])EnumHelper.createTypeArray(TimeUnit.class);
    }
}

