/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mpxj.CustomFieldContainer;
import org.mpxj.UserDefinedField;

public class UserDefinedFieldContainer
implements Collection<UserDefinedField> {
    private final CustomFieldContainer m_customFields;
    private final Map<Integer, UserDefinedField> m_taskFields = new HashMap<Integer, UserDefinedField>();
    private final Map<Integer, UserDefinedField> m_resourceFields = new HashMap<Integer, UserDefinedField>();
    private final Map<Integer, UserDefinedField> m_assignmentFields = new HashMap<Integer, UserDefinedField>();
    private final Map<Integer, UserDefinedField> m_projectFields = new HashMap<Integer, UserDefinedField>();
    private final Map<Integer, UserDefinedField> m_uniqueIDMap = new HashMap<Integer, UserDefinedField>();

    public UserDefinedFieldContainer(CustomFieldContainer customFields) {
        this.m_customFields = customFields;
    }

    @Override
    public Iterator<UserDefinedField> iterator() {
        return this.m_uniqueIDMap.values().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.m_uniqueIDMap.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.m_uniqueIDMap.values().toArray(a);
    }

    @Override
    public boolean add(UserDefinedField field) {
        Map<Integer, UserDefinedField> map = this.getMapFromFieldTypeClass(field);
        if (map == null) {
            return false;
        }
        map.put(field.getUniqueID(), field);
        this.addField(field);
        return true;
    }

    private Map<Integer, UserDefinedField> getMapFromFieldTypeClass(UserDefinedField field) {
        Map<Integer, UserDefinedField> map;
        switch (field.getFieldTypeClass()) {
            case TASK: {
                map = this.m_taskFields;
                break;
            }
            case RESOURCE: {
                map = this.m_resourceFields;
                break;
            }
            case ASSIGNMENT: {
                map = this.m_assignmentFields;
                break;
            }
            case PROJECT: {
                map = this.m_projectFields;
                break;
            }
            default: {
                map = null;
            }
        }
        return map;
    }

    @Override
    public boolean remove(Object o) {
        this.m_customFields.remove((UserDefinedField)o);
        this.m_taskFields.remove(o);
        this.m_resourceFields.remove(o);
        this.m_assignmentFields.remove(o);
        this.m_projectFields.remove(o);
        return this.m_uniqueIDMap.remove(((UserDefinedField)o).getUniqueID(), o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.m_uniqueIDMap.values().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends UserDefinedField> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.m_taskFields.clear();
        this.m_resourceFields.clear();
        this.m_assignmentFields.clear();
        this.m_projectFields.clear();
    }

    @Override
    public void forEach(Consumer<? super UserDefinedField> action) {
        this.m_uniqueIDMap.values().forEach(action);
    }

    @Override
    public Spliterator<UserDefinedField> spliterator() {
        return this.m_uniqueIDMap.values().spliterator();
    }

    @Override
    public int size() {
        return this.m_uniqueIDMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_uniqueIDMap.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.m_uniqueIDMap.containsValue(o);
    }

    public Collection<UserDefinedField> getTaskFields() {
        return this.m_taskFields.values();
    }

    public Collection<UserDefinedField> getResourceFields() {
        return this.m_resourceFields.values();
    }

    public Collection<UserDefinedField> getAssignmentFields() {
        return this.m_assignmentFields.values();
    }

    public Collection<UserDefinedField> getProjectFields() {
        return this.m_projectFields.values();
    }

    public UserDefinedField getOrCreateTaskField(Integer id, Function<Integer, UserDefinedField> createFunction) {
        return this.m_taskFields.computeIfAbsent(id, i -> this.addField((UserDefinedField)createFunction.apply((Integer)i)));
    }

    public UserDefinedField getOrCreateResourceField(Integer id, Function<Integer, UserDefinedField> createFunction) {
        return this.m_resourceFields.computeIfAbsent(id, i -> this.addField((UserDefinedField)createFunction.apply((Integer)i)));
    }

    public UserDefinedField getOrCreateAssignmentField(Integer id, Function<Integer, UserDefinedField> createFunction) {
        return this.m_assignmentFields.computeIfAbsent(id, i -> this.addField((UserDefinedField)createFunction.apply((Integer)i)));
    }

    public UserDefinedField getOrCreateProjectField(Integer id, Function<Integer, UserDefinedField> createFunction) {
        return this.m_projectFields.computeIfAbsent(id, i -> this.addField((UserDefinedField)createFunction.apply((Integer)i)));
    }

    public UserDefinedField getByUniqueID(Integer id) {
        return this.m_uniqueIDMap.get(id);
    }

    private UserDefinedField addField(UserDefinedField field) {
        this.m_uniqueIDMap.put(field.getUniqueID(), field);
        return field;
    }
}

