/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.asta;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mpxj.DayType;
import org.mpxj.MPXJException;
import org.mpxj.ProjectFile;
import org.mpxj.asta.AstaDatabaseException;
import org.mpxj.asta.AstaReader;
import org.mpxj.asta.Row;
import org.mpxj.asta.RowComparator;
import org.mpxj.common.HierarchyHelper;
import org.mpxj.reader.AbstractProjectFileReader;

abstract class AbstractAstaDatabaseReader
extends AbstractProjectFileReader {
    private AstaReader m_reader;
    private Map<String, Integer> m_projectKey;
    private static final RowComparator ALLOCATION_COMPARATOR = new RowComparator("ID");
    private static final Map<String, String> PROJECT_SUMMARY_NAME_MAP = new HashMap<String, String>();
    private static final Map<String, String> BAR_NAME_MAP;
    private static final Map<String, String> TASK_NAME_MAP;
    private static final Map<String, String> EXPANDED_TASK_NAME_MAP;
    private static final Map<String, String> MILESTONE_NAME_MAP;
    private static final Map<String, String> WORK_PATTERN_NAME_MAP;
    private static final Map<String, String> CALENDAR_NAME_MAP;
    private static final Map<String, String> PERMANENT_RESOURCE_NAME_MAP;
    private static final Map<String, String> CONSUMABLE_RESOURCE_RESOURCE_NAME_MAP;
    private static final Map<String, String> LINK_NAME_MAP;
    private static final Map<String, String> ALLOCATION_NAME_MAP;
    private static final Map<String, String> PROGRESS_PERIOD_NAME_MAP;
    private static final Map<String, String> EXCEPTION_NAME_MAP;
    private static final Map<String, String> COMPLETED_SECTION_NAME_MAP;
    private static final Map<String, String> SKILL_NAME_MAP;
    private static final Map<String, String> EXCEPTION_ASSIGNMENT_MAP;
    private static final Map<String, String> TIME_ENTRY_NAME_MAP;

    AbstractAstaDatabaseReader() {
    }

    public Map<Integer, String> listProjects() throws MPXJException {
        try {
            HashMap<Integer, String> result = new HashMap<Integer, String>();
            List<Row> rows = this.getRows("project_summary", Collections.emptyMap(), PROJECT_SUMMARY_NAME_MAP);
            for (Row row : rows) {
                Integer id = row.getInteger("PROJID");
                String name = row.getString("SHORT_NAME");
                result.put(id, name);
            }
            return result;
        }
        catch (AstaDatabaseException ex) {
            throw new MPXJException("Error reading file", ex);
        }
    }

    public ProjectFile read() throws MPXJException {
        try {
            this.m_reader = new AstaReader();
            ProjectFile project = this.m_reader.getProject();
            this.addListenersToProject(project);
            this.processProjectProperties();
            this.processCalendars();
            this.processResources();
            this.processTasks();
            this.processPredecessors();
            this.processAssignments();
            project.readComplete();
            this.m_reader = null;
            ProjectFile projectFile = project;
            return projectFile;
        }
        catch (AstaDatabaseException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        finally {
            this.releaseResources();
        }
    }

    private void processProjectProperties() throws AstaDatabaseException {
        List<Row> schemaVersionRows = this.getRows("dodschem", Collections.emptyMap());
        List<Row> projectSummaryRows = this.getRows("project_summary", this.m_projectKey, PROJECT_SUMMARY_NAME_MAP);
        List<Row> progressPeriodRows = this.getRows("progress_period", this.m_projectKey, PROGRESS_PERIOD_NAME_MAP);
        List<Row> userSettingsRows = this.getRows("userr", this.m_projectKey);
        Integer schemaVersion = schemaVersionRows.isEmpty() ? null : schemaVersionRows.get(0).getInteger("SCHVER");
        Row projectSummary = projectSummaryRows.isEmpty() ? null : projectSummaryRows.get(0);
        Row userSettings = userSettingsRows.isEmpty() ? null : userSettingsRows.get(0);
        List<Row> progressPeriods = progressPeriodRows.isEmpty() ? null : progressPeriodRows;
        this.m_reader.processProjectProperties(schemaVersion, projectSummary, userSettings, progressPeriods);
    }

    private void processCalendars() throws AstaDatabaseException {
        List<Row> rows = this.getRows("exceptionn", Collections.emptyMap(), EXCEPTION_NAME_MAP);
        Map<Integer, DayType> exceptionMap = this.m_reader.createExceptionTypeMap(rows);
        rows = this.getRows("work_pattern", Collections.emptyMap(), WORK_PATTERN_NAME_MAP);
        Map<Integer, Row> workPatternMap = this.m_reader.createWorkPatternMap(rows);
        rows = this.getRows("work_pattern_assignment", Collections.emptyMap());
        Map<Integer, List<Row>> workPatternAssignmentMap = this.m_reader.createWorkPatternAssignmentMap(rows);
        rows = this.sortRows(this.getRows("exception_assignment", Collections.emptyMap(), EXCEPTION_ASSIGNMENT_MAP), "EXCEPTION_ASSIGNMENT_ID", "ORDF");
        Map<Integer, List<Row>> exceptionAssignmentMap = this.m_reader.createExceptionAssignmentMap(rows);
        rows = this.sortRows(this.getRows("time_entry", Collections.emptyMap(), TIME_ENTRY_NAME_MAP), "TIME_ENTRYID", "ORDF");
        Map<Integer, List<Row>> timeEntryMap = this.m_reader.createTimeEntryMap(rows);
        rows = this.getRows("calendar", this.m_projectKey, CALENDAR_NAME_MAP);
        rows = HierarchyHelper.sortHierarchy(rows, r -> r.getInteger("ID"), r -> r.getInteger("CALENDAR"));
        for (Row row : rows) {
            this.m_reader.processCalendar(row, workPatternMap, workPatternAssignmentMap, exceptionAssignmentMap, timeEntryMap, exceptionMap);
        }
    }

    private void processResources() throws AstaDatabaseException {
        List<Row> permanentRows = this.sortRows(this.getRows("permanent_resource", this.m_projectKey, PERMANENT_RESOURCE_NAME_MAP), "ID");
        List<Row> consumableRows = this.sortRows(this.getRows("consumable_resource", this.m_projectKey, CONSUMABLE_RESOURCE_RESOURCE_NAME_MAP), "ID");
        this.m_reader.processResources(permanentRows, consumableRows);
    }

    private void processTasks() throws AstaDatabaseException {
        List<Row> bars = this.getRows("bar", this.m_projectKey, BAR_NAME_MAP);
        List<Row> expandedTasks = this.getRows("expanded_task", this.m_projectKey, EXPANDED_TASK_NAME_MAP);
        List<Row> tasks = this.getRows("task", this.m_projectKey, TASK_NAME_MAP);
        List<Row> milestones = this.getRows("milestone", this.m_projectKey, MILESTONE_NAME_MAP);
        List<Row> hammocks = this.getRows("hammock_task", this.m_projectKey);
        List<Row> completedSections = this.getRows("task_completed_section", this.m_projectKey, COMPLETED_SECTION_NAME_MAP);
        this.m_reader.processTasks(bars, expandedTasks, tasks, milestones, hammocks, completedSections);
    }

    private void processPredecessors() throws AstaDatabaseException {
        List<Row> rows = this.sortRows(this.getRows("link", this.m_projectKey, LINK_NAME_MAP), "ID");
        this.m_reader.processPredecessors(rows);
    }

    private void processAssignments() throws AstaDatabaseException {
        List<Row> allocationRows = this.getRows("permanent_schedul_allocation", this.m_projectKey, ALLOCATION_NAME_MAP);
        List<Row> skillRows = this.getRows("perm_resource_skill", this.m_projectKey, SKILL_NAME_MAP);
        allocationRows.sort(ALLOCATION_COMPARATOR);
        this.m_reader.processAssignments(allocationRows, skillRows);
    }

    public void setProjectID(int projectID) {
        this.m_projectKey = Collections.singletonMap("PROJID", projectID);
    }

    @Override
    public ProjectFile read(File file) throws MPXJException {
        try {
            this.allocateResources(file);
            this.setProjectID(0);
            ProjectFile projectFile = this.read();
            return projectFile;
        }
        catch (AstaDatabaseException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        finally {
            this.releaseResources();
        }
    }

    @Override
    public List<ProjectFile> readAll(File file) throws MPXJException {
        try {
            this.allocateResources(file);
            ArrayList<ProjectFile> result = new ArrayList<ProjectFile>();
            Set<Integer> ids = this.listProjects().keySet();
            for (Integer id : ids) {
                this.setProjectID(id);
                result.add(this.read());
            }
            ArrayList<ProjectFile> arrayList = result;
            return arrayList;
        }
        catch (AstaDatabaseException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        finally {
            this.releaseResources();
        }
    }

    protected abstract List<Row> getRows(String var1, Map<String, Integer> var2) throws AstaDatabaseException;

    protected abstract List<Row> getRows(String var1, Map<String, Integer> var2, Map<String, String> var3) throws AstaDatabaseException;

    protected abstract void allocateResources(File var1) throws AstaDatabaseException;

    protected abstract void releaseResources();

    private List<Row> sortRows(List<Row> rows, String ... columnNames) {
        Comparator<Row> comparator = Comparator.comparing(r -> r.getInt(columnNames[0]));
        if (columnNames.length > 1) {
            for (int index = 1; index < columnNames.length; ++index) {
                String columnName = columnNames[index];
                comparator = comparator.thenComparing(r -> r.getInt(columnName));
            }
        }
        rows.sort(comparator);
        return rows;
    }

    static {
        PROJECT_SUMMARY_NAME_MAP.put("STARU", "PROJECT_START");
        PROJECT_SUMMARY_NAME_MAP.put("ENE", "PROJECT_END");
        PROJECT_SUMMARY_NAME_MAP.put("DURATIONHOURS", "DURATION");
        BAR_NAME_MAP = new HashMap<String, String>();
        BAR_NAME_MAP.put("NAMH", "NAME");
        BAR_NAME_MAP.put("STARV", "BAR_START");
        BAR_NAME_MAP.put("ENF", "BAR_FINISH");
        TASK_NAME_MAP = new HashMap<String, String>();
        TASK_NAME_MAP.put("NARE", "NAME");
        TASK_NAME_MAP.put("OVERALL_PERCENV_COMPLETE", "OVERALL_PERCENT_COMPLETE");
        TASK_NAME_MAP.put("CONSTRAINU", "CONSTRAINT_FLAG");
        TASK_NAME_MAP.put("CALENDAU", "CALENDAR");
        TASK_NAME_MAP.put("GIVEN_DURATIONHOURS", "GIVEN_DURATION");
        TASK_NAME_MAP.put("WBT", "WBS");
        TASK_NAME_MAP.put("STARZ", "LINKABLE_START");
        TASK_NAME_MAP.put("ENJ", "LINKABLE_FINISH");
        TASK_NAME_MAP.put("ACTUAL_DURATIONHOURS", "ACTUAL_DURATION");
        TASK_NAME_MAP.put("NOTET", "NOTES");
        TASK_NAME_MAP.put("DURATION_TIMJ_UNIT", "DURATION_TIME_UNIT");
        TASK_NAME_MAP.put("NATURAO_ORDER", "NATURAL_ORDER");
        EXPANDED_TASK_NAME_MAP = new HashMap<String, String>();
        EXPANDED_TASK_NAME_MAP.put("NARE", "NAME");
        EXPANDED_TASK_NAME_MAP.put("OVERALL_PERCENV_COMPLETE", "OVERALL_PERCENT_COMPLETE");
        EXPANDED_TASK_NAME_MAP.put("CONSTRAINU", "CONSTRAINT_FLAG");
        EXPANDED_TASK_NAME_MAP.put("CALENDAU", "CALENDAR");
        MILESTONE_NAME_MAP = new HashMap<String, String>();
        MILESTONE_NAME_MAP.put("NARE", "NAME");
        MILESTONE_NAME_MAP.put("OVERALL_PERCENV_COMPLETE", "OVERALL_PERCENT_COMPLETE");
        MILESTONE_NAME_MAP.put("CONSTRAINU", "CONSTRAINT_FLAG");
        MILESTONE_NAME_MAP.put("CALENDAU", "CALENDAR");
        MILESTONE_NAME_MAP.put("WBT", "WBS");
        MILESTONE_NAME_MAP.put("NATURAO_ORDER", "NATURAL_ORDER");
        WORK_PATTERN_NAME_MAP = new HashMap<String, String>();
        WORK_PATTERN_NAME_MAP.put("WORK_PATTERNID", "ID");
        WORK_PATTERN_NAME_MAP.put("NAMN", "NAME");
        CALENDAR_NAME_MAP = new HashMap<String, String>();
        CALENDAR_NAME_MAP.put("CALENDARID", "ID");
        CALENDAR_NAME_MAP.put("NAMK", "NAME");
        PERMANENT_RESOURCE_NAME_MAP = new HashMap<String, String>();
        PERMANENT_RESOURCE_NAME_MAP.put("PERMANENT_RESOURCEID", "ID");
        PERMANENT_RESOURCE_NAME_MAP.put("NASE", "NAME");
        PERMANENT_RESOURCE_NAME_MAP.put("CALENDAV", "CALENDAR");
        CONSUMABLE_RESOURCE_RESOURCE_NAME_MAP = new HashMap<String, String>();
        CONSUMABLE_RESOURCE_RESOURCE_NAME_MAP.put("CONSUMABLE_RESOURCEID", "ID");
        CONSUMABLE_RESOURCE_RESOURCE_NAME_MAP.put("NASE", "NAME");
        CONSUMABLE_RESOURCE_RESOURCE_NAME_MAP.put("CALENDAV", "CALENDAR");
        LINK_NAME_MAP = new HashMap<String, String>();
        LINK_NAME_MAP.put("LINKID", "ID");
        LINK_NAME_MAP.put("START_LAG_TIMEHOURS", "START_LAG_TIME");
        LINK_NAME_MAP.put("END_LAG_TIMEHOURS", "END_LAG_TIME");
        LINK_NAME_MAP.put("TYPI", "LINK_KIND");
        ALLOCATION_NAME_MAP = new HashMap<String, String>();
        ALLOCATION_NAME_MAP.put("PERMANENT_SCHEDUL_ALLOCATIONID", "ID");
        ALLOCATION_NAME_MAP.put("STARZ", "LINKABLE_START");
        ALLOCATION_NAME_MAP.put("ENJ", "LINKABLE_FINISH");
        ALLOCATION_NAME_MAP.put("ALLOCATEE_TO", "ALLOCATED_TO");
        ALLOCATION_NAME_MAP.put("EFFORW", "EFFORT");
        ALLOCATION_NAME_MAP.put("DELAAHOURS", "DELAY");
        ALLOCATION_NAME_MAP.put("ALLOCATIOP_OF", "ALLOCATION_OF");
        PROGRESS_PERIOD_NAME_MAP = new HashMap<String, String>();
        PROGRESS_PERIOD_NAME_MAP.put("PROGRESS_PERIODID", "ID");
        EXCEPTION_NAME_MAP = new HashMap<String, String>();
        EXCEPTION_NAME_MAP.put("EXCEPTIONNID", "ID");
        COMPLETED_SECTION_NAME_MAP = new HashMap<String, String>();
        COMPLETED_SECTION_NAME_MAP.put("TASK_COMPLETED_SECTIONID", "ID");
        SKILL_NAME_MAP = new HashMap<String, String>();
        SKILL_NAME_MAP.put("PERM_RESOURCE_SKILLID", "ID");
        EXCEPTION_ASSIGNMENT_MAP = new HashMap<String, String>();
        EXCEPTION_ASSIGNMENT_MAP.put("STARU_DATE", "START_DATE");
        EXCEPTION_ASSIGNMENT_MAP.put("ENE_DATE", "END_DATE");
        TIME_ENTRY_NAME_MAP = new HashMap<String, String>();
        TIME_ENTRY_NAME_MAP.put("EXCEPTIOP", "EXCEPTION");
    }
}

