/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.asta;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mpxj.DayType;
import org.mpxj.MPXJException;
import org.mpxj.ProjectFile;
import org.mpxj.asta.AstaReader;
import org.mpxj.asta.DatatypeConverter;
import org.mpxj.asta.MapRow;
import org.mpxj.asta.Row;
import org.mpxj.common.AutoCloseableHelper;
import org.mpxj.common.HierarchyHelper;
import org.mpxj.common.SQLite;
import org.mpxj.reader.AbstractProjectFileReader;

public class AstaSqliteReader
extends AbstractProjectFileReader {
    private AstaReader m_reader;
    private Integer m_projectID;
    private Connection m_connection;
    private static final Integer DEFAULT_PROJECT_ID = 0;

    @Override
    public ProjectFile read(File file) throws MPXJException {
        try {
            this.m_connection = SQLite.createConnection(file, SQLite.dateFormatProperties());
            ProjectFile projectFile = this.read();
            return projectFile;
        }
        catch (SQLException ex) {
            throw new MPXJException("Failed to create connection", ex);
        }
        finally {
            AutoCloseableHelper.closeQuietly(this.m_connection);
        }
    }

    public ProjectFile read() throws MPXJException {
        ProjectFile project = this.read(DEFAULT_PROJECT_ID);
        this.processBaseline(project, DEFAULT_PROJECT_ID);
        return project;
    }

    private ProjectFile read(Integer projectID) throws MPXJException {
        try {
            this.m_projectID = projectID;
            this.m_reader = new AstaReader();
            ProjectFile project = this.m_reader.getProject();
            this.addListenersToProject(project);
            this.processProjectProperties();
            this.processCalendars();
            this.processResources();
            this.processTasks();
            this.processPredecessors();
            this.processAssignments();
            this.processUserDefinedFields();
            this.processCodeLibraries();
            project.readComplete();
            this.m_reader = null;
            return project;
        }
        catch (SQLException ex) {
            throw new MPXJException("Error reading file", ex);
        }
    }

    private void processProjectProperties() throws SQLException {
        List<Row> schemaVersionRows = this.getRows("select * from dodschem");
        List<Row> projectSummaryRows = this.getRows("select * from project_summary where projid=?", this.m_projectID);
        List<Row> progressPeriodRows = this.getRows("select * from progress_period where projid=?", this.m_projectID);
        List<Row> userSettingsRows = this.getRows("select * from userr where projid=?", this.m_projectID);
        Integer schemaVersion = schemaVersionRows.isEmpty() ? null : schemaVersionRows.get(0).getInteger("SCHVER");
        Row projectSummary = projectSummaryRows.isEmpty() ? null : projectSummaryRows.get(0);
        Row userSettings = userSettingsRows.isEmpty() ? null : userSettingsRows.get(0);
        List<Row> progressPeriods = progressPeriodRows.isEmpty() ? null : progressPeriodRows;
        this.m_reader.processProjectProperties(schemaVersion, projectSummary, userSettings, progressPeriods);
    }

    private void processCalendars() throws SQLException {
        List<Row> rows = this.getRows("select * from exceptionn");
        Map<Integer, DayType> exceptionTypeMap = this.m_reader.createExceptionTypeMap(rows);
        rows = this.getRows("select * from work_pattern");
        Map<Integer, Row> workPatternMap = this.m_reader.createWorkPatternMap(rows);
        rows = this.getRows("select id, work_patterns from calendar");
        Map<Integer, List<Row>> workPatternAssignmentMap = this.createWorkPatternAssignmentMap(rows);
        rows = this.getRows("select id, exceptions from calendar");
        Map<Integer, List<Row>> exceptionAssignmentMap = this.createExceptionAssignmentMap(rows);
        rows = this.getRows("select id, shifts from work_pattern");
        Map<Integer, List<Row>> timeEntryMap = this.createTimeEntryMap(rows);
        rows = this.getRows("select * from calendar where projid=? order by id", this.m_projectID);
        rows = HierarchyHelper.sortHierarchy(rows, r -> r.getInteger("ID"), r -> r.getInteger("CALENDAR"));
        for (Row row : rows) {
            this.m_reader.processCalendar(row, workPatternMap, workPatternAssignmentMap, exceptionAssignmentMap, timeEntryMap, exceptionTypeMap);
        }
    }

    private void processResources() throws SQLException {
        List<Row> permanentRows = this.getRows("select * from permanent_resource where projid=? order by id", this.m_projectID);
        List<Row> consumableRows = this.getRows("select * from consumable_resource where projid=? order by id", this.m_projectID);
        this.m_reader.processResources(permanentRows, consumableRows);
    }

    private void processTasks() throws SQLException {
        List<Row> bars = this.getRows("select id as barid, * from bar where projid=?", this.m_projectID);
        List<Row> expandedTasks = this.getRows("select id as expanded_taskid, * from expanded_task where projid=?", this.m_projectID);
        List<Row> tasks = this.getRows("select id as taskid, * from task where projid=?", this.m_projectID);
        List<Row> milestones = this.getRows("select id as milestoneid, * from milestone where projid=?", this.m_projectID);
        List<Row> hammocks = this.getRows("select id as hammock_taskid, * from hammock_task where projid=?", this.m_projectID);
        List<Row> completedSections = this.getRows("select * from task_completed_section where projid=? order by id", this.m_projectID);
        this.m_reader.processTasks(bars, expandedTasks, tasks, milestones, hammocks, completedSections);
    }

    private void processPredecessors() throws SQLException {
        List<Row> rows = this.getRows("select * from link where projid=? order by id", this.m_projectID);
        this.m_reader.processPredecessors(rows);
    }

    private void processAssignments() throws SQLException {
        List<Row> allocationRows = this.getRows("select * from permanent_schedul_allocation where projid=? order by id", this.m_projectID);
        List<Row> skillRows = this.getRows("select * from perm_resource_skill where projid=?", this.m_projectID);
        this.m_reader.processAssignments(allocationRows, skillRows);
    }

    private void processUserDefinedFields() throws SQLException {
        List<Row> definitions = this.getRows("select * from udf_defn");
        List<Row> data = this.getRows("select * from udf_data");
        this.m_reader.processUserDefinedFields(definitions, data);
    }

    /*
     * Exception decompiling
     */
    private List<Row> getRows(String sql) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, Integer> populateMetaData(ResultSet rs) throws SQLException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount() + 1;
        for (int loop = 1; loop < columnCount; ++loop) {
            String name = meta.getColumnName(loop);
            String typeName = meta.getColumnTypeName(loop);
            Integer type = "NTEXT".equals(typeName) ? Integer.valueOf(1) : Integer.valueOf(meta.getColumnType(loop));
            map.put(name, type);
        }
        return map;
    }

    /*
     * Exception decompiling
     */
    private List<Row> getRows(String sql, Integer var) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<Integer, List<Row>> createWorkPatternAssignmentMap(List<Row> rows) {
        HashMap<Integer, List<Row>> map = new HashMap<Integer, List<Row>>();
        for (Row row : rows) {
            Integer calendarID = row.getInteger("ID");
            String workPatterns = row.getString("WORK_PATTERNS");
            map.put(calendarID, this.createWorkPatternAssignmentRowList(workPatterns));
        }
        return map;
    }

    private List<Row> createWorkPatternAssignmentRowList(String workPatterns) {
        ArrayList<Row> list = new ArrayList<Row>();
        String[] patterns = workPatterns.split("[,:]");
        for (int index = 1; index < patterns.length; index += 5) {
            Integer workPattern = Integer.valueOf(patterns[index + 1]);
            LocalDateTime startDate = DatatypeConverter.parseBasicTimestamp(patterns[index + 3]);
            LocalDateTime endDate = DatatypeConverter.parseBasicTimestamp(patterns[index + 4]);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("WORK_PATTERN", workPattern);
            map.put("START_DATE", startDate);
            map.put("END_DATE", endDate);
            list.add(new MapRow(map));
        }
        return list;
    }

    private Map<Integer, List<Row>> createExceptionAssignmentMap(List<Row> rows) {
        HashMap<Integer, List<Row>> map = new HashMap<Integer, List<Row>>();
        for (Row row : rows) {
            Integer calendarID = row.getInteger("ID");
            String exceptions = row.getString("EXCEPTIONS");
            map.put(calendarID, this.createExceptionAssignmentRowList(exceptions));
        }
        return map;
    }

    private List<Row> createExceptionAssignmentRowList(String exceptionData) {
        ArrayList<Row> list = new ArrayList<Row>();
        String[] exceptions = exceptionData.split("[,:]");
        for (int index = 1; index < exceptions.length; index += 3) {
            LocalDateTime startDate = DatatypeConverter.parseEpochTimestamp(exceptions[index]);
            LocalDateTime endDate = DatatypeConverter.parseEpochTimestamp(exceptions[index + 1]);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("START_DATE", startDate);
            map.put("END_DATE", endDate);
            list.add(new MapRow(map));
        }
        return list;
    }

    private Map<Integer, List<Row>> createTimeEntryMap(List<Row> rows) {
        HashMap<Integer, List<Row>> map = new HashMap<Integer, List<Row>>();
        for (Row row : rows) {
            Integer workPatternID = row.getInteger("ID");
            String shifts = row.getString("SHIFTS");
            map.put(workPatternID, this.createTimeEntryRowList(shifts));
        }
        return map;
    }

    private List<Row> createTimeEntryRowList(String shiftData) {
        ArrayList<Row> list = new ArrayList<Row>();
        String[] shifts = shiftData.split("[,:]");
        int index = 1;
        while (index < shifts.length) {
            int entryCount = Integer.parseInt(shifts[index += 2]);
            ++index;
            for (int entryIndex = 0; entryIndex < entryCount; ++entryIndex) {
                Integer exceptionTypeID = Integer.valueOf(shifts[index]);
                LocalDateTime startTime = DatatypeConverter.parseBasicTime(shifts[index + 1]);
                LocalDateTime endTime = DatatypeConverter.parseBasicTime(shifts[index + 2]);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("START_TIME", startTime);
                map.put("END_TIME", endTime);
                map.put("EXCEPTION", exceptionTypeID);
                list.add(new MapRow(map));
                index += 3;
            }
        }
        return list;
    }

    private void processBaseline(ProjectFile project, Integer projectID) throws MPXJException {
        try {
            Integer baselineProjectID;
            List<Row> baseline = this.getRows("select baseline_summary.baseline_project_id from baseline_summary join userr on userr.projid = baseline_summary.projid and userr.current_baseline_id = baseline_summary.baseline_id join project_summary on project_summary.projid = baseline_summary.baseline_project_id where baseline_summary.projid=?", projectID);
            if (!baseline.isEmpty() && (baselineProjectID = baseline.get(0).getInteger("BASELINE_PROJECT_ID")) != null && !baselineProjectID.equals(projectID)) {
                ProjectFile baselineProject = this.read(baselineProjectID);
                project.setBaseline(baselineProject);
            }
        }
        catch (SQLException ex) {
            throw new MPXJException("Failed to read baseline data", ex);
        }
    }

    private void processCodeLibraries() throws SQLException {
        List<Row> types = this.getRows("select * from code_library where projid=?", this.m_projectID);
        List<Row> typeValues = this.getRows("select * from code_library_entry where projid=?", this.m_projectID);
        List<Row> assignments = this.getRows("select * from code_library_assignabl_codes where projid=?", this.m_projectID);
        this.m_reader.processCodeLibraries(types, typeValues, assignments);
    }
}

