/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.asta;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Row;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mpxj.asta.MapRow;
import org.mpxj.common.NumberHelper;

final class JackcessResultSetRow
extends MapRow {
    public JackcessResultSetRow(Map<String, String> nameMap, Row row, List<? extends Column> columns) {
        super(new HashMap<String, Object>());
        for (Column column : columns) {
            Object value;
            String name = column.getName().toUpperCase();
            DataType type = column.getType();
            switch (type) {
                case BOOLEAN: {
                    value = row.getBoolean(name);
                    break;
                }
                case MEMO: 
                case TEXT: 
                case GUID: {
                    value = row.getString(name);
                    break;
                }
                case EXT_DATE_TIME: 
                case SHORT_DATE_TIME: {
                    value = row.getLocalDateTime(name);
                    break;
                }
                case DOUBLE: 
                case FLOAT: 
                case MONEY: 
                case NUMERIC: {
                    value = row.getDouble(name);
                    break;
                }
                case BIG_INT: 
                case BYTE: 
                case LONG: {
                    value = row.getInt(name);
                    break;
                }
                case INT: {
                    value = NumberHelper.getInteger(row.getShort(name));
                    break;
                }
                case OLE: 
                case BINARY: {
                    value = row.getBytes(name);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported type: " + type + " for column " + name);
                }
            }
            this.m_map.put(nameMap.getOrDefault(name, name), value);
        }
    }
}

