/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.common;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import org.mpxj.Duration;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarHours;
import org.mpxj.TimePeriodEntity;
import org.mpxj.TimeUnit;
import org.mpxj.TimephasedWork;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.common.LocalTimeHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.common.TimephasedNormaliser;

public abstract class AbstractTimephasedWorkNormaliser
implements TimephasedNormaliser<TimephasedWork> {
    protected void mergeSameWork(ProjectCalendar calendar, TimePeriodEntity parent, List<TimephasedWork> list) {
        ArrayList<TimephasedWork> result = new ArrayList<TimephasedWork>();
        TimephasedWork previousTimephasedWork = null;
        for (TimephasedWork item : list) {
            if (previousTimephasedWork == null) {
                item.setAmountPerDay(item.getTotalAmount());
                result.add(item);
            } else {
                if (this.workCanBeMerged(calendar, parent, previousTimephasedWork, item)) {
                    Duration currentWork = (Duration)item.getTotalAmount();
                    LocalDateTime timephasedWorkStart = previousTimephasedWork.getStart();
                    LocalDateTime timephasedWorkFinish = item.getFinish();
                    double total = ((Duration)previousTimephasedWork.getTotalAmount()).getDuration();
                    Duration totalWork = Duration.getInstance(total += currentWork.getDuration(), TimeUnit.MINUTES);
                    TimephasedWork merged = new TimephasedWork();
                    merged.setStart(timephasedWorkStart);
                    merged.setFinish(timephasedWorkFinish);
                    merged.setAmountPerDay(currentWork);
                    merged.setTotalAmount(totalWork);
                    result.remove(result.size() - 1);
                    item = merged;
                } else {
                    item.setAmountPerDay(item.getTotalAmount());
                }
                result.add(item);
            }
            previousTimephasedWork = item;
        }
        list.clear();
        list.addAll(result);
    }

    private boolean workCanBeMerged(ProjectCalendar calendar, TimePeriodEntity parent, TimephasedWork previousTimephasedWork, TimephasedWork currentTimephasedWork) {
        Duration previousAmount = (Duration)previousTimephasedWork.getAmountPerDay();
        Duration currentAmount = (Duration)currentTimephasedWork.getTotalAmount();
        boolean sameDuration = NumberHelper.equals(previousAmount.getDuration(), currentAmount.getDuration(), 0.01);
        if (!sameDuration) {
            return false;
        }
        boolean zeroDuration = NumberHelper.equals(previousAmount.getDuration(), 0.0, 0.01);
        if (zeroDuration) {
            return true;
        }
        return this.timephasedWorkHasStandardHours(calendar, parent, previousTimephasedWork) && this.timephasedWorkHasStandardHours(calendar, parent, currentTimephasedWork);
    }

    private boolean timephasedWorkHasStandardHours(ProjectCalendar calendar, TimePeriodEntity parent, TimephasedWork timephasedWork) {
        ProjectCalendarHours hours = calendar.getHours(timephasedWork.getStart());
        LocalTime calendarStart = hours.get(0).getStart();
        LocalTime timephasedStart = LocalTimeHelper.getLocalTime(timephasedWork.getStart());
        if (LocalDateTimeHelper.compare(parent.getStart(), timephasedWork.getStart()) != 0 && LocalTimeHelper.compare(calendarStart, timephasedStart) != 0) {
            return false;
        }
        LocalTime calendarEnd = hours.get(hours.size() - 1).getEnd();
        LocalTime timephasedEnd = LocalTimeHelper.getLocalTime(timephasedWork.getFinish());
        return LocalDateTimeHelper.compare(parent.getFinish(), timephasedWork.getFinish()) == 0 || LocalTimeHelper.compare(calendarEnd, timephasedEnd) == 0;
    }

    protected void convertToHours(List<TimephasedWork> list) {
        for (TimephasedWork item : list) {
            Duration totalWork = (Duration)item.getTotalAmount();
            Duration workPerDay = (Duration)item.getAmountPerDay();
            totalWork = Duration.getInstance(totalWork.getDuration() / 60.0, TimeUnit.HOURS);
            workPerDay = Duration.getInstance(workPerDay.getDuration() / 60.0, TimeUnit.HOURS);
            item.setTotalAmount(totalWork);
            item.setAmountPerDay(workPerDay);
        }
    }
}

