/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.common;

import java.text.DecimalFormat;

public final class ByteArrayHelper {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static final int getShort(byte[] data, int offset) {
        int result = 0;
        int i = offset;
        for (int shiftBy = 0; shiftBy < 16; shiftBy += 8) {
            result |= (data[i] & 0xFF) << shiftBy;
            ++i;
        }
        return result;
    }

    public static final int getInt(byte[] data, int offset) {
        int result = 0;
        int i = offset;
        for (int shiftBy = 0; shiftBy < 32; shiftBy += 8) {
            result |= (data[i] & 0xFF) << shiftBy;
            ++i;
        }
        return result;
    }

    public static final long getLong(byte[] data, int offset) {
        long result = 0L;
        int i = offset;
        for (int shiftBy = 0; shiftBy < 64; shiftBy += 8) {
            result |= (long)(data[i] & 0xFF) << shiftBy;
            ++i;
        }
        return result;
    }

    public static final String hexdump(byte[] buffer, int offset, int length, boolean ascii) {
        StringBuilder sb = new StringBuilder();
        if (buffer != null) {
            int loop;
            int count = offset + length;
            for (loop = offset; loop < count; ++loop) {
                sb.append(" ");
                sb.append(HEX_DIGITS[(buffer[loop] & 0xF0) >> 4]);
                sb.append(HEX_DIGITS[buffer[loop] & 0xF]);
            }
            if (ascii) {
                sb.append("   ");
                for (loop = offset; loop < count; ++loop) {
                    char c = (char)buffer[loop];
                    if (c > '\u00c8' || c < '\u001b') {
                        c = ' ';
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static final String hexdump(byte[] buffer, boolean ascii) {
        int length = 0;
        if (buffer != null) {
            length = buffer.length;
        }
        return ByteArrayHelper.hexdump(buffer, 0, length, ascii);
    }

    public static final String hexdump(byte[] buffer, boolean ascii, int columns, String prefix) {
        StringBuilder sb = new StringBuilder();
        if (buffer != null) {
            DecimalFormat df = new DecimalFormat("00000");
            for (int index = 0; index < buffer.length; index += columns) {
                if (index + columns > buffer.length) {
                    columns = buffer.length - index;
                }
                sb.append(prefix);
                sb.append(df.format(index));
                sb.append(":");
                sb.append(ByteArrayHelper.hexdump(buffer, index, columns, ascii));
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public static final String hexdump(byte[] buffer, int offset, int length, boolean ascii, int columns, String prefix) {
        StringBuilder sb = new StringBuilder();
        if (buffer != null) {
            DecimalFormat df = new DecimalFormat("00000");
            for (int index = offset; index < offset + length; index += columns) {
                if (index + columns > offset + length) {
                    columns = offset + length - index;
                }
                sb.append(prefix);
                sb.append(df.format(index - offset));
                sb.append(":");
                sb.append(ByteArrayHelper.hexdump(buffer, index, columns, ascii));
                sb.append('\n');
            }
        }
        return sb.toString();
    }
}

