/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.common;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalTime;
import org.mpxj.LocalTimeRange;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarHours;

public class CombinedCalendar
extends ProjectCalendar {
    private final ProjectCalendar m_calendar1;
    private final ProjectCalendar m_calendar2;

    public CombinedCalendar(ProjectCalendar calendar1, ProjectCalendar calendar2) {
        super(calendar1.getParentFile(), true);
        this.m_calendar1 = calendar1;
        this.m_calendar2 = calendar2;
    }

    @Override
    protected ProjectCalendarHours getRanges(LocalDate date) {
        return this.getRanges(this.m_calendar1.getHours(date), this.m_calendar2.getHours(date));
    }

    @Override
    protected ProjectCalendarHours getRanges(DayOfWeek day) {
        return this.getRanges(this.m_calendar1.getHours(day), this.m_calendar2.getHours(day));
    }

    private ProjectCalendarHours getRanges(ProjectCalendarHours hours1, ProjectCalendarHours hours2) {
        ProjectCalendarHours result = new ProjectCalendarHours();
        block0: for (LocalTimeRange range1 : hours1) {
            LocalTime range1Start = range1.getStart();
            LocalTime range1End = range1.getEnd();
            for (LocalTimeRange range2 : hours2) {
                LocalTime start;
                LocalTime range2Start = range2.getStart();
                if (range1End != LocalTime.MIDNIGHT && !range1End.isAfter(range2Start)) continue block0;
                LocalTime range2End = range2.getEnd();
                if (range2End != LocalTime.MIDNIGHT && !range1Start.isBefore(range2End)) continue;
                LocalTime localTime = start = range1Start.isAfter(range2Start) ? range1Start : range2Start;
                LocalTime end = range1End == LocalTime.MIDNIGHT ? range2End : (range2End == LocalTime.MIDNIGHT ? range1End : (range1End.isBefore(range2End) ? range1End : range2End));
                result.add(new LocalTimeRange(start, end));
            }
        }
        return result;
    }
}

