/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.common;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class HierarchyHelper {
    public static final <K, V> List<V> sortHierarchy(List<V> list, Function<V, K> getId, Function<V, K> getParentId) {
        return HierarchyHelper.sortHierarchy(list, getId, getParentId, null);
    }

    public static final <K, V> List<V> sortHierarchy(List<V> list, Function<V, K> getId, Function<V, K> getParentId, Comparator<V> comparator) {
        if (list.size() < 2 || list.stream().allMatch(v -> getParentId.apply(v) == null)) {
            return list;
        }
        HashMap nodes = new HashMap();
        list.forEach(i -> nodes.put(getId.apply(i), new HierarchyNode<Object>(i)));
        HierarchyNode root = new HierarchyNode();
        for (Map.Entry entry : nodes.entrySet()) {
            HierarchyNode parent = (HierarchyNode)nodes.get(getParentId.apply(((HierarchyNode)entry.getValue()).getItem()));
            (parent == null ? root : parent).addChild((HierarchyNode)entry.getValue());
        }
        return comparator == null ? HierarchyHelper.addChildNodes(new ArrayList(), root) : HierarchyHelper.addChildNodes(new ArrayList(), root, (o1, o2) -> comparator.compare(o1.getItem(), o2.getItem()));
    }

    private static <V> List<V> addChildNodes(List<V> list, HierarchyNode<V> parent) {
        parent.getChildNodes().forEach(c -> {
            list.add(c.getItem());
            HierarchyHelper.addChildNodes(list, c);
        });
        return list;
    }

    private static <V> List<V> addChildNodes(List<V> list, HierarchyNode<V> parent, Comparator<HierarchyNode<V>> hierarchyNodeComparator) {
        parent.getChildNodes().stream().sorted(hierarchyNodeComparator).forEach(c -> {
            list.add(c.getItem());
            HierarchyHelper.addChildNodes(list, c, hierarchyNodeComparator);
        });
        return list;
    }

    private static class HierarchyNode<V> {
        private final V m_item;
        private final List<HierarchyNode<V>> m_childNodes = new ArrayList<HierarchyNode<V>>();

        public HierarchyNode() {
            this(null);
        }

        public HierarchyNode(V item) {
            this.m_item = item;
        }

        public V getItem() {
            return this.m_item;
        }

        public void addChild(HierarchyNode<V> child) {
            this.m_childNodes.add(child);
        }

        public List<HierarchyNode<V>> getChildNodes() {
            return this.m_childNodes;
        }
    }
}

